/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.addon;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.bootstrap.PluginProviderContext;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.entrypoint.LaunchEntryPointHandler;
import io.papermc.paper.plugin.provider.PluginProvider;
import io.papermc.paper.plugin.storage.ProviderStorage;
import java.io.Closeable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;
import xyz.xenondevs.commons.version.Version;
import xyz.xenondevs.nova.NovaBootstrapperKt;
import xyz.xenondevs.nova.addon.Addon;
import xyz.xenondevs.nova.util.ServerUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0016H\u0002J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0016H\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lxyz/xenondevs/nova/addon/AddonBootstrapper;", "", "<init>", "()V", "_addons", "Ljava/util/ArrayList;", "Lxyz/xenondevs/nova/addon/Addon;", "Lkotlin/collections/ArrayList;", "addons", "", "getAddons$annotations", "getAddons", "()Ljava/util/List;", "bootstrap", "", "context", "Lio/papermc/paper/plugin/bootstrap/BootstrapContext;", "classLoader", "Ljava/lang/ClassLoader;", "handleJavaPluginCreated", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "Lio/papermc/paper/plugin/bootstrap/PluginProviderContext;", "readAddonMeta", "Lorg/spongepowered/configurate/ConfigurationNode;", "getAddonInstance", "addonMeta", "checkRequiredNovaVersion", "checkRequiredMinecraftVersion", "nova"})
@SourceDebugExtension(value={"SMAP\nAddonBootstrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddonBootstrapper.kt\nxyz/xenondevs/nova/addon/AddonBootstrapper\n+ 2 IOUtils.kt\nxyz/xenondevs/nova/util/data/IOUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,97:1\n64#2,3:98\n1#3:101\n1#3:102\n127#4,2:103\n*S KotlinDebug\n*F\n+ 1 AddonBootstrapper.kt\nxyz/xenondevs/nova/addon/AddonBootstrapper\n*L\n51#1:98,3\n51#1:101\n75#1:103,2\n*E\n"})
public final class AddonBootstrapper {
    @NotNull
    public static final AddonBootstrapper INSTANCE = new AddonBootstrapper();
    @NotNull
    private static final ArrayList<Addon> _addons = new ArrayList();

    private AddonBootstrapper() {
    }

    @NotNull
    public static final List<Addon> getAddons() {
        return _addons;
    }

    @JvmStatic
    public static /* synthetic */ void getAddons$annotations() {
    }

    @JvmStatic
    public static final void bootstrap(@NotNull BootstrapContext context, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        ConfigurationNode addonMeta = INSTANCE.readAddonMeta((PluginProviderContext)context);
        INSTANCE.checkRequiredNovaVersion((PluginProviderContext)context, addonMeta);
        INSTANCE.checkRequiredMinecraftVersion((PluginProviderContext)context);
        Addon addon = INSTANCE.getAddonInstance(addonMeta, classLoader);
        PluginMeta pluginMeta = context.getPluginMeta();
        Intrinsics.checkNotNullExpressionValue((Object)pluginMeta, (String)"getPluginMeta(...)");
        addon.setPluginMeta$nova(pluginMeta);
        Path path = context.getPluginSource();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPluginSource(...)");
        addon.setFile$nova(path);
        String string = "plugins";
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)context.getPluginMeta().getName(), (String)"getName(...)");
        Path path2 = Paths.get(string, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        addon.setDataFolder$nova(path2);
        ComponentLogger componentLogger = context.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)componentLogger, (String)"getLogger(...)");
        addon.setLogger$nova(componentLogger);
        ((Collection)_addons).add(addon);
        NovaBootstrapperKt.getBOOTSTRAPPER().handleAddonBootstrap(context);
    }

    @JvmStatic
    public static final void handleJavaPluginCreated(@NotNull JavaPlugin plugin, @NotNull PluginProviderContext context, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        ConfigurationNode addonMeta = INSTANCE.readAddonMeta(context);
        INSTANCE.getAddonInstance(addonMeta, classLoader).setPlugin$nova(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ConfigurationNode readAddonMeta(PluginProviderContext context) {
        Path path = context.getPluginSource();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPluginSource(...)");
        Path $this$useZip_u24default$iv = path;
        boolean create$iv = false;
        boolean $i$f$useZip = false;
        Map env$iv = MapsKt.emptyMap();
        Closeable closeable = FileSystems.newFileSystem($this$useZip_u24default$iv, env$iv);
        Throwable throwable = null;
        try {
            FileSystem it$iv = (FileSystem)closeable;
            boolean bl = false;
            Iterable<Path> iterable = it$iv.getRootDirectories();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
            Object object = CollectionsKt.first(iterable);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            Path fs = (Path)object;
            boolean bl2 = false;
            Path metaPath = fs.resolve("/nova-addon.yml");
            Intrinsics.checkNotNull((Object)metaPath);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.notExists(metaPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                throw new IllegalStateException("Nova addon meta file not found!");
            }
            YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(metaPath)).build();
            ConfigurationNode configurationNode = loader.load();
            Intrinsics.checkNotNullExpressionValue((Object)configurationNode, (String)"load(...)");
            ConfigurationNode configurationNode2 = configurationNode;
            return configurationNode2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Addon getAddonInstance(ConfigurationNode addonMeta, ClassLoader classLoader) {
        Object[] objectArray = new Object[]{"main"};
        String string = addonMeta.node(objectArray).getString();
        if (string == null) {
            throw new NoSuchElementException("Missing entry 'main' in nova-addon.yml");
        }
        Class<?> clazz = Class.forName(string, true, classLoader);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
        KClass mainClass = JvmClassMappingKt.getKotlinClass(clazz);
        Object addon = mainClass.getObjectInstance();
        if (!(addon instanceof Addon)) {
            boolean bl = false;
            String string2 = "Main class does not extend Addon";
            throw new IllegalArgumentException(string2.toString());
        }
        return (Addon)addon;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkRequiredNovaVersion(PluginProviderContext context, ConfigurationNode addonMeta) {
        Object element$iv2;
        block3: {
            void $this$first$iv;
            Map map2 = LaunchEntryPointHandler.INSTANCE.getStorage();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getStorage(...)");
            Sequence sequence = SequencesKt.flatMapIterable((Sequence)MapsKt.asSequence((Map)map2), AddonBootstrapper::checkRequiredNovaVersion$lambda$0);
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                PluginProvider it = (PluginProvider)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getMeta().getName(), (Object)"Nova")) continue;
                break block3;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        String p0 = ((PluginProvider)element$iv2).getMeta().getVersion();
        boolean bl = false;
        Version novaVersion = new Version(p0);
        Object[] objectArray = new Object[]{"nova_version"};
        String string = addonMeta.node(objectArray).getString();
        if (string == null) {
            throw new NoSuchElementException("Missing entry 'nova_version' in nova-addon.yml");
        }
        Version requiredNovaVersion = new Version(string);
        if (novaVersion.compareTo(requiredNovaVersion, 2) != 0) {
            throw new IllegalArgumentException("Cannot load Nova addon " + context.getConfiguration().getDisplayName() + " as it requires Nova version " + requiredNovaVersion + ", but the server is running Nova version " + novaVersion + "!");
        }
    }

    private final void checkRequiredMinecraftVersion(PluginProviderContext context) {
        String string = context.getConfiguration().getAPIVersion();
        if (string == null) {
            throw new IllegalArgumentException("Missing api version");
        }
        String p0 = string;
        boolean bl = false;
        Version apiVersion = new Version(p0);
        if (ServerUtilsKt.getSERVER_VERSION().compareTo(apiVersion, 2) != 0) {
            throw new IllegalArgumentException("Cannot load Nova addon " + context.getConfiguration().getDisplayName() + " as it requires Minecraft version " + apiVersion + ", but the server is running Minecraft version " + ServerUtilsKt.getSERVER_VERSION() + "!");
        }
    }

    private static final Iterable checkRequiredNovaVersion$lambda$0(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        ProviderStorage storage = (ProviderStorage)entry.getValue();
        Iterable iterable = storage.getRegisteredProviders();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getRegisteredProviders(...)");
        return iterable;
    }
}

