/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.api;

import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.api.ApiBlockRegistry;
import xyz.xenondevs.nova.api.ApiBlockWrapper;
import xyz.xenondevs.nova.api.ApiNovaBlockStateWrapper;
import xyz.xenondevs.nova.api.ApiNovaTileEntityStateWrapper;
import xyz.xenondevs.nova.api.ApiTileEntityWrapper;
import xyz.xenondevs.nova.api.block.BlockManager;
import xyz.xenondevs.nova.api.block.NovaBlock;
import xyz.xenondevs.nova.api.block.NovaBlockState;
import xyz.xenondevs.nova.api.data.NamespacedId;
import xyz.xenondevs.nova.api.material.NovaMaterial;
import xyz.xenondevs.nova.context.Context;
import xyz.xenondevs.nova.context.intention.ContextIntention;
import xyz.xenondevs.nova.context.intention.DefaultContextIntentions;
import xyz.xenondevs.nova.context.param.DefaultContextParamTypes;
import xyz.xenondevs.nova.util.BlockUtils;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.BlockPosKt;
import xyz.xenondevs.nova.world.block.NovaTileEntityBlock;
import xyz.xenondevs.nova.world.block.tileentity.TileEntity;
import xyz.xenondevs.nova.world.format.WorldDataManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J,\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016J\"\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u001e\u0010\u0019\u001a\u00020\u000b2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u00a8\u0006\u001c"}, d2={"Lxyz/xenondevs/nova/api/ApiBlockManager;", "Lxyz/xenondevs/nova/api/block/BlockManager;", "<init>", "()V", "hasBlock", "", "location", "Lorg/bukkit/Location;", "getBlock", "Lxyz/xenondevs/nova/api/block/NovaBlockState;", "placeBlock", "", "block", "Lxyz/xenondevs/nova/api/block/NovaBlock;", "source", "", "playSound", "material", "Lxyz/xenondevs/nova/api/material/NovaMaterial;", "getDrops", "", "Lorg/bukkit/inventory/ItemStack;", "tool", "removeBlock", "breakEffects", "setSourceParam", "builder", "Lxyz/xenondevs/nova/context/Context$Builder;", "nova"})
@SourceDebugExtension(value={"SMAP\nApiBlockManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiBlockManager.kt\nxyz/xenondevs/nova/api/ApiBlockManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class ApiBlockManager
implements BlockManager {
    @NotNull
    public static final ApiBlockManager INSTANCE = new ApiBlockManager();

    private ApiBlockManager() {
    }

    @Override
    public boolean hasBlock(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return WorldDataManager.INSTANCE.getBlockState(BlockPosKt.getPos(location)) != null;
    }

    @Override
    @Nullable
    public NovaBlockState getBlock(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        BlockPos pos = BlockPosKt.getPos(location);
        xyz.xenondevs.nova.world.block.state.NovaBlockState novaBlockState = WorldDataManager.INSTANCE.getBlockState(pos);
        if (novaBlockState == null) {
            return null;
        }
        xyz.xenondevs.nova.world.block.state.NovaBlockState state = novaBlockState;
        if (state.getBlock() instanceof NovaTileEntityBlock) {
            TileEntity tileEntity = WorldDataManager.INSTANCE.getTileEntity(pos);
            if (tileEntity == null) {
                return null;
            }
            TileEntity tileEntity2 = tileEntity;
            return new ApiNovaTileEntityStateWrapper(pos, state, tileEntity2);
        }
        return new ApiNovaBlockStateWrapper(pos, state);
    }

    @Override
    public void placeBlock(@NotNull Location location, @NotNull NovaBlock block, @Nullable Object source, boolean playSound) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        if (!(block instanceof ApiBlockWrapper)) {
            boolean bl = false;
            String string = "block must be ApiBlockWrapper";
            throw new IllegalArgumentException(string.toString());
        }
        Context.Builder<ContextIntention> ctxBuilder = Context.Companion.intention((ContextIntention)DefaultContextIntentions.BlockPlace.INSTANCE).param(DefaultContextParamTypes.INSTANCE.getBLOCK_POS(), BlockPosKt.getPos(location)).param(DefaultContextParamTypes.INSTANCE.getBLOCK_TYPE_NOVA(), ((ApiBlockWrapper)block).getBlock()).param(DefaultContextParamTypes.INSTANCE.getBLOCK_PLACE_EFFECTS(), playSound);
        this.setSourceParam(ctxBuilder, source);
        BlockUtils.INSTANCE.placeBlock(ctxBuilder.build());
    }

    @Override
    public void placeBlock(@NotNull Location location, @NotNull NovaMaterial material, @Nullable Object source, boolean playSound) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        NamespacedId namespacedId = material.getId();
        Intrinsics.checkNotNullExpressionValue((Object)namespacedId, (String)"getId(...)");
        NovaBlock block = ApiBlockRegistry.INSTANCE.get(namespacedId);
        this.placeBlock(location, block, source, playSound);
    }

    @Override
    @Nullable
    public List<ItemStack> getDrops(@NotNull Location location, @Nullable Object source, @Nullable ItemStack tool) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Context.Builder<ContextIntention> ctxBuilder = Context.Companion.intention((ContextIntention)DefaultContextIntentions.BlockBreak.INSTANCE).param(DefaultContextParamTypes.INSTANCE.getBLOCK_POS(), BlockPosKt.getPos(location)).param(DefaultContextParamTypes.INSTANCE.getTOOL_ITEM_STACK(), tool);
        this.setSourceParam(ctxBuilder, source);
        return BlockUtils.INSTANCE.getDrops(ctxBuilder.build());
    }

    @Override
    public boolean removeBlock(@NotNull Location location, @Nullable Object source, boolean breakEffects) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Context.Builder<ContextIntention> ctxBuilder = Context.Companion.intention((ContextIntention)DefaultContextIntentions.BlockBreak.INSTANCE).param(DefaultContextParamTypes.INSTANCE.getBLOCK_POS(), BlockPosKt.getPos(location)).param(DefaultContextParamTypes.INSTANCE.getBLOCK_BREAK_EFFECTS(), breakEffects);
        this.setSourceParam(ctxBuilder, source);
        BlockUtils.INSTANCE.breakBlock(ctxBuilder.build());
        return true;
    }

    private final void setSourceParam(Context.Builder<?> builder, Object source) {
        if (source == null) {
            return;
        }
        Object object = source;
        if (object instanceof Entity) {
            builder.param(DefaultContextParamTypes.INSTANCE.getSOURCE_ENTITY(), source);
        } else if (object instanceof ApiTileEntityWrapper) {
            builder.param(DefaultContextParamTypes.INSTANCE.getSOURCE_TILE_ENTITY(), ((ApiTileEntityWrapper)source).getTileEntity());
        } else if (object instanceof Location) {
            builder.param(DefaultContextParamTypes.INSTANCE.getSOURCE_LOCATION(), source);
        } else if (object instanceof UUID) {
            builder.param(DefaultContextParamTypes.INSTANCE.getSOURCE_UUID(), source);
        }
    }
}

