/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.api;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.api.ApiBlockWrapper;
import xyz.xenondevs.nova.api.NamespacedId;
import xyz.xenondevs.nova.api.block.NovaBlock;
import xyz.xenondevs.nova.api.item.NovaItem;
import xyz.xenondevs.nova.util.component.adventure.ComponentUtilsKt;
import xyz.xenondevs.nova.util.item.ItemUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lxyz/xenondevs/nova/api/ApiItemWrapper;", "Lxyz/xenondevs/nova/api/item/NovaItem;", "item", "Lxyz/xenondevs/nova/world/item/NovaItem;", "<init>", "(Lxyz/xenondevs/nova/world/item/NovaItem;)V", "getId", "Lxyz/xenondevs/nova/api/data/NamespacedId;", "getBlock", "Lxyz/xenondevs/nova/api/block/NovaBlock;", "getMaxStackSize", "", "getName", "Lnet/kyori/adventure/text/Component;", "getPlaintextName", "", "locale", "createItemStack", "Lorg/bukkit/inventory/ItemStack;", "amount", "createClientsideItemStack", "nova"})
@SourceDebugExtension(value={"SMAP\nApiItemWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiItemWrapper.kt\nxyz/xenondevs/nova/api/ApiItemWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,31:1\n1#2:32\n*E\n"})
public final class ApiItemWrapper
implements NovaItem {
    @NotNull
    private final xyz.xenondevs.nova.world.item.NovaItem item;

    public ApiItemWrapper(@NotNull xyz.xenondevs.nova.world.item.NovaItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.item = item;
    }

    @Override
    @NotNull
    public xyz.xenondevs.nova.api.data.NamespacedId getId() {
        String string = this.item.getId().namespace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"namespace(...)");
        String string2 = this.item.getId().value();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value(...)");
        return new NamespacedId(string, string2);
    }

    @Override
    @Nullable
    public NovaBlock getBlock() {
        ApiBlockWrapper apiBlockWrapper;
        xyz.xenondevs.nova.world.block.NovaBlock novaBlock = this.item.getBlock();
        if (novaBlock != null) {
            xyz.xenondevs.nova.world.block.NovaBlock p0 = novaBlock;
            boolean bl = false;
            apiBlockWrapper = new ApiBlockWrapper(p0);
        } else {
            apiBlockWrapper = null;
        }
        return apiBlockWrapper;
    }

    @Override
    public int getMaxStackSize() {
        return this.item.getMaxStackSize();
    }

    @Override
    @NotNull
    public Component getName() {
        Component component2 = this.item.getName();
        if (component2 == null) {
            TextComponent textComponent = Component.empty();
            Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"empty(...)");
            component2 = (Component)textComponent;
        }
        return component2;
    }

    @Override
    @NotNull
    public String getPlaintextName(@NotNull String locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Object object = this.item.getName();
        if (object == null || (object = ComponentUtilsKt.toPlainText(object, locale)) == null) {
            object = "";
        }
        return object;
    }

    @Override
    @NotNull
    public ItemStack createItemStack(int amount) {
        return this.item.createItemStack(amount);
    }

    @Override
    @NotNull
    public ItemStack createClientsideItemStack(int amount) {
        return ItemUtilsKt.clientsideCopy(this.item.createItemStack(amount));
    }
}

