/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.api.protection;

import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.api.tileentity.TileEntity;

public interface ProtectionIntegration {
    @NotNull
    default public ExecutionMode getExecutionMode() {
        return ExecutionMode.SERVER;
    }

    public boolean canBreak(@NotNull OfflinePlayer var1, @Nullable ItemStack var2, @NotNull Location var3);

    default public boolean canBreak(@NotNull TileEntity tileEntity, @Nullable ItemStack item, @NotNull Location location) {
        return this.canBreak(Objects.requireNonNull(tileEntity.getOwner()), item, location);
    }

    public boolean canPlace(@NotNull OfflinePlayer var1, @NotNull ItemStack var2, @NotNull Location var3);

    default public boolean canPlace(@NotNull TileEntity tileEntity, @NotNull ItemStack item, @NotNull Location location) {
        return this.canPlace(Objects.requireNonNull(tileEntity.getOwner()), item, location);
    }

    public boolean canUseBlock(@NotNull OfflinePlayer var1, @Nullable ItemStack var2, @NotNull Location var3);

    default public boolean canUseBlock(@NotNull TileEntity tileEntity, @Nullable ItemStack item, @NotNull Location location) {
        return this.canUseBlock(Objects.requireNonNull(tileEntity.getOwner()), item, location);
    }

    public boolean canUseItem(@NotNull OfflinePlayer var1, @NotNull ItemStack var2, @NotNull Location var3);

    default public boolean canUseItem(@NotNull TileEntity tileEntity, @NotNull ItemStack item, @NotNull Location location) {
        return this.canUseItem(Objects.requireNonNull(tileEntity.getOwner()), item, location);
    }

    public boolean canInteractWithEntity(@NotNull OfflinePlayer var1, @NotNull Entity var2, @Nullable ItemStack var3);

    default public boolean canInteractWithEntity(@NotNull TileEntity tileEntity, @NotNull Entity entity, @Nullable ItemStack item) {
        return this.canInteractWithEntity(Objects.requireNonNull(tileEntity.getOwner()), entity, item);
    }

    public boolean canHurtEntity(@NotNull OfflinePlayer var1, @NotNull Entity var2, @Nullable ItemStack var3);

    default public boolean canHurtEntity(@NotNull TileEntity tileEntity, @NotNull Entity entity, @Nullable ItemStack item) {
        return this.canHurtEntity(Objects.requireNonNull(tileEntity.getOwner()), entity, item);
    }

    public static enum ExecutionMode {
        NONE,
        SERVER,
        ASYNC;

    }
}

