/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.hook.impl.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.internal.platform.WorldGuardPlatform;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.SessionManager;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.api.protection.ProtectionIntegration;
import xyz.xenondevs.nova.hook.impl.worldguard.BetterBukkitOfflinePlayer;
import xyz.xenondevs.nova.integration.Hook;

@Hook(plugins={"WorldGuard"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\"\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J1\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d\"\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\r\u001a\u00020&H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lxyz/xenondevs/nova/hook/impl/worldguard/WorldGuardHook;", "Lxyz/xenondevs/nova/api/protection/ProtectionIntegration;", "<init>", "()V", "PLUGIN", "Lcom/sk89q/worldguard/bukkit/WorldGuardPlugin;", "kotlin.jvm.PlatformType", "PLATFORM", "Lcom/sk89q/worldguard/internal/platform/WorldGuardPlatform;", "getExecutionMode", "Lxyz/xenondevs/nova/api/protection/ProtectionIntegration$ExecutionMode;", "canBreak", "", "player", "Lorg/bukkit/OfflinePlayer;", "item", "Lorg/bukkit/inventory/ItemStack;", "location", "Lorg/bukkit/Location;", "canPlace", "canUseBlock", "canUseItem", "canInteractWithEntity", "entity", "Lorg/bukkit/entity/Entity;", "canHurtEntity", "runQuery", "offlinePlayer", "flags", "", "Lcom/sk89q/worldguard/protection/flags/StateFlag;", "(Lorg/bukkit/OfflinePlayer;Lorg/bukkit/Location;[Lcom/sk89q/worldguard/protection/flags/StateFlag;)Z", "hasRegion", "world", "Lcom/sk89q/worldedit/world/World;", "vector", "Lcom/sk89q/worldedit/math/BlockVector3;", "hasBypass", "Lcom/sk89q/worldguard/LocalPlayer;", "nova-hook-worldguard"})
public final class WorldGuardHook
implements ProtectionIntegration {
    @NotNull
    public static final WorldGuardHook INSTANCE = new WorldGuardHook();
    private static final WorldGuardPlugin PLUGIN = WorldGuardPlugin.inst();
    private static final WorldGuardPlatform PLATFORM = WorldGuard.getInstance().getPlatform();

    private WorldGuardHook() {
    }

    @Override
    @NotNull
    public ProtectionIntegration.ExecutionMode getExecutionMode() {
        return ProtectionIntegration.ExecutionMode.NONE;
    }

    @Override
    public boolean canBreak(@NotNull OfflinePlayer player, @Nullable ItemStack item, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        StateFlag[] stateFlagArray = new StateFlag[1];
        Intrinsics.checkNotNullExpressionValue((Object)Flags.BLOCK_BREAK, (String)"BLOCK_BREAK");
        return this.runQuery(player, location, stateFlagArray);
    }

    @Override
    public boolean canPlace(@NotNull OfflinePlayer player, @NotNull ItemStack item, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        StateFlag[] stateFlagArray = new StateFlag[1];
        Intrinsics.checkNotNullExpressionValue((Object)Flags.BLOCK_PLACE, (String)"BLOCK_PLACE");
        return this.runQuery(player, location, stateFlagArray);
    }

    @Override
    public boolean canUseBlock(@NotNull OfflinePlayer player, @Nullable ItemStack item, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        StateFlag[] stateFlagArray = new StateFlag[1];
        Intrinsics.checkNotNullExpressionValue((Object)Flags.USE, (String)"USE");
        return this.runQuery(player, location, stateFlagArray);
    }

    @Override
    public boolean canUseItem(@NotNull OfflinePlayer player, @NotNull ItemStack item, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        StateFlag[] stateFlagArray = new StateFlag[1];
        Intrinsics.checkNotNullExpressionValue((Object)Flags.USE, (String)"USE");
        return this.runQuery(player, location, stateFlagArray);
    }

    @Override
    public boolean canInteractWithEntity(@NotNull OfflinePlayer player, @NotNull Entity entity, @Nullable ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Location location = entity.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        StateFlag[] stateFlagArray = new StateFlag[1];
        Intrinsics.checkNotNullExpressionValue((Object)Flags.INTERACT, (String)"INTERACT");
        return this.runQuery(player, location, stateFlagArray);
    }

    @Override
    public boolean canHurtEntity(@NotNull OfflinePlayer player, @NotNull Entity entity, @Nullable ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Location location = entity.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        StateFlag[] stateFlagArray = new StateFlag[1];
        Intrinsics.checkNotNullExpressionValue((Object)Flags.DAMAGE_ANIMALS, (String)"DAMAGE_ANIMALS");
        return this.runQuery(player, location, stateFlagArray);
    }

    private final boolean runQuery(OfflinePlayer offlinePlayer, Location location, StateFlag ... flags) {
        World world = BukkitAdapter.adapt((org.bukkit.World)location.getWorld());
        org.bukkit.World world2 = location.getWorld();
        Intrinsics.checkNotNull((Object)world2);
        Intrinsics.checkNotNull((Object)world);
        WorldGuardPlatform worldGuardPlatform = PLATFORM;
        Intrinsics.checkNotNullExpressionValue((Object)worldGuardPlatform, (String)"PLATFORM");
        WorldGuardPlugin worldGuardPlugin = PLUGIN;
        Intrinsics.checkNotNullExpressionValue((Object)worldGuardPlugin, (String)"PLUGIN");
        BetterBukkitOfflinePlayer localPlayer = new BetterBukkitOfflinePlayer(world2, world, worldGuardPlatform, worldGuardPlugin, offlinePlayer);
        if (!this.hasBypass(world, (LocalPlayer)localPlayer)) {
            boolean bl;
            BlockVector3 vector = BukkitAdapter.asBlockVector((Location)location);
            Intrinsics.checkNotNull((Object)vector);
            if (this.hasRegion(world, vector)) {
                com.sk89q.worldedit.util.Location wrappedLocation = BukkitAdapter.adapt((Location)location);
                RegionQuery query = PLATFORM.getRegionContainer().createQuery();
                bl = query.testBuild(wrappedLocation, (LocalPlayer)localPlayer, Arrays.copyOf(flags, flags.length));
            } else {
                bl = true;
            }
            return bl;
        }
        return true;
    }

    private final boolean hasRegion(World world, BlockVector3 vector) {
        RegionManager regionManager = PLATFORM.getRegionContainer().get(world);
        if (regionManager == null) {
            return true;
        }
        RegionManager regionManager2 = regionManager;
        return regionManager2.getApplicableRegions(vector).size() > 0;
    }

    private final boolean hasBypass(World world, LocalPlayer player) {
        Session session;
        SessionManager sessionManager = PLATFORM.getSessionManager();
        Session session2 = session = sessionManager.getIfPresent(player);
        boolean bl = session2 != null ? session2.hasBypassDisabled() : false;
        if (bl) {
            return false;
        }
        return player.hasPermission("worldguard.region.bypass." + world.getName());
    }
}

