/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.integration.permission;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.NovaBootstrapperKt;
import xyz.xenondevs.nova.initialize.DisableFun;
import xyz.xenondevs.nova.initialize.Dispatcher;
import xyz.xenondevs.nova.initialize.InitFun;
import xyz.xenondevs.nova.initialize.InternalInit;
import xyz.xenondevs.nova.initialize.InternalInitStage;
import xyz.xenondevs.nova.integration.HooksLoader;
import xyz.xenondevs.nova.integration.permission.PermissionArgs;
import xyz.xenondevs.nova.integration.permission.PermissionIntegration;
import xyz.xenondevs.nova.integration.permission.PermissionManager;
import xyz.xenondevs.nova.util.NMSUtilsKt;

@InternalInit(stage=InternalInitStage.POST_WORLD, dispatcher=Dispatcher.ASYNC, dependsOn={HooksLoader.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0003J\b\u0010\u0011\u001a\u00020\u0010H\u0003J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0019J \u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lxyz/xenondevs/nova/integration/permission/PermissionManager;", "", "<init>", "()V", "integrations", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lxyz/xenondevs/nova/integration/permission/PermissionIntegration;", "getIntegrations$nova", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "executor", "Ljava/util/concurrent/ExecutorService;", "offlinePermissionCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lxyz/xenondevs/nova/integration/permission/PermissionArgs;", "", "init", "", "disable", "hasPermission", "Ljava/util/concurrent/CompletableFuture;", "world", "Lorg/bukkit/World;", "player", "Ljava/util/UUID;", "permission", "", "Lorg/bukkit/OfflinePlayer;", "hasOfflinePermission", "nova"})
@SourceDebugExtension(value={"SMAP\nPermissionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionManager.kt\nxyz/xenondevs/nova/integration/permission/PermissionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public final class PermissionManager {
    @NotNull
    public static final PermissionManager INSTANCE = new PermissionManager();
    @NotNull
    private static final CopyOnWriteArrayList<PermissionIntegration> integrations = new CopyOnWriteArrayList();
    private static ExecutorService executor;
    private static LoadingCache<PermissionArgs, Boolean> offlinePermissionCache;

    private PermissionManager() {
    }

    @NotNull
    public final CopyOnWriteArrayList<PermissionIntegration> getIntegrations$nova() {
        return integrations;
    }

    @InitFun
    private final void init() {
        executor = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue(), new ThreadFactoryBuilder().setNameFormat("Nova Permission Worker - %s").build());
        Caffeine caffeine = Caffeine.newBuilder();
        ExecutorService executorService = executor;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
            executorService = null;
        }
        LoadingCache loadingCache = caffeine.executor((Executor)executorService).expireAfterAccess(Duration.ofMinutes(30L)).refreshAfterWrite(Duration.ofMinutes(1L)).build((CacheLoader)init.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        offlinePermissionCache = loadingCache;
        if (integrations.size() > 1) {
            NovaBootstrapperKt.getLOGGER().warn("Multiple permission integrations have been registered: " + CollectionsKt.joinToString$default((Iterable)integrations, null, null, null, (int)0, null, PermissionManager::init$lambda$0, (int)31, null) + ", Nova will use the first one");
        }
    }

    @DisableFun
    private final void disable() {
        ExecutorService executorService = executor;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executor");
            executorService = null;
        }
        executorService.shutdown();
    }

    @NotNull
    public final CompletableFuture<Boolean> hasPermission(@NotNull World world, @NotNull UUID player, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)player);
        Intrinsics.checkNotNullExpressionValue((Object)offlinePlayer, (String)"getOfflinePlayer(...)");
        return this.hasPermission(world, offlinePlayer, permission);
    }

    @NotNull
    public final CompletableFuture<Boolean> hasPermission(@NotNull World world, @NotNull OfflinePlayer player, @NotNull String permission) {
        Boolean cachedResult;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        if (player.isOnline()) {
            Player player2 = player.getPlayer();
            Intrinsics.checkNotNull((Object)player2);
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(player2.hasPermission(permission));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        PermissionArgs args = new PermissionArgs(world, player, permission);
        LoadingCache<PermissionArgs, Boolean> loadingCache = offlinePermissionCache;
        if (loadingCache == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offlinePermissionCache");
            loadingCache = null;
        }
        if ((cachedResult = (Boolean)loadingCache.getIfPresent((Object)args)) != null) {
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(cachedResult);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        LoadingCache<PermissionArgs, Boolean> loadingCache2 = offlinePermissionCache;
        if (loadingCache2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offlinePermissionCache");
            loadingCache2 = null;
        }
        CompletableFuture completableFuture = loadingCache2.refresh((Object)args);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"refresh(...)");
        return completableFuture;
    }

    private final boolean hasOfflinePermission(World world, OfflinePlayer player, String permission) {
        if (!(!Intrinsics.areEqual((Object)Thread.currentThread(), (Object)NMSUtilsKt.getMINECRAFT_SERVER().serverThread))) {
            boolean bl = false;
            String string = "Offline player permissions should never be checked from the main thread";
            throw new IllegalArgumentException(string.toString());
        }
        if (integrations.isEmpty()) {
            return false;
        }
        Boolean bl = integrations.get(0).hasPermission(world, player, permission).get();
        return bl != null ? bl : false;
    }

    private static final CharSequence init$lambda$0(PermissionIntegration it) {
        String string = Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public static final /* synthetic */ boolean access$hasOfflinePermission(PermissionManager $this, World world, OfflinePlayer player, String permission) {
        return $this.hasOfflinePermission(world, player, permission);
    }
}

