/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.mixin.block.fluidflow;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.block.DefaultBlocks;
import xyz.xenondevs.nova.world.block.NovaBlock;
import xyz.xenondevs.nova.world.block.behavior.Waterloggable;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.format.WorldDataManager;

@Mixin(value={FlowingFluid.class})
abstract class FlowingFluidMixin {
    FlowingFluidMixin() {
    }

    @Inject(method={"canHoldSpecificFluid"}, at={@At(value="HEAD")}, cancellable=true)
    private static void canHoldSpecificFluid(BlockGetter getter, BlockPos pos, BlockState state, Fluid fluid, CallbackInfoReturnable<Boolean> cir) {
        if (!(getter instanceof Level)) {
            return;
        }
        Level level = (Level)getter;
        xyz.xenondevs.nova.world.BlockPos novaPos = NMSUtilsKt.toNovaPos(pos, (World)level.getWorld());
        NovaBlockState novaState = WorldDataManager.INSTANCE.getBlockState(novaPos);
        if (novaState == null) {
            return;
        }
        NovaBlock novaBlock = novaState.getBlock();
        if (!novaBlock.hasBehavior(Waterloggable.class) && novaBlock != DefaultBlocks.INSTANCE.getTRIPWIRE()) {
            cir.setReturnValue((Object)false);
        }
    }
}

