/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.mixin.item.using;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.item.ItemUtilsKt;
import xyz.xenondevs.nova.world.item.NovaItem;

@Mixin(value={net.minecraft.world.item.ItemStack.class})
abstract class ItemStackMixin {
    ItemStackMixin() {
    }

    @Redirect(method={"onUseTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/Item;onUseTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;I)V"))
    private void redirectUseTickToNovaBehaviors(Item item, Level level, LivingEntity livingEntity, net.minecraft.world.item.ItemStack stack, int remainingUseDuration) {
        NovaItem novaItem = ItemUtilsKt.getNovaItem(stack);
        if (novaItem != null) {
            novaItem.handleUseTick$nova((org.bukkit.entity.LivingEntity)livingEntity.getBukkitLivingEntity(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)stack), NMSUtilsKt.getBukkitEquipmentSlot(livingEntity.getUsedItemHand()), livingEntity.getTicksUsingItem(), remainingUseDuration);
        } else {
            item.onUseTick(level, livingEntity, stack, remainingUseDuration);
        }
    }

    @ModifyReturnValue(method={"getUseDuration"}, at={@At(value="RETURN")})
    private int modifyUseDuration(int original, @Local(argsOnly=true) LivingEntity entity) {
        net.minecraft.world.item.ItemStack thisRef = (net.minecraft.world.item.ItemStack)this;
        NovaItem novaItem = ItemUtilsKt.getNovaItem(thisRef);
        if (novaItem == null) {
            return original;
        }
        return novaItem.modifyUseDuration$nova((org.bukkit.entity.LivingEntity)entity.getBukkitLivingEntity(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)thisRef), original);
    }

    @ModifyReturnValue(method={"finishUsingItem"}, at={@At(value="RETURN")})
    private net.minecraft.world.item.ItemStack handleFinishUseAndModifyRemainder(net.minecraft.world.item.ItemStack remainder, @Local(argsOnly=true) LivingEntity entity) {
        net.minecraft.world.item.ItemStack thisRef = (net.minecraft.world.item.ItemStack)this;
        NovaItem novaItem = ItemUtilsKt.getNovaItem(thisRef);
        if (novaItem == null) {
            return remainder;
        }
        novaItem.handleUseFinished$nova((org.bukkit.entity.LivingEntity)entity.getBukkitLivingEntity(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)thisRef), NMSUtilsKt.getBukkitEquipmentSlot(entity.getUsedItemHand()));
        return CraftItemStack.unwrap((ItemStack)novaItem.modifyUseRemainder$nova((org.bukkit.entity.LivingEntity)entity.getBukkitLivingEntity(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)thisRef), NMSUtilsKt.getBukkitEquipmentSlot(entity.getUsedItemHand()), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)remainder))).copy();
    }

    @Inject(method={"releaseUsing"}, at={@At(value="HEAD")})
    private void handleUseStopped(Level level, LivingEntity livingEntity, int timeLeft, CallbackInfo ci) {
        net.minecraft.world.item.ItemStack thisRef = (net.minecraft.world.item.ItemStack)this;
        NovaItem novaItem = ItemUtilsKt.getNovaItem(thisRef);
        if (novaItem == null) {
            return;
        }
        novaItem.handleUseStopped$nova((org.bukkit.entity.LivingEntity)livingEntity.getBukkitLivingEntity(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)thisRef), NMSUtilsKt.getBukkitEquipmentSlot(livingEntity.getUsedItemHand()), timeLeft);
    }
}

