/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.mixin.world;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.bukkit.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.block.migrator.BlockMigrator;
import xyz.xenondevs.nova.world.format.WorldDataManager;
import xyz.xenondevs.nova.world.generation.wrapper.WrapperBlockState;

@Mixin(value={LevelChunkSection.class})
abstract class LevelChunkSectionMixin {
    @Unique
    private Level nova$level;
    @Unique
    private ChunkPos nova$chunkPos;
    @Unique
    private int nova$bottomBlockY;
    @Unique
    private boolean nova$migrationActive;

    LevelChunkSectionMixin() {
    }

    @Inject(method={"setBlockState(IIILnet/minecraft/world/level/block/state/BlockState;Z)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="HEAD")}, order=0, cancellable=true)
    private void handleWrapperBlockState(int x, int y, int z, BlockState state, boolean useLocks, CallbackInfoReturnable<BlockState> cir) {
        BlockPos pos = this.nova$getPos(x, y, z);
        if (state instanceof WrapperBlockState) {
            WrapperBlockState wrappedState = (WrapperBlockState)state;
            WorldDataManager.INSTANCE.setBlockState(pos, wrappedState.getNovaState());
            cir.setReturnValue((Object)Blocks.AIR.defaultBlockState());
        }
    }

    @ModifyVariable(method={"setBlockState(IIILnet/minecraft/world/level/block/state/BlockState;Z)Lnet/minecraft/world/level/block/state/BlockState;"}, at=@At(value="HEAD"), argsOnly=true, order=1)
    private BlockState migrateBlockState(BlockState blockState, @Local(ordinal=0, argsOnly=true) int x, @Local(ordinal=1, argsOnly=true) int y, @Local(ordinal=2, argsOnly=true) int z, @Share(value="unmigrated") LocalRef<BlockState> unmigrated) {
        unmigrated.set((Object)blockState);
        if (!this.nova$migrationActive || BlockMigrator.migrationSuppression.get() > 0) {
            return blockState;
        }
        return BlockMigrator.migrateBlockState(this.nova$getPos(x, y, z), blockState);
    }

    @Inject(method={"setBlockState(IIILnet/minecraft/world/level/block/state/BlockState;Z)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="TAIL")})
    private void handleBlockStatePlaced(int x, int y, int z, BlockState state, boolean useLocks, CallbackInfoReturnable<BlockState> cir, @Share(value="unmigrated") LocalRef<BlockState> unmigrated, @Local(ordinal=1) BlockState previous) {
        if (!this.nova$migrationActive || BlockMigrator.migrationSuppression.get() > 0) {
            return;
        }
        BlockMigrator.handleBlockStatePlaced(this.nova$getPos(x, y, z), previous, (BlockState)unmigrated.get());
    }

    @Unique
    private BlockPos nova$getPos(int x, int y, int z) {
        return new BlockPos((World)this.nova$level.getWorld(), x + this.nova$chunkPos.getMinBlockX(), y + this.nova$bottomBlockY, z + this.nova$chunkPos.getMinBlockZ());
    }
}

