/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.network;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.NovaBootstrapperKt;
import xyz.xenondevs.nova.network.IndefinitePacketDropRequest;
import xyz.xenondevs.nova.network.LimitedPacketDropRequest;
import xyz.xenondevs.nova.network.PacketDropRequest;
import xyz.xenondevs.nova.network.event.PacketEvent;
import xyz.xenondevs.nova.network.event.PacketEventManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001f\u001a\u00020 2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\"H\u0002J\u0012\u0010#\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J3\u0010$\u001a\u0004\u0018\u0001H%\"\b\b\u0000\u0010&*\u00020'\"\u0010\b\u0001\u0010%*\n\u0012\u0006\b\u0000\u0012\u0002H&0(2\u0006\u0010\u001a\u001a\u0002H%H\u0002\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\nJ*\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.2\u001a\u0010/\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030(\u0012\u0004\u0012\u00020 00j\u0002`1J\"\u00102\u001a\u00020\u00172\u001a\u0010/\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030(\u0012\u0004\u0012\u00020 00j\u0002`1J*\u00103\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.2\u001a\u0010/\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030(\u0012\u0004\u0012\u00020 00j\u0002`1J\"\u00104\u001a\u00020\u00172\u001a\u0010/\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030(\u0012\u0004\u0012\u00020 00j\u0002`1J\u000e\u00105\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u00106\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u00067"}, d2={"Lxyz/xenondevs/nova/network/PacketHandler;", "Lio/netty/channel/ChannelDuplexHandler;", "channel", "Lio/netty/channel/Channel;", "<init>", "(Lio/netty/channel/Channel;)V", "getChannel", "()Lio/netty/channel/Channel;", "queue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lnet/minecraft/network/FriendlyByteBuf;", "incomingDropQueue", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lxyz/xenondevs/nova/network/PacketDropRequest;", "outgoingDropQueue", "value", "Lorg/bukkit/entity/Player;", "player", "getPlayer", "()Lorg/bukkit/entity/Player;", "setPlayer$nova", "(Lorg/bukkit/entity/Player;)V", "write", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "", "promise", "Lio/netty/channel/ChannelPromise;", "channelRead", "shouldDrop", "", "list", "", "flush", "callEvent", "P", "L", "Lnet/minecraft/network/PacketListener;", "Lnet/minecraft/network/protocol/Packet;", "(Lnet/minecraft/network/protocol/Packet;)Lnet/minecraft/network/protocol/Packet;", "queueByteBuf", "buf", "dropNextIncoming", "n", "", "condition", "Lkotlin/Function1;", "Lxyz/xenondevs/nova/network/PacketCondition;", "dropAllIncoming", "dropNextOutgoing", "dropAllOutgoing", "injectIncoming", "injectOutgoing", "nova"})
@SourceDebugExtension(value={"SMAP\nPacketHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PacketHandler.kt\nxyz/xenondevs/nova/network/PacketHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1617#2,9:153\n1869#2:162\n1870#2:164\n1626#2:165\n1#3:163\n*S KotlinDebug\n*F\n+ 1 PacketHandler.kt\nxyz/xenondevs/nova/network/PacketHandler\n*L\n46#1:153,9\n46#1:162\n46#1:164\n46#1:165\n46#1:163\n*E\n"})
public final class PacketHandler
extends ChannelDuplexHandler {
    @NotNull
    private final Channel channel;
    @NotNull
    private final ConcurrentLinkedQueue<FriendlyByteBuf> queue;
    @NotNull
    private final CopyOnWriteArrayList<PacketDropRequest> incomingDropQueue;
    @NotNull
    private final CopyOnWriteArrayList<PacketDropRequest> outgoingDropQueue;
    @Nullable
    private volatile Player player;

    public PacketHandler(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.channel = channel;
        this.queue = new ConcurrentLinkedQueue();
        this.incomingDropQueue = new CopyOnWriteArrayList();
        this.outgoingDropQueue = new CopyOnWriteArrayList();
    }

    @NotNull
    public final Channel getChannel() {
        return this.channel;
    }

    @Nullable
    public final Player getPlayer() {
        return this.player;
    }

    public final void setPlayer$nova(@Nullable Player player) {
        this.player = player;
    }

    /*
     * WARNING - void declaration
     */
    public void write(@Nullable ChannelHandlerContext ctx, @Nullable Object msg, @Nullable ChannelPromise promise) {
        block8: {
            try {
                if (this.shouldDrop(msg, (List<PacketDropRequest>)this.outgoingDropQueue)) {
                    return;
                }
                if (msg instanceof Packet) {
                    if (msg instanceof ClientboundBundlePacket) {
                        void $this$mapNotNullTo$iv$iv;
                        Iterable iterable = ((ClientboundBundlePacket)msg).subPackets();
                        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"subPackets(...)");
                        Iterable $this$mapNotNull$iv = iterable;
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable2 = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Packet it$iv$iv;
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            Packet p0 = (Packet)element$iv$iv;
                            boolean bl2 = false;
                            if (this.callEvent(p0) == null) continue;
                            boolean bl3 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List subPackets = (List)destination$iv$iv;
                        if (subPackets.isEmpty()) {
                            return;
                        }
                        super.write(ctx, (Object)new ClientboundBundlePacket((Iterable)subPackets), promise);
                        break block8;
                    }
                    Packet packet = this.callEvent((Packet)msg);
                    if (packet == null) {
                        return;
                    }
                    Packet packet2 = packet;
                    super.write(ctx, (Object)packet2, promise);
                    break block8;
                }
                super.write(ctx, msg, promise);
            }
            catch (Throwable t) {
                NovaBootstrapperKt.getLOGGER().error("An exception occurred while handling a clientbound packet.", t);
            }
        }
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        try {
            if (this.shouldDrop(msg, (List<PacketDropRequest>)this.incomingDropQueue)) {
                return;
            }
            if (msg instanceof Packet) {
                Packet packet = this.callEvent((Packet)msg);
                if (packet == null) {
                    return;
                }
                Packet packet2 = packet;
                super.channelRead(ctx, (Object)packet2);
            } else {
                super.channelRead(ctx, msg);
            }
        }
        catch (Throwable t) {
            NovaBootstrapperKt.getLOGGER().error("An exception occurred while handling a serverbound packet.", t);
        }
    }

    private final boolean shouldDrop(Object msg, List<PacketDropRequest> list) {
        Iterator<PacketDropRequest> iterator;
        if (!(msg instanceof Packet) || list.isEmpty()) {
            return false;
        }
        Iterator<PacketDropRequest> iterator2 = iterator = list.iterator();
        while (iterator2.hasNext()) {
            PacketDropRequest request = iterator2.next();
            if (!((Boolean)request.getCondition().invoke(msg)).booleanValue()) continue;
            if (request instanceof LimitedPacketDropRequest) {
                LimitedPacketDropRequest limitedPacketDropRequest = (LimitedPacketDropRequest)request;
                int n = limitedPacketDropRequest.getN();
                limitedPacketDropRequest.setN(n + -1);
                if (((LimitedPacketDropRequest)request).getN() <= 0) {
                    iterator.remove();
                }
            }
            return true;
        }
        return false;
    }

    public void flush(@Nullable ChannelHandlerContext ctx) {
        try {
            if (this.player != null) {
                while (!((Collection)this.queue).isEmpty()) {
                    this.channel.write((Object)this.queue.poll().duplicate());
                }
            }
            super.flush(ctx);
        }
        catch (Throwable t) {
            NovaBootstrapperKt.getLOGGER().error("An exception occurred trying to flush packets", t);
        }
    }

    private final <L extends PacketListener, P extends Packet<? super L>> P callEvent(P msg) {
        PacketEvent<P> packetEvent = PacketEventManager.INSTANCE.createAndCallEvent$nova(this.player, msg);
        if (packetEvent == null) {
            return msg;
        }
        PacketEvent<P> event = packetEvent;
        return event.isCancelled() ? null : (P)event.getPacket();
    }

    public final void queueByteBuf(@NotNull FriendlyByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        ((Collection)this.queue).add(buf);
    }

    public final void dropNextIncoming(int n, @NotNull Function1<? super Packet<?>, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        ((Collection)this.incomingDropQueue).add(new LimitedPacketDropRequest(condition, n));
    }

    public final void dropAllIncoming(@NotNull Function1<? super Packet<?>, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        ((Collection)this.incomingDropQueue).add(new IndefinitePacketDropRequest(condition));
    }

    public final void dropNextOutgoing(int n, @NotNull Function1<? super Packet<?>, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        ((Collection)this.outgoingDropQueue).add(new LimitedPacketDropRequest(condition, n));
    }

    public final void dropAllOutgoing(@NotNull Function1<? super Packet<?>, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        ((Collection)this.outgoingDropQueue).add(new IndefinitePacketDropRequest(condition));
    }

    public final void injectIncoming(@NotNull Object msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (this.channel.eventLoop().inEventLoop()) {
            super.channelRead(this.channel.pipeline().context((ChannelHandler)this), msg);
        } else {
            this.channel.eventLoop().execute(() -> PacketHandler.injectIncoming$lambda$0(this, msg));
        }
    }

    public final void injectOutgoing(@NotNull Object msg, @Nullable ChannelPromise promise) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (this.channel.eventLoop().inEventLoop()) {
            super.write(this.channel.pipeline().context((ChannelHandler)this), msg, promise);
        } else {
            this.channel.eventLoop().execute(() -> PacketHandler.injectOutgoing$lambda$0(this, msg, promise));
        }
    }

    private static final void injectIncoming$lambda$0(PacketHandler this$0, Object $msg) {
        super.channelRead(this$0.channel.pipeline().context((ChannelHandler)this$0), $msg);
    }

    private static final void injectOutgoing$lambda$0(PacketHandler this$0, Object $msg, ChannelPromise $promise) {
        super.write(this$0.channel.pipeline().context((ChannelHandler)this$0), $msg, $promise);
    }
}

