/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.resources.builder;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.resources.ResourcePath;
import xyz.xenondevs.nova.resources.ResourceType;
import xyz.xenondevs.nova.resources.builder.ResourcePackBuilder;
import xyz.xenondevs.nova.resources.builder.font.Font;
import xyz.xenondevs.nova.resources.builder.font.provider.FontProvider;
import xyz.xenondevs.nova.resources.builder.font.provider.ReferenceProvider;
import xyz.xenondevs.nova.resources.builder.font.provider.SpaceProvider;
import xyz.xenondevs.nova.resources.builder.font.provider.bitmap.ArrayCodePointGrid;
import xyz.xenondevs.nova.resources.builder.font.provider.bitmap.BitmapProvider;
import xyz.xenondevs.nova.resources.builder.font.provider.bitmap.RasterGlyphGrid;
import xyz.xenondevs.nova.resources.builder.font.provider.unihex.UnihexProvider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\u0005J\u001c\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J,\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0002J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lxyz/xenondevs/nova/resources/builder/BitmapFontGenerator;", "", "builder", "Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "font", "Lxyz/xenondevs/nova/resources/builder/font/Font;", "<init>", "(Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;Lxyz/xenondevs/nova/resources/builder/font/Font;)V", "generateBitmapFont", "convertUnihexProvider", "", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapProvider;", "", "provider", "Lxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexProvider;", "buildBitmapProvider", "original", "width", "", "glyphRasters", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "determineBitmapTextureFilePath", "Lxyz/xenondevs/nova/resources/ResourcePath;", "Lxyz/xenondevs/nova/resources/ResourceType$FontTexture;", "id", "Lxyz/xenondevs/nova/resources/ResourceType$Font;", "nova"})
@SourceDebugExtension(value={"SMAP\nBitmapFontGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitmapFontGenerator.kt\nxyz/xenondevs/nova/resources/builder/BitmapFontGenerator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n126#2:103\n153#2,3:104\n608#3:107\n1321#3,2:108\n1#4:110\n*S KotlinDebug\n*F\n+ 1 BitmapFontGenerator.kt\nxyz/xenondevs/nova/resources/builder/BitmapFontGenerator\n*L\n55#1:103\n55#1:104,3\n74#1:107\n76#1:108,2\n*E\n"})
public final class BitmapFontGenerator {
    @NotNull
    private final ResourcePackBuilder builder;
    @NotNull
    private final Font font;

    public BitmapFontGenerator(@NotNull ResourcePackBuilder builder, @NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.builder = builder;
        this.font = font;
    }

    @NotNull
    public final Font generateBitmapFont() {
        this.builder.getLogger().info("Creating a bitmap font for " + this.font);
        ArrayList<FontProvider> providers = new ArrayList<FontProvider>();
        for (FontProvider provider : this.font.getProviders()) {
            FontProvider fontProvider = provider;
            if (fontProvider instanceof ReferenceProvider || fontProvider instanceof SpaceProvider || fontProvider instanceof BitmapProvider) {
                providers.add(provider);
                continue;
            }
            if (fontProvider instanceof UnihexProvider) {
                providers.addAll((Collection)this.convertUnihexProvider((UnihexProvider)provider));
                continue;
            }
            this.builder.getLogger().warn("Skipping unsupported font provider type: " + Reflection.getOrCreateKotlinClass(provider.getClass()).getSimpleName());
        }
        return new Font(this.font.getId(), (List<? extends FontProvider>)providers);
    }

    /*
     * WARNING - void declaration
     */
    private final List<BitmapProvider<int[]>> convertUnihexProvider(UnihexProvider provider) {
        void $this$mapTo$iv$iv;
        Map $this$map$iv = (Map)provider.getGlyphRasters();
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer width = (Integer)entry.getKey();
            Int2ObjectOpenHashMap glyphRasters2 = (Int2ObjectOpenHashMap)entry.getValue();
            Intrinsics.checkNotNull((Object)width);
            int n = width;
            Intrinsics.checkNotNull((Object)glyphRasters2);
            BitmapProvider<int[]> bitmapProvider = this.buildBitmapProvider(provider, n, (Int2ObjectMap<int[]>)((Int2ObjectMap)glyphRasters2));
            bitmapProvider.write(this.builder);
            collection.add(bitmapProvider);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final BitmapProvider<int[]> buildBitmapProvider(UnihexProvider original, int width, Int2ObjectMap<int[]> glyphRasters2) {
        void $this$forEach$iv;
        Sequence $this$sortedBy$iv;
        int glyphCount = glyphRasters2.size();
        int rasterWidth = width * glyphCount;
        int[] codePoints = new int[glyphCount];
        int[] raster = new int[rasterWidth * 16];
        ObjectSet objectSet = glyphRasters2.int2ObjectEntrySet();
        Intrinsics.checkNotNullExpressionValue((Object)objectSet, (String)"int2ObjectEntrySet(...)");
        Object object = CollectionsKt.asSequence((Iterable)((Iterable)objectSet));
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = SequencesKt.withIndex((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Int2ObjectMap.Entry it = (Int2ObjectMap.Entry)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getIntKey());
                it = (Int2ObjectMap.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getIntKey()));
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexedValue indexedValue = (IndexedValue)element$iv;
            boolean bl = false;
            int i2 = indexedValue.component1();
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)indexedValue.component2();
            codePoints[i2] = entry.getIntKey();
            int[] glyphRaster = (int[])entry.getValue();
            for (int y = 0; y < 16; ++y) {
                System.arraycopy(glyphRaster, y * width, raster, y * rasterWidth + i2 * width, width);
            }
        }
        object = new int[1][];
        object[0] = (Sequence)codePoints;
        Object $this$buildBitmapProvider_u24lambda_u242 = object = BitmapProvider.Companion.custom1(this.determineBitmapTextureFilePath(this.font.getId(), width), new ArrayCodePointGrid((int[][])object), new RasterGlyphGrid(glyphCount, 1, width, 16, raster), 8, 7);
        boolean bl = false;
        ((FontProvider)$this$buildBitmapProvider_u24lambda_u242).getFilter().putAll(original.getFilter());
        return object;
    }

    private final ResourcePath<ResourceType.FontTexture> determineBitmapTextureFilePath(ResourcePath<ResourceType.Font> id, int width) {
        LinkOption[] linkOptionArray;
        int i2 = 0;
        ResourcePath<ResourceType> path = null;
        do {
            path = new ResourcePath<ResourceType>(ResourceType.FontTexture.INSTANCE, id.getNamespace(), "font/" + id.getPath() + "/nova_bmp/" + width + "x16_" + i2 + ".png");
            ++i2;
            linkOptionArray = new LinkOption[]{};
        } while (Files.exists(this.builder.resolve(path), Arrays.copyOf(linkOptionArray, linkOptionArray.length)));
        return path;
    }
}

