/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.resources.builder.font;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.commons.gson.JsonArraysKt;
import xyz.xenondevs.commons.gson.JsonElementsKt;
import xyz.xenondevs.commons.gson.JsonObjectsKt;
import xyz.xenondevs.nova.resources.ResourcePath;
import xyz.xenondevs.nova.resources.ResourceType;
import xyz.xenondevs.nova.resources.builder.ResourcePackBuilder;
import xyz.xenondevs.nova.resources.builder.font.Font$mapReferences$;
import xyz.xenondevs.nova.resources.builder.font.provider.FontProvider;
import xyz.xenondevs.nova.resources.builder.font.provider.ReferenceProvider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0000J\u0011\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007H\u0086\u0002J\u0017\u0010\u0016\u001a\u00020\u00112\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017H\u0086\u0002J\u0011\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00000\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00000\u0017J\u0014\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00000\u0017J\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020#H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006%"}, d2={"Lxyz/xenondevs/nova/resources/builder/font/Font;", "", "id", "Lxyz/xenondevs/nova/resources/ResourcePath;", "Lxyz/xenondevs/nova/resources/ResourceType$Font;", "providers", "", "Lxyz/xenondevs/nova/resources/builder/font/provider/FontProvider;", "<init>", "(Lxyz/xenondevs/nova/resources/ResourcePath;Ljava/util/List;)V", "getId", "()Lxyz/xenondevs/nova/resources/ResourcePath;", "_providers", "", "getProviders", "()Ljava/util/List;", "addFirst", "", "provider", "add", "addAll", "other", "plusAssign", "", "font", "remove", "mapReferences", "", "fonts", "getCodePoints", "Lit/unimi/dsi/fastutil/ints/IntSet;", "write", "builder", "Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "toString", "", "Companion", "nova"})
@SourceDebugExtension(value={"SMAP\nFont.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Font.kt\nxyz/xenondevs/nova/resources/builder/font/Font\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n477#2:186\n1163#2,2:187\n1165#2:191\n295#3,2:189\n295#3,2:192\n1563#3:194\n1634#3,3:195\n*S KotlinDebug\n*F\n+ 1 Font.kt\nxyz/xenondevs/nova/resources/builder/font/Font\n*L\n84#1:186\n85#1:187,2\n85#1:191\n85#1:189,2\n95#1:192,2\n115#1:194\n115#1:195,3\n*E\n"})
public final class Font {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourcePath<ResourceType.Font> id;
    @NotNull
    private final List<FontProvider> _providers;
    @NotNull
    private static final ResourcePath<ResourceType.Font> DEFAULT = new ResourcePath<ResourceType>(ResourceType.Font.INSTANCE, "minecraft", "default");
    @NotNull
    private static final ResourcePath<ResourceType.Font> UNIFORM = new ResourcePath<ResourceType>(ResourceType.Font.INSTANCE, "minecraft", "uniform");
    @NotNull
    private static final IntRange PRIVATE_USE_AREA = new IntRange(57344, 63743);
    @NotNull
    private static final Regex FONT_NAME_REGEX = new Regex("^([a-z0-9._-]+)/font/([a-z0-9/._-]+)$");

    public Font(@NotNull ResourcePath<ResourceType.Font> id, @NotNull List<? extends FontProvider> providers) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        this.id = id;
        this._providers = CollectionsKt.toMutableList((Collection)providers);
    }

    public /* synthetic */ Font(ResourcePath resourcePath, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(resourcePath, list);
    }

    @NotNull
    public final ResourcePath<ResourceType.Font> getId() {
        return this.id;
    }

    @NotNull
    public final List<FontProvider> getProviders() {
        return this._providers;
    }

    public final void addFirst(@NotNull FontProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this._providers.add(0, provider);
    }

    public final void add(@NotNull FontProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        ((Collection)this._providers).add(provider);
    }

    public final void addAll(@NotNull Font other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        CollectionsKt.addAll((Collection)this._providers, (Iterable)other.getProviders());
    }

    public final void plusAssign(@NotNull FontProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        ((Collection)this._providers).add(provider);
    }

    public final void plusAssign(@NotNull Iterable<? extends FontProvider> providers) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        CollectionsKt.addAll((Collection)this._providers, providers);
    }

    public final void plusAssign(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        CollectionsKt.addAll((Collection)this._providers, (Iterable)font.getProviders());
    }

    public final void remove(@NotNull FontProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        ((Collection)this._providers).remove(provider);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Font> mapReferences(@NotNull Iterable<Font> fonts) {
        void var3_4;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(fonts, (String)"fonts");
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)this.getProviders());
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)mapReferences$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        $this$filterIsInstance$iv = sequence;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            Font font;
            void ref;
            Collection collection;
            block3: {
                ReferenceProvider referenceProvider = (ReferenceProvider)item$iv;
                collection = destination$iv;
                boolean bl = false;
                Iterable<Font> $this$firstOrNull$iv = fonts;
                boolean $i$f$firstOrNull = false;
                Iterator<Font> iterator = $this$firstOrNull$iv.iterator();
                while (iterator.hasNext()) {
                    Font element$iv;
                    Font it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(ref.getId(), it.id)) continue;
                    font = element$iv;
                    break block3;
                }
                font = null;
            }
            Font font2 = font;
            if (font2 == null) {
                throw new IllegalArgumentException("Referenced font " + ref.getId() + " not found");
            }
            collection.add(font2);
        }
        return (Set)var3_4;
    }

    @NotNull
    public final IntSet getCodePoints(@NotNull Iterable<Font> fonts) {
        Intrinsics.checkNotNullParameter(fonts, (String)"fonts");
        IntOpenHashSet codePoints = new IntOpenHashSet();
        for (FontProvider provider : this.getProviders()) {
            boolean bl;
            if (provider instanceof ReferenceProvider) {
                Font font;
                Font font2;
                block4: {
                    Iterable<Font> $this$firstOrNull$iv = fonts;
                    boolean $i$f$firstOrNull = false;
                    Iterator<Font> iterator = $this$firstOrNull$iv.iterator();
                    while (iterator.hasNext()) {
                        Font element$iv;
                        Font it = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.id, ((ReferenceProvider)provider).getId())) continue;
                        font2 = element$iv;
                        break block4;
                    }
                    font2 = null;
                }
                if ((Font)font2 == null) {
                    throw new IllegalArgumentException("Referenced font " + ((ReferenceProvider)provider).getId() + " not found");
                }
                bl = codePoints.addAll((IntCollection)font.getCodePoints(fonts));
                continue;
            }
            bl = codePoints.addAll((IntCollection)provider.getCodePoints());
        }
        return (IntSet)codePoints;
    }

    /*
     * WARNING - void declaration
     */
    public final void write(@NotNull ResourcePackBuilder builder) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Path file = builder.resolve(this.id);
        JsonObject obj = new JsonObject();
        Iterable $this$map$iv = this.getProviders();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FontProvider fontProvider = (FontProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            it.write(builder);
            collection.add(it.toJson());
        }
        List providers = (List)destination$iv$iv;
        obj.add("providers", (JsonElement)JsonArraysKt.toJsonArrayElements((Iterable)providers));
        Path path = file.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        JsonElementsKt.writeToFile((JsonElement)((JsonElement)obj), (Path)file);
    }

    @NotNull
    public String toString() {
        return this.id.toString();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u001e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lxyz/xenondevs/nova/resources/builder/font/Font$Companion;", "", "<init>", "()V", "DEFAULT", "Lxyz/xenondevs/nova/resources/ResourcePath;", "Lxyz/xenondevs/nova/resources/ResourceType$Font;", "getDEFAULT", "()Lxyz/xenondevs/nova/resources/ResourcePath;", "UNIFORM", "getUNIFORM", "PRIVATE_USE_AREA", "Lkotlin/ranges/IntRange;", "getPRIVATE_USE_AREA", "()Lkotlin/ranges/IntRange;", "FONT_NAME_REGEX", "Lkotlin/text/Regex;", "fromDisk", "Lxyz/xenondevs/nova/resources/builder/font/Font;", "builder", "Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "assetsDir", "Ljava/nio/file/Path;", "fontFile", "readIdFromPath", "file", "findFirstUnoccupiedRange", "codePoints", "Lit/unimi/dsi/fastutil/ints/IntSet;", "between", "size", "", "findFirstUnoccupied", "nova"})
    @SourceDebugExtension(value={"SMAP\nFont.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Font.kt\nxyz/xenondevs/nova/resources/builder/font/Font$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n1634#2,3:186\n*S KotlinDebug\n*F\n+ 1 Font.kt\nxyz/xenondevs/nova/resources/builder/font/Font$Companion\n*L\n135#1:186,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourcePath<ResourceType.Font> getDEFAULT() {
            return DEFAULT;
        }

        @NotNull
        public final ResourcePath<ResourceType.Font> getUNIFORM() {
            return UNIFORM;
        }

        @NotNull
        public final IntRange getPRIVATE_USE_AREA() {
            return PRIVATE_USE_AREA;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Font fromDisk(@NotNull ResourcePackBuilder builder, @NotNull Path assetsDir, @NotNull Path fontFile) {
            void $this$mapTo$iv;
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)assetsDir, (String)"assetsDir");
            Intrinsics.checkNotNullParameter((Object)fontFile, (String)"fontFile");
            ResourcePath<ResourceType.Font> id = this.readIdFromPath(assetsDir, fontFile);
            JsonObject jsonObject = JsonElementsKt.parseJson((Path)fontFile).getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
            Iterable iterable = (Iterable)JsonObjectsKt.getArray((JsonObject)jsonObject, (String)"providers");
            Collection destination$iv = new ArrayList();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                JsonElement jsonElement = (JsonElement)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                JsonObject jsonObject2 = it.getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
                collection.add(FontProvider.Companion.fromDisk(builder, jsonObject2));
            }
            ArrayList providers = (ArrayList)destination$iv;
            return new Font(id, providers);
        }

        private final ResourcePath<ResourceType.Font> readIdFromPath(Path assetsDir, Path file) {
            String relPath = StringsKt.substringBeforeLast$default((String)PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)file, (Path)assetsDir)), (char)'.', null, (int)2, null);
            MatchResult matchResult = FONT_NAME_REGEX.matchEntire((CharSequence)relPath);
            if (matchResult == null) {
                throw new IllegalArgumentException("File " + file + " is not a font file");
            }
            MatchResult result = matchResult;
            return new ResourcePath<ResourceType>(ResourceType.Font.INSTANCE, (String)result.getGroupValues().get(1), (String)result.getGroupValues().get(2));
        }

        @NotNull
        public final IntRange findFirstUnoccupiedRange(@NotNull IntSet codePoints, @NotNull IntRange between, int size) {
            int start2;
            Intrinsics.checkNotNullParameter((Object)codePoints, (String)"codePoints");
            Intrinsics.checkNotNullParameter((Object)between, (String)"between");
            for (int i2 = start2 = between.getFirst(); i2 <= between.getLast(); ++i2) {
                if (codePoints.contains(i2)) {
                    start2 = i2 + 1;
                    continue;
                }
                if (i2 - start2 != size) continue;
                return new IntRange(start2, i2);
            }
            throw new IllegalStateException("No unoccupied range of size " + size + " found in " + between);
        }

        public final int findFirstUnoccupied(@NotNull IntSet codePoints, @NotNull IntRange between) {
            Intrinsics.checkNotNullParameter((Object)codePoints, (String)"codePoints");
            Intrinsics.checkNotNullParameter((Object)between, (String)"between");
            int i2 = between.getFirst();
            int n = between.getLast();
            if (i2 <= n) {
                while (true) {
                    if (!codePoints.contains(i2)) {
                        return i2;
                    }
                    if (i2 == n) break;
                    ++i2;
                }
            }
            throw new IllegalStateException("No unoccupied character found in " + between);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

