/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.resources.builder.font.provider.bitmap;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.awt.image.BufferedImage;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2ic;
import xyz.xenondevs.commons.gson.JsonArraysKt;
import xyz.xenondevs.nova.resources.ResourcePath;
import xyz.xenondevs.nova.resources.ResourceType;
import xyz.xenondevs.nova.resources.builder.ResourcePackBuilder;
import xyz.xenondevs.nova.resources.builder.font.provider.FontProvider;
import xyz.xenondevs.nova.resources.builder.font.provider.bitmap.BitmapGlyphImageType;
import xyz.xenondevs.nova.resources.builder.font.provider.bitmap.CodePointGrid;
import xyz.xenondevs.nova.resources.builder.font.provider.bitmap.GlyphGrid;
import xyz.xenondevs.nova.resources.builder.task.PackBuildData;
import xyz.xenondevs.nova.resources.builder.task.TextureContent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 2*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0005./012B\t\b\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u0015X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR!\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!8PX\u0090\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b#\u0010$\u00a8\u00063"}, d2={"Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapProvider;", "T", "Lxyz/xenondevs/nova/resources/builder/font/provider/FontProvider;", "<init>", "()V", "file", "Lxyz/xenondevs/nova/resources/ResourcePath;", "Lxyz/xenondevs/nova/resources/ResourceType$FontTexture;", "getFile", "()Lxyz/xenondevs/nova/resources/ResourcePath;", "height", "", "getHeight", "()I", "ascent", "getAscent", "glyphImageType", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapGlyphImageType;", "getGlyphImageType", "()Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapGlyphImageType;", "codePointGrid", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/CodePointGrid;", "getCodePointGrid", "()Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/CodePointGrid;", "glyphGrid", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/GlyphGrid;", "getGlyphGrid", "()Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/GlyphGrid;", "codePoints", "Lit/unimi/dsi/fastutil/ints/IntSet;", "getCodePoints", "()Lit/unimi/dsi/fastutil/ints/IntSet;", "charSizes", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "", "getCharSizes$nova", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "charSizes$delegate", "Lkotlin/Lazy;", "write", "", "builder", "Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "toJson", "Lcom/google/gson/JsonObject;", "calculateCharSizes", "Reference", "SingleBufferedImage", "SingleLazyLoaded", "Custom", "Companion", "nova"})
@SourceDebugExtension(value={"SMAP\nBitmapProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitmapProvider.kt\nxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,278:1\n1#2:279\n*E\n"})
public abstract class BitmapProvider<T>
extends FontProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy charSizes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Int2ObjectMap<float[]>>((Object)this){

        public final Int2ObjectMap<float[]> invoke() {
            return BitmapProvider.access$calculateCharSizes((BitmapProvider)this.receiver);
        }
    }));

    public BitmapProvider() {
        super("bitmap");
    }

    @NotNull
    public abstract ResourcePath<ResourceType.FontTexture> getFile();

    public abstract int getHeight();

    public abstract int getAscent();

    @NotNull
    protected abstract BitmapGlyphImageType<T> getGlyphImageType();

    @NotNull
    protected abstract CodePointGrid getCodePointGrid();

    @NotNull
    protected abstract GlyphGrid<T> getGlyphGrid();

    @Override
    @NotNull
    public final IntSet getCodePoints() {
        return this.getCodePointGrid().getCodePoints();
    }

    @Override
    @NotNull
    public Int2ObjectMap<float[]> getCharSizes$nova() {
        Lazy lazy = this.charSizes$delegate;
        return (Int2ObjectMap)lazy.getValue();
    }

    @Override
    public void write(@NotNull ResourcePackBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.writeImage(this.getFile(), this.getGlyphGrid().toImage());
    }

    @Override
    @NotNull
    public JsonObject toJson() {
        JsonObject jsonObject;
        JsonObject $this$toJson_u24lambda_u240 = jsonObject = super.toJson();
        boolean bl = false;
        $this$toJson_u24lambda_u240.addProperty("file", this.getFile().toString());
        if (this.getHeight() != 8) {
            $this$toJson_u24lambda_u240.addProperty("height", (Number)this.getHeight());
        }
        $this$toJson_u24lambda_u240.addProperty("ascent", (Number)this.getAscent());
        $this$toJson_u24lambda_u240.add("chars", (JsonElement)JsonArraysKt.toJsonArrayStrings((Iterable)this.getCodePointGrid().toStringList()));
        return jsonObject;
    }

    private final Int2ObjectMap<float[]> calculateCharSizes() {
        Int2ObjectOpenHashMap map2 = new Int2ObjectOpenHashMap();
        BitmapGlyphImageType<T> glyphImageType = this.getGlyphImageType();
        CodePointGrid codePointGrid = this.getCodePointGrid();
        GlyphGrid<T> glyphGrid2 = this.getGlyphGrid();
        int glyphWidth = glyphGrid2.getGlyphWidth();
        int glyphHeight = glyphGrid2.getGlyphHeight();
        int height = this.getHeight();
        int ascent = this.getAscent();
        int n = codePointGrid.getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = codePointGrid.getHeight();
            for (int y = 0; y < n2; ++y) {
                float f;
                T glyph;
                int codePoint = codePointGrid.get(x, y);
                if (codePoint == 0) continue;
                if (glyphGrid2.get(x, y) == null) {
                    throw new IllegalStateException("No glyph present for registered code point " + codePoint);
                }
                float rescale = (float)height / (float)glyphHeight;
                Integer n3 = glyphImageType.findRightBorder(glyph, glyphWidth, glyphHeight);
                if (n3 != null) {
                    int rightBorder = ((Number)n3).intValue();
                    boolean bl = false;
                    f = MathKt.roundToInt((float)((float)(rightBorder + 1) * rescale));
                } else {
                    f = 0.0f;
                }
                float width = f;
                width += 1.0f;
                if (width < 0.0f) {
                    width += 1.0f;
                }
                float minY = 0.0f;
                float maxY = 0.0f;
                Vector2ic horizontalBorders = glyphImageType.findTopBottomBorders(glyph, glyphWidth, glyphHeight);
                if (horizontalBorders != null) {
                    minY = (float)(horizontalBorders.x() - ascent) * rescale;
                    maxY = (float)(horizontalBorders.y() - ascent) * rescale;
                }
                float[] fArray = new float[]{width, minY, maxY};
                map2.put(codePoint, (Object)fArray);
            }
        }
        return (Int2ObjectMap)map2;
    }

    public static final /* synthetic */ Int2ObjectMap access$calculateCharSizes(BitmapProvider $this) {
        return $this.calculateCharSizes();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJG\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00110\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\b\u0012J(\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0005\"\u0004\b\u0001\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00052\u0006\u0010\u0016\u001a\u00020\u000fJ:\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ:\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f\u00a8\u0006\u001c"}, d2={"Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapProvider$Companion;", "", "<init>", "()V", "custom", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapProvider;", "Ljava/awt/image/BufferedImage;", "file", "Lxyz/xenondevs/nova/resources/ResourcePath;", "Lxyz/xenondevs/nova/resources/ResourceType$FontTexture;", "codePointGrid", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/CodePointGrid;", "glyphGrid", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/GlyphGrid;", "height", "", "ascent", "", "custom1", "reference", "T", "provider", "customAscent", "single", "texture", "codePoint", "builder", "Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "nova"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BitmapProvider<BufferedImage> custom(@NotNull ResourcePath<ResourceType.FontTexture> file, @NotNull CodePointGrid codePointGrid, @NotNull GlyphGrid<BufferedImage> glyphGrid2, int height, int ascent) {
            Intrinsics.checkNotNullParameter(file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)codePointGrid, (String)"codePointGrid");
            Intrinsics.checkNotNullParameter(glyphGrid2, (String)"glyphGrid");
            return new Custom<BufferedImage>(BitmapGlyphImageType.Companion.getBUFFERED_IMAGE(), file, codePointGrid, glyphGrid2, height, ascent);
        }

        @JvmName(name="custom1")
        @NotNull
        public final BitmapProvider<int[]> custom1(@NotNull ResourcePath<ResourceType.FontTexture> file, @NotNull CodePointGrid codePointGrid, @NotNull GlyphGrid<int[]> glyphGrid2, int height, int ascent) {
            Intrinsics.checkNotNullParameter(file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)codePointGrid, (String)"codePointGrid");
            Intrinsics.checkNotNullParameter(glyphGrid2, (String)"glyphGrid");
            return new Custom<int[]>(BitmapGlyphImageType.Companion.getARGB_ARRAY(), file, codePointGrid, glyphGrid2, height, ascent);
        }

        @NotNull
        public final <T> BitmapProvider<T> reference(@NotNull BitmapProvider<T> provider, int customAscent) {
            Intrinsics.checkNotNullParameter(provider, (String)"provider");
            return new Reference<T>(provider, customAscent);
        }

        @NotNull
        public final BitmapProvider<BufferedImage> single(@NotNull ResourcePath<ResourceType.FontTexture> file, @NotNull BufferedImage texture, int codePoint, int height, int ascent) {
            Intrinsics.checkNotNullParameter(file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
            return new SingleBufferedImage(file, texture, codePoint, height, ascent);
        }

        @NotNull
        public final BitmapProvider<BufferedImage> single(@NotNull ResourcePackBuilder builder, @NotNull ResourcePath<ResourceType.FontTexture> file, int codePoint, int height, int ascent) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter(file, (String)"file");
            return new SingleLazyLoaded(builder, file, codePoint, height, ascent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002BI\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u000e\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapProvider$Custom;", "T", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapProvider;", "glyphImageType", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapGlyphImageType;", "file", "Lxyz/xenondevs/nova/resources/ResourcePath;", "Lxyz/xenondevs/nova/resources/ResourceType$FontTexture;", "codePointGrid", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/CodePointGrid;", "glyphGrid", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/GlyphGrid;", "height", "", "ascent", "<init>", "(Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapGlyphImageType;Lxyz/xenondevs/nova/resources/ResourcePath;Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/CodePointGrid;Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/GlyphGrid;II)V", "getGlyphImageType", "()Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapGlyphImageType;", "getFile", "()Lxyz/xenondevs/nova/resources/ResourcePath;", "getCodePointGrid", "()Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/CodePointGrid;", "getGlyphGrid", "()Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/GlyphGrid;", "getHeight", "()I", "getAscent", "nova"})
    private static final class Custom<T>
    extends BitmapProvider<T> {
        @NotNull
        private final BitmapGlyphImageType<T> glyphImageType;
        @NotNull
        private final ResourcePath<ResourceType.FontTexture> file;
        @NotNull
        private final CodePointGrid codePointGrid;
        @NotNull
        private final GlyphGrid<T> glyphGrid;
        private final int height;
        private final int ascent;

        public Custom(@NotNull BitmapGlyphImageType<T> glyphImageType, @NotNull ResourcePath<ResourceType.FontTexture> file, @NotNull CodePointGrid codePointGrid, @NotNull GlyphGrid<T> glyphGrid2, int height, int ascent) {
            Intrinsics.checkNotNullParameter(glyphImageType, (String)"glyphImageType");
            Intrinsics.checkNotNullParameter(file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)codePointGrid, (String)"codePointGrid");
            Intrinsics.checkNotNullParameter(glyphGrid2, (String)"glyphGrid");
            this.glyphImageType = glyphImageType;
            this.file = file;
            this.codePointGrid = codePointGrid;
            this.glyphGrid = glyphGrid2;
            this.height = height;
            this.ascent = ascent;
        }

        @Override
        @NotNull
        protected BitmapGlyphImageType<T> getGlyphImageType() {
            return this.glyphImageType;
        }

        @Override
        @NotNull
        public ResourcePath<ResourceType.FontTexture> getFile() {
            return this.file;
        }

        @Override
        @NotNull
        protected CodePointGrid getCodePointGrid() {
            return this.codePointGrid;
        }

        @Override
        @NotNull
        protected GlyphGrid<T> getGlyphGrid() {
            return this.glyphGrid;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public int getAscent() {
            return this.ascent;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020/H\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\tR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00010\u001a8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR \u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R!\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$8PX\u0090\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b&\u0010'\u00a8\u00061"}, d2={"Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapProvider$Reference;", "T", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapProvider;", "delegate", "ascent", "", "<init>", "(Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapProvider;I)V", "getAscent", "()I", "file", "Lxyz/xenondevs/nova/resources/ResourcePath;", "Lxyz/xenondevs/nova/resources/ResourceType$FontTexture;", "getFile", "()Lxyz/xenondevs/nova/resources/ResourcePath;", "height", "getHeight", "glyphImageType", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapGlyphImageType;", "getGlyphImageType", "()Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapGlyphImageType;", "codePointGrid", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/CodePointGrid;", "getCodePointGrid", "()Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/CodePointGrid;", "glyphGrid", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/GlyphGrid;", "getGlyphGrid", "()Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/GlyphGrid;", "filter", "", "", "", "getFilter", "()Ljava/util/Map;", "charSizes", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "", "getCharSizes$nova", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "charSizes$delegate", "Lkotlin/Lazy;", "write", "", "builder", "Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "toJson", "Lcom/google/gson/JsonObject;", "calculateCharSizes", "nova"})
    private static final class Reference<T>
    extends BitmapProvider<T> {
        @NotNull
        private final BitmapProvider<T> delegate;
        private final int ascent;
        @NotNull
        private final Lazy charSizes$delegate;

        public Reference(@NotNull BitmapProvider<T> delegate, int ascent) {
            Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
            this.delegate = delegate;
            this.ascent = ascent;
            this.charSizes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Int2ObjectMap<float[]>>((Object)this){

                public final Int2ObjectMap<float[]> invoke() {
                    return Reference.access$calculateCharSizes((Reference)this.receiver);
                }
            }));
        }

        @Override
        public int getAscent() {
            return this.ascent;
        }

        @Override
        @NotNull
        public ResourcePath<ResourceType.FontTexture> getFile() {
            return this.delegate.getFile();
        }

        @Override
        public int getHeight() {
            return this.delegate.getHeight();
        }

        @Override
        @NotNull
        protected BitmapGlyphImageType<T> getGlyphImageType() {
            return this.delegate.getGlyphImageType();
        }

        @Override
        @NotNull
        protected CodePointGrid getCodePointGrid() {
            return this.delegate.getCodePointGrid();
        }

        @Override
        @NotNull
        protected GlyphGrid<T> getGlyphGrid() {
            return this.delegate.getGlyphGrid();
        }

        @Override
        @NotNull
        public Map<String, Boolean> getFilter() {
            return this.delegate.getFilter();
        }

        @Override
        @NotNull
        public Int2ObjectMap<float[]> getCharSizes$nova() {
            Lazy lazy = this.charSizes$delegate;
            return (Int2ObjectMap)lazy.getValue();
        }

        @Override
        public void write(@NotNull ResourcePackBuilder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        }

        @Override
        @NotNull
        public JsonObject toJson() {
            JsonObject jsonObject;
            JsonObject $this$toJson_u24lambda_u240 = jsonObject = this.delegate.toJson();
            boolean bl = false;
            $this$toJson_u24lambda_u240.addProperty("ascent", (Number)this.getAscent());
            return jsonObject;
        }

        @Override
        private final Int2ObjectMap<float[]> calculateCharSizes() {
            int ascent = this.getAscent();
            int ascentDiff = this.delegate.getAscent() - ascent;
            Int2ObjectOpenHashMap map2 = new Int2ObjectOpenHashMap(this.delegate.getCharSizes$nova().size());
            ObjectIterator objectIterator = this.delegate.getCharSizes$nova().int2ObjectEntrySet().iterator();
            Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
            ObjectIterator objectIterator2 = objectIterator;
            while (objectIterator2.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectIterator2.next();
                int codePoint = entry.getIntKey();
                float[] sizes = (float[])entry.getValue();
                float[] fArray = new float[]{sizes[0], sizes[1] + (float)ascentDiff, sizes[2] + (float)ascentDiff};
                map2.put(codePoint, (Object)fArray);
            }
            return (Int2ObjectMap)map2;
        }

        public static final /* synthetic */ Int2ObjectMap access$calculateCharSizes(Reference $this) {
            return $this.calculateCharSizes();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B5\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\n\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapProvider$SingleBufferedImage;", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapProvider;", "Ljava/awt/image/BufferedImage;", "file", "Lxyz/xenondevs/nova/resources/ResourcePath;", "Lxyz/xenondevs/nova/resources/ResourceType$FontTexture;", "texture", "codePoint", "", "height", "ascent", "<init>", "(Lxyz/xenondevs/nova/resources/ResourcePath;Ljava/awt/image/BufferedImage;III)V", "getFile", "()Lxyz/xenondevs/nova/resources/ResourcePath;", "getHeight", "()I", "getAscent", "glyphImageType", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapGlyphImageType;", "getGlyphImageType", "()Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapGlyphImageType;", "codePointGrid", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/CodePointGrid;", "getCodePointGrid", "()Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/CodePointGrid;", "glyphGrid", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/GlyphGrid;", "getGlyphGrid", "()Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/GlyphGrid;", "nova"})
    private static final class SingleBufferedImage
    extends BitmapProvider<BufferedImage> {
        @NotNull
        private final ResourcePath<ResourceType.FontTexture> file;
        private final int height;
        private final int ascent;
        @NotNull
        private final BitmapGlyphImageType<BufferedImage> glyphImageType;
        @NotNull
        private final CodePointGrid codePointGrid;
        @NotNull
        private final GlyphGrid<BufferedImage> glyphGrid;

        public SingleBufferedImage(@NotNull ResourcePath<ResourceType.FontTexture> file, @NotNull BufferedImage texture, int codePoint, int height, int ascent) {
            Intrinsics.checkNotNullParameter(file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
            this.file = file;
            this.height = height;
            this.ascent = ascent;
            this.glyphImageType = BitmapGlyphImageType.Companion.getBUFFERED_IMAGE();
            this.codePointGrid = CodePointGrid.Companion.single(codePoint);
            this.glyphGrid = GlyphGrid.Companion.single(texture);
        }

        @Override
        @NotNull
        public ResourcePath<ResourceType.FontTexture> getFile() {
            return this.file;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public int getAscent() {
            return this.ascent;
        }

        @Override
        @NotNull
        protected BitmapGlyphImageType<BufferedImage> getGlyphImageType() {
            return this.glyphImageType;
        }

        @Override
        @NotNull
        protected CodePointGrid getCodePointGrid() {
            return this.codePointGrid;
        }

        @Override
        @NotNull
        protected GlyphGrid<BufferedImage> getGlyphGrid() {
            return this.glyphGrid;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\n\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u000b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR!\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006#"}, d2={"Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapProvider$SingleLazyLoaded;", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapProvider;", "Ljava/awt/image/BufferedImage;", "builder", "Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "file", "Lxyz/xenondevs/nova/resources/ResourcePath;", "Lxyz/xenondevs/nova/resources/ResourceType$FontTexture;", "codePoint", "", "height", "ascent", "<init>", "(Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;Lxyz/xenondevs/nova/resources/ResourcePath;III)V", "getFile", "()Lxyz/xenondevs/nova/resources/ResourcePath;", "getHeight", "()I", "getAscent", "glyphImageType", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapGlyphImageType;", "getGlyphImageType", "()Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapGlyphImageType;", "codePointGrid", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/CodePointGrid;", "getCodePointGrid", "()Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/CodePointGrid;", "glyphGrid", "Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/GlyphGrid;", "getGlyphGrid", "()Lxyz/xenondevs/nova/resources/builder/font/provider/bitmap/GlyphGrid;", "glyphGrid$delegate", "Lkotlin/Lazy;", "write", "", "nova"})
    @SourceDebugExtension(value={"SMAP\nBitmapProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitmapProvider.kt\nxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapProvider$SingleLazyLoaded\n+ 2 ResourcePackBuilder.kt\nxyz/xenondevs/nova/resources/builder/ResourcePackBuilder\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,278:1\n372#2:279\n373#2,2:282\n295#3,2:280\n*S KotlinDebug\n*F\n+ 1 BitmapProvider.kt\nxyz/xenondevs/nova/resources/builder/font/provider/bitmap/BitmapProvider$SingleLazyLoaded\n*L\n194#1:279\n194#1:282,2\n194#1:280,2\n*E\n"})
    private static final class SingleLazyLoaded
    extends BitmapProvider<BufferedImage> {
        @NotNull
        private final ResourcePath<ResourceType.FontTexture> file;
        private final int height;
        private final int ascent;
        @NotNull
        private final BitmapGlyphImageType<BufferedImage> glyphImageType;
        @NotNull
        private final CodePointGrid codePointGrid;
        @NotNull
        private final Lazy glyphGrid$delegate;

        public SingleLazyLoaded(@NotNull ResourcePackBuilder builder, @NotNull ResourcePath<ResourceType.FontTexture> file, int codePoint, int height, int ascent) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter(file, (String)"file");
            this.file = file;
            this.height = height;
            this.ascent = ascent;
            this.glyphImageType = BitmapGlyphImageType.Companion.getBUFFERED_IMAGE();
            this.codePointGrid = CodePointGrid.Companion.single(codePoint);
            this.glyphGrid$delegate = LazyKt.lazy(() -> SingleLazyLoaded.glyphGrid_delegate$lambda$0(builder, this));
        }

        @Override
        @NotNull
        public ResourcePath<ResourceType.FontTexture> getFile() {
            return this.file;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public int getAscent() {
            return this.ascent;
        }

        @Override
        @NotNull
        protected BitmapGlyphImageType<BufferedImage> getGlyphImageType() {
            return this.glyphImageType;
        }

        @Override
        @NotNull
        protected CodePointGrid getCodePointGrid() {
            return this.codePointGrid;
        }

        @Override
        @NotNull
        protected GlyphGrid<BufferedImage> getGlyphGrid() {
            Lazy lazy = this.glyphGrid$delegate;
            return (GlyphGrid)lazy.getValue();
        }

        @Override
        public void write(@NotNull ResourcePackBuilder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        }

        /*
         * WARNING - void declaration
         */
        private static final GlyphGrid glyphGrid_delegate$lambda$0(ResourcePackBuilder $builder, SingleLazyLoaded this$0) {
            PackBuildData holder$iv;
            Object v0;
            GlyphGrid.Companion companion;
            block3: {
                void this_$iv;
                ResourcePackBuilder resourcePackBuilder = $builder;
                companion = GlyphGrid.Companion;
                boolean $i$f$getBuildData = false;
                Iterable $this$firstOrNull$iv$iv = this_$iv.getData();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    PackBuildData it$iv = (PackBuildData)element$iv$iv;
                    boolean bl = false;
                    if (!(it$iv instanceof TextureContent)) continue;
                    v0 = element$iv$iv;
                    break block3;
                }
                v0 = null;
            }
            PackBuildData packBuildData = v0;
            if (packBuildData == null) {
                throw new IllegalArgumentException("No holder of type " + Reflection.getOrCreateKotlinClass(TextureContent.class).getSimpleName() + " is present");
            }
            PackBuildData packBuildData2 = holder$iv = packBuildData;
            if (packBuildData2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type xyz.xenondevs.nova.resources.builder.task.TextureContent");
            }
            return companion.single(((TextureContent)((PackBuildData)((TextureContent)packBuildData2))).getImage(this$0.getFile()));
        }
    }
}

