/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.resources.builder.font.provider.unihex;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.io.Closeable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.TypesJVMKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.resources.ResourcePath;
import xyz.xenondevs.nova.resources.ResourceType;
import xyz.xenondevs.nova.resources.builder.ResourcePackBuilder;
import xyz.xenondevs.nova.resources.builder.font.provider.FontProvider;
import xyz.xenondevs.nova.resources.builder.font.provider.unihex.SizeOverride;
import xyz.xenondevs.nova.resources.builder.font.provider.unihex.UnihexGlyphs;
import xyz.xenondevs.nova.serialization.json.GsonKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 ?2\u00020\u0001:\u0003=>?B\u0017\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010)\u001a\u0010\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u001a\u0018\u00010*2\u0006\u0010,\u001a\u00020+J\u001e\u0010-\u001a\u00020.2\u0006\u0010,\u001a\u00020+2\u0006\u0010/\u001a\u00020+2\u0006\u00100\u001a\u00020\u001aJ\u000e\u00101\u001a\u00020.2\u0006\u0010,\u001a\u00020+J\u000e\u00102\u001a\u00020.2\u0006\u00103\u001a\u00020\u000bJ\u000e\u00104\u001a\u00020.2\u0006\u00103\u001a\u00020\u000bJ\u0014\u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0019H\u0002J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\"\u00107\u001a\u0004\u0018\u00010\u001a2\u0006\u0010,\u001a\u00020+2\u0006\u0010/\u001a\u00020+2\u0006\u00100\u001a\u00020\u001aH\u0002J\u0010\u00108\u001a\u00020.2\u0006\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020<H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R'\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8PX\u0090\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u001e\u001a\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006@"}, d2={"Lxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexProvider;", "Lxyz/xenondevs/nova/resources/builder/font/provider/FontProvider;", "hexFile", "Lxyz/xenondevs/nova/resources/ResourcePath;", "Lxyz/xenondevs/nova/resources/ResourceType$UnihexZip;", "<init>", "(Lxyz/xenondevs/nova/resources/ResourcePath;)V", "getHexFile", "()Lxyz/xenondevs/nova/resources/ResourcePath;", "sizeOverrides", "Lit/unimi/dsi/fastutil/objects/ObjectList;", "Lxyz/xenondevs/nova/resources/builder/font/provider/unihex/SizeOverride;", "getSizeOverrides", "()Lit/unimi/dsi/fastutil/objects/ObjectList;", "glyphs", "Lxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexGlyphs;", "getGlyphs", "()Lxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexGlyphs;", "glyphsChanged", "", "getGlyphsChanged", "()Z", "setGlyphsChanged", "(Z)V", "glyphRasters", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "", "getGlyphRasters", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "glyphRasters$delegate", "Lkotlin/Lazy;", "charSizes", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "", "getCharSizes$nova", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "charSizes$delegate", "codePoints", "Lit/unimi/dsi/fastutil/ints/IntSet;", "getCodePoints", "()Lit/unimi/dsi/fastutil/ints/IntSet;", "getGlyph", "Lkotlin/Pair;", "", "codePoint", "addGlyph", "", "width", "glyph", "removeGlyph", "addSizeOverride", "sizeOverride", "removeSizeOverride", "createGlyphRasters", "calculateCharSizes", "calculateBounds", "write", "builder", "Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "toJson", "Lcom/google/gson/JsonObject;", "Custom", "LazyLoaded", "Companion", "nova"})
@SourceDebugExtension(value={"SMAP\nUnihexProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnihexProvider.kt\nxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 IOUtils.kt\nxyz/xenondevs/nova/util/data/IOUtilsKt\n+ 5 Gson.kt\nxyz/xenondevs/nova/serialization/json/GsonKt\n+ 6 Gson.kt\nxyz/xenondevs/commons/gson/GsonKt\n*L\n1#1,274:1\n1#2:275\n1#2:280\n295#3,2:276\n65#4,2:278\n58#5:281\n47#6:282\n22#6:283\n*S KotlinDebug\n*F\n+ 1 UnihexProvider.kt\nxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexProvider\n*L\n203#1:280\n179#1:276,2\n203#1:278,2\n211#1:281\n211#1:282\n211#1:283\n*E\n"})
public abstract class UnihexProvider
extends FontProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourcePath<ResourceType.UnihexZip> hexFile;
    private boolean glyphsChanged;
    @NotNull
    private final Lazy glyphRasters$delegate;
    @NotNull
    private final Lazy charSizes$delegate;

    public UnihexProvider(@NotNull ResourcePath<ResourceType.UnihexZip> hexFile) {
        Intrinsics.checkNotNullParameter(hexFile, (String)"hexFile");
        super("unihex");
        this.hexFile = hexFile;
        this.glyphRasters$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Int2ObjectOpenHashMap<Int2ObjectOpenHashMap<int[]>>>((Object)this){

            public final Int2ObjectOpenHashMap<Int2ObjectOpenHashMap<int[]>> invoke() {
                return UnihexProvider.access$createGlyphRasters((UnihexProvider)this.receiver);
            }
        }));
        this.charSizes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Int2ObjectMap<float[]>>((Object)this){

            public final Int2ObjectMap<float[]> invoke() {
                return UnihexProvider.access$calculateCharSizes((UnihexProvider)this.receiver);
            }
        }));
    }

    @NotNull
    public final ResourcePath<ResourceType.UnihexZip> getHexFile() {
        return this.hexFile;
    }

    @NotNull
    protected abstract ObjectList<SizeOverride> getSizeOverrides();

    @NotNull
    protected abstract UnihexGlyphs getGlyphs();

    protected final boolean getGlyphsChanged() {
        return this.glyphsChanged;
    }

    protected final void setGlyphsChanged(boolean bl) {
        this.glyphsChanged = bl;
    }

    @NotNull
    public final Int2ObjectOpenHashMap<Int2ObjectOpenHashMap<int[]>> getGlyphRasters() {
        Lazy lazy = this.glyphRasters$delegate;
        return (Int2ObjectOpenHashMap)lazy.getValue();
    }

    @Override
    @NotNull
    public Int2ObjectMap<float[]> getCharSizes$nova() {
        Lazy lazy = this.charSizes$delegate;
        return (Int2ObjectMap)lazy.getValue();
    }

    @Override
    @NotNull
    public IntSet getCodePoints() {
        IntOpenHashSet set = new IntOpenHashSet();
        set.addAll((IntCollection)this.getGlyphs().glyphs8().keySet());
        set.addAll((IntCollection)this.getGlyphs().glyphs16().keySet());
        set.addAll((IntCollection)this.getGlyphs().glyphs24().keySet());
        set.addAll((IntCollection)this.getGlyphs().glyphs32().keySet());
        return (IntSet)set;
    }

    @Nullable
    public final Pair<Integer, int[]> getGlyph(int codePoint) {
        Object object;
        block11: {
            block10: {
                object = (int[])this.getGlyphs().glyphs8().get(codePoint);
                if (object == null) break block10;
                int[] it = object;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)8, (Object)it);
                object = pair;
                if (pair != null) break block11;
            }
            int[] nArray = (int[])this.getGlyphs().glyphs16().get(codePoint);
            if (nArray != null) {
                int[] it = nArray;
                boolean bl = false;
                object = TuplesKt.to((Object)16, (Object)it);
            } else {
                Object object2;
                int[] it;
                int[] nArray2 = (int[])this.getGlyphs().glyphs24().get(codePoint);
                if (nArray2 != null) {
                    it = nArray2;
                    boolean bl = false;
                    object2 = TuplesKt.to((Object)24, (Object)it);
                } else {
                    object = null;
                    object2 = object;
                }
                if (object2 == null) {
                    int[] nArray3 = (int[])this.getGlyphs().glyphs32().get(codePoint);
                    if (nArray3 != null) {
                        it = nArray3;
                        boolean bl = false;
                        object = TuplesKt.to((Object)32, (Object)it);
                    } else {
                        object = null;
                    }
                }
            }
        }
        return object;
    }

    public final void addGlyph(int codePoint, int width, @NotNull int[] glyph) {
        Intrinsics.checkNotNullParameter((Object)glyph, (String)"glyph");
        switch (width) {
            case 8: {
                int[] nArray = (int[])this.getGlyphs().glyphs8().put(codePoint, (Object)glyph);
                break;
            }
            case 16: {
                int[] nArray = (int[])this.getGlyphs().glyphs16().put(codePoint, (Object)glyph);
                break;
            }
            case 24: {
                int[] nArray = (int[])this.getGlyphs().glyphs24().put(codePoint, (Object)glyph);
                break;
            }
            case 32: {
                int[] nArray = (int[])this.getGlyphs().glyphs32().put(codePoint, (Object)glyph);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid glyph width: " + width);
            }
        }
        this.glyphsChanged = true;
    }

    public final void removeGlyph(int codePoint) {
        this.getGlyphs().glyphs8().remove(codePoint);
        this.getGlyphs().glyphs16().remove(codePoint);
        this.getGlyphs().glyphs24().remove(codePoint);
        this.getGlyphs().glyphs32().remove(codePoint);
        this.glyphsChanged = true;
    }

    public final void addSizeOverride(@NotNull SizeOverride sizeOverride) {
        Intrinsics.checkNotNullParameter((Object)sizeOverride, (String)"sizeOverride");
        this.getSizeOverrides().add((Object)sizeOverride);
    }

    public final void removeSizeOverride(@NotNull SizeOverride sizeOverride) {
        Intrinsics.checkNotNullParameter((Object)sizeOverride, (String)"sizeOverride");
        this.getSizeOverrides().remove((Object)sizeOverride);
    }

    private final Int2ObjectOpenHashMap<Int2ObjectOpenHashMap<int[]>> createGlyphRasters() {
        Int2ObjectOpenHashMap rasters = new Int2ObjectOpenHashMap();
        Int2ObjectOpenHashMap<int[]> int2ObjectOpenHashMap = this.getGlyphs().glyphs8();
        Intrinsics.checkNotNullExpressionValue(int2ObjectOpenHashMap, (String)"glyphs8(...)");
        UnihexProvider.createGlyphRasters$createForWidth(this, (Int2ObjectOpenHashMap<Int2ObjectOpenHashMap<int[]>>)rasters, 8, (Int2ObjectMap<int[]>)((Int2ObjectMap)int2ObjectOpenHashMap));
        Int2ObjectOpenHashMap<int[]> int2ObjectOpenHashMap2 = this.getGlyphs().glyphs16();
        Intrinsics.checkNotNullExpressionValue(int2ObjectOpenHashMap2, (String)"glyphs16(...)");
        UnihexProvider.createGlyphRasters$createForWidth(this, (Int2ObjectOpenHashMap<Int2ObjectOpenHashMap<int[]>>)rasters, 16, (Int2ObjectMap<int[]>)((Int2ObjectMap)int2ObjectOpenHashMap2));
        Int2ObjectOpenHashMap<int[]> int2ObjectOpenHashMap3 = this.getGlyphs().glyphs24();
        Intrinsics.checkNotNullExpressionValue(int2ObjectOpenHashMap3, (String)"glyphs24(...)");
        UnihexProvider.createGlyphRasters$createForWidth(this, (Int2ObjectOpenHashMap<Int2ObjectOpenHashMap<int[]>>)rasters, 24, (Int2ObjectMap<int[]>)((Int2ObjectMap)int2ObjectOpenHashMap3));
        Int2ObjectOpenHashMap<int[]> int2ObjectOpenHashMap4 = this.getGlyphs().glyphs32();
        Intrinsics.checkNotNullExpressionValue(int2ObjectOpenHashMap4, (String)"glyphs32(...)");
        UnihexProvider.createGlyphRasters$createForWidth(this, (Int2ObjectOpenHashMap<Int2ObjectOpenHashMap<int[]>>)rasters, 32, (Int2ObjectMap<int[]>)((Int2ObjectMap)int2ObjectOpenHashMap4));
        return rasters;
    }

    private final Int2ObjectMap<float[]> calculateCharSizes() {
        Int2ObjectOpenHashMap sizes = new Int2ObjectOpenHashMap();
        Int2ObjectOpenHashMap<int[]> int2ObjectOpenHashMap = this.getGlyphs().glyphs8();
        Intrinsics.checkNotNullExpressionValue(int2ObjectOpenHashMap, (String)"glyphs8(...)");
        UnihexProvider.calculateCharSizes$calcForWidth(this, (Int2ObjectOpenHashMap<float[]>)sizes, 8, (Int2ObjectMap<int[]>)((Int2ObjectMap)int2ObjectOpenHashMap));
        Int2ObjectOpenHashMap<int[]> int2ObjectOpenHashMap2 = this.getGlyphs().glyphs16();
        Intrinsics.checkNotNullExpressionValue(int2ObjectOpenHashMap2, (String)"glyphs16(...)");
        UnihexProvider.calculateCharSizes$calcForWidth(this, (Int2ObjectOpenHashMap<float[]>)sizes, 16, (Int2ObjectMap<int[]>)((Int2ObjectMap)int2ObjectOpenHashMap2));
        Int2ObjectOpenHashMap<int[]> int2ObjectOpenHashMap3 = this.getGlyphs().glyphs24();
        Intrinsics.checkNotNullExpressionValue(int2ObjectOpenHashMap3, (String)"glyphs24(...)");
        UnihexProvider.calculateCharSizes$calcForWidth(this, (Int2ObjectOpenHashMap<float[]>)sizes, 24, (Int2ObjectMap<int[]>)((Int2ObjectMap)int2ObjectOpenHashMap3));
        Int2ObjectOpenHashMap<int[]> int2ObjectOpenHashMap4 = this.getGlyphs().glyphs32();
        Intrinsics.checkNotNullExpressionValue(int2ObjectOpenHashMap4, (String)"glyphs32(...)");
        UnihexProvider.calculateCharSizes$calcForWidth(this, (Int2ObjectOpenHashMap<float[]>)sizes, 32, (Int2ObjectMap<int[]>)((Int2ObjectMap)int2ObjectOpenHashMap4));
        return (Int2ObjectMap)sizes;
    }

    private final int[] calculateBounds(int codePoint, int width, int[] glyph) {
        Object v1;
        block4: {
            Iterable $this$firstOrNull$iv = (Iterable)this.getSizeOverrides();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SizeOverride it = (SizeOverride)element$iv;
                boolean bl = false;
                int n = it.getFrom();
                boolean bl2 = codePoint <= it.getTo() ? n <= codePoint : false;
                if (!bl2) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        SizeOverride sizeOverride = v1;
        int left = 0;
        int right = 0;
        if (sizeOverride == null) {
            int[] nArray = UnihexGlyphs.findVerticalBorders(width, glyph);
            if (nArray == null) {
                return null;
            }
            int[] borders = nArray;
            left = borders[0];
            right = borders[1];
        } else {
            left = sizeOverride.getLeft();
            right = sizeOverride.getRight();
        }
        Object object = new int[2];
        object[0] = left;
        object[1] = right;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull ResourcePackBuilder builder) {
        void $this$useZip$iv;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (!this.glyphsChanged) {
            return;
        }
        Path zipFile = builder.resolve(this.hexFile);
        Path path = zipFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Files.deleteIfExists(zipFile);
        path2 = zipFile;
        boolean create$iv = true;
        boolean $i$f$useZip = false;
        Map env$iv = MapsKt.mapOf((Pair)TuplesKt.to((Object)"create", (Object)true));
        Closeable closeable = FileSystems.newFileSystem((Path)$this$useZip$iv, env$iv);
        Throwable throwable = null;
        try {
            FileSystem it$iv = (FileSystem)closeable;
            boolean bl = false;
            Iterable<Path> iterable = it$iv.getRootDirectories();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
            Object object = CollectionsKt.first(iterable);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            Path root = (Path)object;
            boolean bl2 = false;
            Path f = root.resolve("nova-generated.hex");
            this.getGlyphs().writeUnihexFile(f);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsonObject toJson() {
        void key$iv;
        void $this$addSerialized$iv;
        void $this$toJsonTreeTyped$iv$iv;
        JsonObject jsonObject;
        JsonObject $this$toJson_u24lambda_u240 = jsonObject = super.toJson();
        boolean bl = false;
        $this$toJson_u24lambda_u240.addProperty("hex_file", this.hexFile.toString());
        JsonObject jsonObject2 = $this$toJson_u24lambda_u240;
        String string = "size_overrides";
        ObjectList<SizeOverride> value$iv = this.getSizeOverrides();
        boolean $i$f$addSerialized = false;
        Gson gson = GsonKt.getGSON();
        ObjectList<SizeOverride> src$iv$iv = value$iv;
        boolean $i$f$toJsonTreeTyped = false;
        boolean $i$f$javaTypeOf = false;
        JsonElement jsonElement = $this$toJsonTreeTyped$iv$iv.toJsonTree(src$iv$iv, TypesJVMKt.getJavaType((KType)Reflection.typeOf(ObjectList.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(SizeOverride.class)))));
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"toJsonTree(...)");
        $this$addSerialized$iv.add((String)key$iv, jsonElement);
        return jsonObject;
    }

    private static final void createGlyphRasters$createForWidth(UnihexProvider this$0, Int2ObjectOpenHashMap<Int2ObjectOpenHashMap<int[]>> rasters, int width, Int2ObjectMap<int[]> glyphs2) {
        ObjectIterator objectIterator = glyphs2.int2ObjectEntrySet().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            int[] nArray;
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectIterator2.next();
            int codePoint = entry.getIntKey();
            int[] glyph = (int[])entry.getValue();
            Intrinsics.checkNotNull((Object)glyph);
            if (this$0.calculateBounds(codePoint, width, glyph) == null) continue;
            int left = nArray[0];
            int right = nArray[1];
            int imgWidth = right - left + 1;
            Int2ObjectMap widthMap = null;
            if (!rasters.containsKey(imgWidth)) {
                widthMap = (Int2ObjectMap)new Int2ObjectOpenHashMap();
                rasters.put(imgWidth, (Object)widthMap);
            } else {
                Object object = rasters.get(imgWidth);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                widthMap = (Int2ObjectMap)object;
            }
            int[] raster = UnihexGlyphs.createArgbRaster(width, glyph, left, right, -1, 0x1000000);
            ((Int2ObjectOpenHashMap)widthMap).put(codePoint, (Object)raster);
        }
    }

    private static final void calculateCharSizes$calcForWidth(UnihexProvider this$0, Int2ObjectOpenHashMap<float[]> sizes, int width, Int2ObjectMap<int[]> glyphs2) {
        ObjectIterator objectIterator = glyphs2.int2ObjectEntrySet().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            int[] nArray;
            int[] nArray2;
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectIterator2.next();
            int codePoint = entry.getIntKey();
            int[] glyph = (int[])entry.getValue();
            Intrinsics.checkNotNull((Object)glyph);
            if (this$0.calculateBounds(codePoint, width, glyph) == null) continue;
            int left = nArray2[0];
            int right = nArray2[1];
            if (UnihexGlyphs.findHorizontalBorders(glyph) == null) continue;
            int top = nArray[0];
            int bottom = nArray[1];
            float[] fArray = new float[]{(right - left + 1) / 2 + 1, (float)top / 2.0f, (float)bottom / 2.0f};
            sizes.put(codePoint, (Object)fArray);
        }
    }

    public static final /* synthetic */ Int2ObjectOpenHashMap access$createGlyphRasters(UnihexProvider $this) {
        return $this.createGlyphRasters();
    }

    public static final /* synthetic */ Int2ObjectMap access$calculateCharSizes(UnihexProvider $this) {
        return $this.calculateCharSizes();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexProvider$Companion;", "", "<init>", "()V", "create", "Lxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexProvider;", "hexFile", "Lxyz/xenondevs/nova/resources/ResourcePath;", "Lxyz/xenondevs/nova/resources/ResourceType$UnihexZip;", "fromDisk", "builder", "Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "provider", "Lcom/google/gson/JsonObject;", "nova"})
    @SourceDebugExtension(value={"SMAP\nUnihexProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnihexProvider.kt\nxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexProvider$Companion\n+ 2 Gson.kt\nxyz/xenondevs/nova/serialization/json/GsonKt\n+ 3 Gson.kt\nxyz/xenondevs/commons/gson/GsonKt\n*L\n1#1,274:1\n50#2,4:275\n54#2:282\n47#2:283\n30#3,2:279\n22#3:281\n30#3,2:284\n22#3:286\n*S KotlinDebug\n*F\n+ 1 UnihexProvider.kt\nxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexProvider$Companion\n*L\n267#1:275,4\n267#1:282\n268#1:283\n267#1:279,2\n267#1:281\n268#1:284,2\n268#1:286\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UnihexProvider create(@NotNull ResourcePath<ResourceType.UnihexZip> hexFile) {
            Intrinsics.checkNotNullParameter(hexFile, (String)"hexFile");
            return new Custom(hexFile);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final UnihexProvider fromDisk(@NotNull ResourcePackBuilder builder, @NotNull JsonObject provider) {
            List list;
            Object object;
            void $this$getDeserializedOrNull$iv;
            Object object2;
            void $this$getDeserialized$iv;
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            JsonObject jsonObject = provider;
            String key$iv = "hex_file";
            boolean $i$f$getDeserialized22 = false;
            if (!$this$getDeserialized$iv.has(key$iv)) {
                throw new NoSuchElementException("No JsonElement with key " + key$iv + " found.");
            }
            Gson gson = GsonKt.getGSON();
            JsonElement jsonElement$iv$iv = $this$getDeserialized$iv.get(key$iv);
            boolean $i$f$fromJson22 = false;
            if (jsonElement$iv$iv == null) {
                object2 = null;
            } else {
                void $this$fromJson$iv$iv;
                boolean $i$f$javaTypeOf = false;
                object2 = $this$fromJson$iv$iv.fromJson(jsonElement$iv$iv, TypesJVMKt.getJavaType((KType)Reflection.typeOf(ResourcePath.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(ResourceType.UnihexZip.class)))));
            }
            if (object2 == null) {
                throw new NullPointerException("Could not deserialize JsonElement with key " + key$iv + ".");
            }
            ResourcePath hexFile = (ResourcePath)object2;
            JsonObject $i$f$getDeserialized22 = provider;
            String key$iv2 = "size_overrides";
            boolean $i$f$getDeserializedOrNull = false;
            Gson $i$f$fromJson22 = GsonKt.getGSON();
            JsonElement jsonElement$iv$iv2 = $this$getDeserializedOrNull$iv.get(key$iv2);
            boolean $i$f$fromJson = false;
            if (jsonElement$iv$iv2 == null) {
                object = null;
            } else {
                void $this$fromJson$iv$iv;
                boolean $i$f$javaTypeOf = false;
                object = $this$fromJson$iv$iv.fromJson(jsonElement$iv$iv2, TypesJVMKt.getJavaType((KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(SizeOverride.class)))));
            }
            if ((list = (List)object) == null) {
                list = CollectionsKt.emptyList();
            }
            List sizeOverrides = list;
            return new LazyLoaded(builder, hexFile, sizeOverrides);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexProvider$Custom;", "Lxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexProvider;", "hexFile", "Lxyz/xenondevs/nova/resources/ResourcePath;", "Lxyz/xenondevs/nova/resources/ResourceType$UnihexZip;", "<init>", "(Lxyz/xenondevs/nova/resources/ResourcePath;)V", "sizeOverrides", "Lit/unimi/dsi/fastutil/objects/ObjectArrayList;", "Lxyz/xenondevs/nova/resources/builder/font/provider/unihex/SizeOverride;", "getSizeOverrides", "()Lit/unimi/dsi/fastutil/objects/ObjectArrayList;", "glyphs", "Lxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexGlyphs;", "getGlyphs", "()Lxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexGlyphs;", "nova"})
    private static final class Custom
    extends UnihexProvider {
        @NotNull
        private final ObjectArrayList<SizeOverride> sizeOverrides;
        @NotNull
        private final UnihexGlyphs glyphs;

        public Custom(@NotNull ResourcePath<ResourceType.UnihexZip> hexFile) {
            Intrinsics.checkNotNullParameter(hexFile, (String)"hexFile");
            super(hexFile);
            this.sizeOverrides = new ObjectArrayList();
            this.glyphs = new UnihexGlyphs();
            this.setGlyphsChanged(true);
        }

        @NotNull
        protected ObjectArrayList<SizeOverride> getSizeOverrides() {
            return this.sizeOverrides;
        }

        @Override
        @NotNull
        protected UnihexGlyphs getGlyphs() {
            return this.glyphs;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\t0\t0\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexProvider$LazyLoaded;", "Lxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexProvider;", "builder", "Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "hexFile", "Lxyz/xenondevs/nova/resources/ResourcePath;", "Lxyz/xenondevs/nova/resources/ResourceType$UnihexZip;", "sizeOverrides", "", "Lxyz/xenondevs/nova/resources/builder/font/provider/unihex/SizeOverride;", "<init>", "(Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;Lxyz/xenondevs/nova/resources/ResourcePath;Ljava/util/List;)V", "Lit/unimi/dsi/fastutil/objects/ObjectArrayList;", "kotlin.jvm.PlatformType", "getSizeOverrides", "()Lit/unimi/dsi/fastutil/objects/ObjectArrayList;", "glyphs", "Lxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexGlyphs;", "getGlyphs", "()Lxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexGlyphs;", "glyphs$delegate", "Lkotlin/Lazy;", "loadGlyphs", "nova"})
    @SourceDebugExtension(value={"SMAP\nUnihexProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnihexProvider.kt\nxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexProvider$LazyLoaded\n+ 2 IOUtils.kt\nxyz/xenondevs/nova/util/data/IOUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,274:1\n64#2,3:275\n1#3:278\n1321#4,2:279\n*S KotlinDebug\n*F\n+ 1 UnihexProvider.kt\nxyz/xenondevs/nova/resources/builder/font/provider/unihex/UnihexProvider$LazyLoaded\n*L\n239#1:275,3\n239#1:278\n242#1:279,2\n*E\n"})
    private static final class LazyLoaded
    extends UnihexProvider {
        @NotNull
        private final ResourcePackBuilder builder;
        @NotNull
        private final ObjectArrayList<SizeOverride> sizeOverrides;
        @NotNull
        private final Lazy glyphs$delegate;

        public LazyLoaded(@NotNull ResourcePackBuilder builder, @NotNull ResourcePath<ResourceType.UnihexZip> hexFile, @NotNull List<SizeOverride> sizeOverrides) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter(hexFile, (String)"hexFile");
            Intrinsics.checkNotNullParameter(sizeOverrides, (String)"sizeOverrides");
            super(hexFile);
            this.builder = builder;
            this.sizeOverrides = new ObjectArrayList((Collection)sizeOverrides);
            this.glyphs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<UnihexGlyphs>((Object)this){

                public final UnihexGlyphs invoke() {
                    return LazyLoaded.access$loadGlyphs((LazyLoaded)this.receiver);
                }
            }));
        }

        @NotNull
        protected ObjectArrayList<SizeOverride> getSizeOverrides() {
            return this.sizeOverrides;
        }

        @Override
        @NotNull
        protected UnihexGlyphs getGlyphs() {
            Lazy lazy = this.glyphs$delegate;
            return (UnihexGlyphs)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final UnihexGlyphs loadGlyphs() {
            UnihexGlyphs glyphs2 = new UnihexGlyphs();
            Path $this$useZip_u24default$iv = this.builder.findOrThrow(this.getHexFile());
            boolean create$iv = false;
            boolean $i$f$useZip = false;
            Map env$iv = MapsKt.emptyMap();
            Closeable closeable = FileSystems.newFileSystem($this$useZip_u24default$iv, env$iv);
            Throwable throwable = null;
            try {
                void $this$forEach$iv;
                FileSystem it$iv = (FileSystem)closeable;
                boolean bl = false;
                Iterable<Path> iterable = it$iv.getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                Object object = CollectionsKt.first(iterable);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                Path zip = (Path)object;
                boolean bl2 = false;
                Sequence sequence = SequencesKt.filter((Sequence)PathsKt.walk((Path)zip, (PathWalkOption[])new PathWalkOption[0]), LazyLoaded::loadGlyphs$lambda$0$0);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path it = (Path)element$iv;
                    boolean bl3 = false;
                    glyphs2.merge(UnihexGlyphs.readUnihexFile(it));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return glyphs2;
        }

        private static final boolean loadGlyphs$lambda$0$0(Path it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)PathsKt.getExtension((Path)it), (Object)"hex");
        }

        public static final /* synthetic */ UnihexGlyphs access$loadGlyphs(LazyLoaded $this) {
            return $this.loadGlyphs();
        }
    }
}

