/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.resources.builder.layout.gui;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import xyz.xenondevs.nova.registry.RegistryElementBuilderDsl;
import xyz.xenondevs.nova.resources.ResourcePath;
import xyz.xenondevs.nova.resources.ResourceType;
import xyz.xenondevs.nova.resources.builder.ResourcePackBuilder;
import xyz.xenondevs.nova.resources.builder.layout.gui.GuiTextureAlignment;
import xyz.xenondevs.nova.resources.builder.layout.gui.GuiTextureLayout;

@RegistryElementBuilderDsl
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J\u0014\u0010\u0014\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010\r\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\r\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J \u0010\r\u001a\u00020\u00122\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001a0\u0019J\r\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lxyz/xenondevs/nova/resources/builder/layout/gui/GuiTextureLayoutBuilder;", "", "namespace", "", "resourcePackBuilder", "Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "<init>", "(Ljava/lang/String;Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;)V", "getResourcePackBuilder", "()Lxyz/xenondevs/nova/resources/builder/ResourcePackBuilder;", "texture", "Lxyz/xenondevs/nova/resources/ResourcePath;", "Lxyz/xenondevs/nova/resources/ResourceType$Texture;", "alignment", "Lxyz/xenondevs/nova/resources/builder/layout/gui/GuiTextureAlignment;", "hasInventoryLabel", "", "inventoryLabel", "", "hasInventoryText", "path", "name", "offsetX", "", "offsetY", "Lkotlin/Function2;", "Lorg/joml/Vector2ic;", "build", "Lxyz/xenondevs/nova/resources/builder/layout/gui/GuiTextureLayout;", "build$nova", "nova"})
public final class GuiTextureLayoutBuilder {
    @NotNull
    private final String namespace;
    @NotNull
    private final ResourcePackBuilder resourcePackBuilder;
    @Nullable
    private ResourcePath<ResourceType.Texture> texture;
    @Nullable
    private GuiTextureAlignment alignment;
    private boolean hasInventoryLabel;

    public GuiTextureLayoutBuilder(@NotNull String namespace, @NotNull ResourcePackBuilder resourcePackBuilder) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)resourcePackBuilder, (String)"resourcePackBuilder");
        this.namespace = namespace;
        this.resourcePackBuilder = resourcePackBuilder;
        this.hasInventoryLabel = true;
    }

    @NotNull
    public final ResourcePackBuilder getResourcePackBuilder() {
        return this.resourcePackBuilder;
    }

    public final void inventoryLabel(boolean hasInventoryText) {
        this.hasInventoryLabel = hasInventoryText;
    }

    public final void path(@NotNull ResourcePath<ResourceType.Texture> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        this.texture = path;
    }

    public final void path(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.texture = ResourcePath.Companion.of((ResourceType)ResourceType.Texture.INSTANCE, name, this.namespace);
    }

    public final void alignment(@NotNull GuiTextureAlignment alignment2) {
        Intrinsics.checkNotNullParameter((Object)alignment2, (String)"alignment");
        this.alignment = alignment2;
    }

    public final void alignment(int offsetX, int offsetY) {
        this.alignment = new GuiTextureAlignment.Custom((Vector2ic)new Vector2i(offsetX, offsetY));
    }

    public final void alignment(@NotNull Function2<? super Integer, ? super Integer, ? extends Vector2ic> alignment2) {
        Intrinsics.checkNotNullParameter(alignment2, (String)"alignment");
        this.alignment = new GuiTextureAlignment(alignment2){
            final /* synthetic */ Function2<Integer, Integer, Vector2ic> $alignment;
            {
                this.$alignment = $alignment;
            }

            public Vector2ic getOffset(int width, int height) {
                return (Vector2ic)this.$alignment.invoke((Object)width, (Object)height);
            }
        };
    }

    @NotNull
    public final GuiTextureLayout build$nova() {
        ResourcePath<ResourceType.Texture> resourcePath = this.texture;
        if (resourcePath == null) {
            throw new IllegalStateException("Gui texture path not set");
        }
        GuiTextureAlignment guiTextureAlignment = this.alignment;
        if (guiTextureAlignment == null) {
            guiTextureAlignment = new GuiTextureAlignment.TopLeft(null, null, 3, null);
        }
        return new GuiTextureLayout(resourcePath, guiTextureAlignment, this.hasInventoryLabel);
    }
}

