/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.serialization.json.serializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.commons.gson.JsonElementsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lxyz/xenondevs/nova/serialization/json/serializer/IntRangeSerialization;", "Lcom/google/gson/JsonSerializer;", "Lkotlin/ranges/IntRange;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "nova"})
public final class IntRangeSerialization
implements JsonSerializer<IntRange>,
JsonDeserializer<IntRange> {
    @NotNull
    public static final IntRangeSerialization INSTANCE = new IntRangeSerialization();

    private IntRangeSerialization() {
    }

    @NotNull
    public JsonElement serialize(@NotNull IntRange src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (src.getFirst() == src.getLast()) {
            return (JsonElement)new JsonPrimitive((Number)src.getFirst());
        }
        JsonObject obj = new JsonObject();
        obj.addProperty("min", (Number)src.getFirst());
        obj.addProperty("max", (Number)src.getLast());
        return (JsonElement)obj;
    }

    @NotNull
    public IntRange deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (JsonElementsKt.isNumber((JsonElement)json)) {
            return new IntRange(json.getAsInt(), json.getAsInt());
        }
        JsonObject obj = json.getAsJsonObject();
        int min = obj.get("min").getAsInt();
        int max = obj.get("max").getAsInt();
        return new IntRange(min, max);
    }
}

