/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.ui.menu.explorer.recipes.group;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.StonecuttingRecipe;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.invui.gui.Gui;
import xyz.xenondevs.invui.gui.IngredientMapper;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.invui.item.ItemProvider;
import xyz.xenondevs.nova.ui.menu.explorer.recipes.RecipeChoiceItemKt;
import xyz.xenondevs.nova.ui.menu.explorer.recipes.group.RecipeGroup;
import xyz.xenondevs.nova.util.data.RecipeUtilsKt;
import xyz.xenondevs.nova.world.item.DefaultGuiItems;
import xyz.xenondevs.nova.world.item.recipe.ConversionNovaRecipe;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\n\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\n\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0015"}, d2={"Lxyz/xenondevs/nova/ui/menu/explorer/recipes/group/ConversionRecipeGroup;", "T", "", "Lxyz/xenondevs/nova/ui/menu/explorer/recipes/group/RecipeGroup;", "<init>", "()V", "createGui", "Lxyz/xenondevs/invui/gui/Gui;", "recipe", "(Ljava/lang/Object;)Lxyz/xenondevs/invui/gui/Gui;", "createConversionRecipeGui", "input", "Lorg/bukkit/inventory/RecipeChoice;", "result", "Lorg/bukkit/inventory/ItemStack;", "time", "", "", "inputUIItem", "Lxyz/xenondevs/invui/item/Item;", "outputItem", "nova"})
public abstract class ConversionRecipeGroup<T>
extends RecipeGroup<T> {
    @Override
    @NotNull
    protected Gui createGui(@NotNull T recipe) {
        Gui gui;
        Intrinsics.checkNotNullParameter(recipe, (String)"recipe");
        T t = recipe;
        if (t instanceof CookingRecipe) {
            RecipeChoice recipeChoice = ((CookingRecipe)recipe).getInputChoice();
            Intrinsics.checkNotNullExpressionValue((Object)recipeChoice, (String)"getInputChoice(...)");
            ItemStack itemStack = ((CookingRecipe)recipe).getResult();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getResult(...)");
            gui = this.createConversionRecipeGui(recipeChoice, itemStack, ((CookingRecipe)recipe).getCookingTime());
        } else if (t instanceof StonecuttingRecipe) {
            RecipeChoice recipeChoice = ((StonecuttingRecipe)recipe).getInputChoice();
            Intrinsics.checkNotNullExpressionValue((Object)recipeChoice, (String)"getInputChoice(...)");
            ItemStack itemStack = ((StonecuttingRecipe)recipe).getResult();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getResult(...)");
            gui = this.createConversionRecipeGui(recipeChoice, itemStack, 0);
        } else if (t instanceof ConversionNovaRecipe) {
            gui = this.createConversionRecipeGui(RecipeUtilsKt.getInputStacks(((ConversionNovaRecipe)recipe).getInput()), ((ConversionNovaRecipe)recipe).getResult(), ((ConversionNovaRecipe)recipe).getTime());
        } else {
            throw new UnsupportedOperationException("Unsupported recipe type: " + Reflection.getOrCreateKotlinClass(recipe.getClass()));
        }
        return gui;
    }

    private final Gui createConversionRecipeGui(RecipeChoice input, ItemStack result, int time) {
        return this.createConversionRecipeGui(RecipeChoiceItemKt.createRecipeChoiceItem(input), result, time);
    }

    private final Gui createConversionRecipeGui(List<? extends ItemStack> input, ItemStack result, int time) {
        return this.createConversionRecipeGui(RecipeChoiceItemKt.createRecipeChoiceItemItemStacks(input), result, time);
    }

    private final Gui createConversionRecipeGui(Item inputUIItem, ItemStack outputItem, int time) {
        String[] stringArray = new String[]{". . . . . . . . .", ". . i . t . r . .", ". . . . . . . . ."};
        IngredientMapper ingredientMapper = ((Gui.Builder)Gui.builder().setStructure(stringArray).addIngredient('i', inputUIItem)).addIngredient('r', RecipeChoiceItemKt.createRecipeChoiceItemItemStacks(CollectionsKt.listOf((Object)outputItem)));
        Intrinsics.checkNotNullExpressionValue((Object)ingredientMapper, (String)"addIngredient(...)");
        Gui.Builder builder = (Gui.Builder)ingredientMapper;
        if (time != 0) {
            ComponentLike[] componentLikeArray = new ComponentLike[]{Component.text((double)((double)time / 20.0))};
            builder.addIngredient('t', (ItemProvider)DefaultGuiItems.INSTANCE.getINVISIBLE_ITEM().createClientsideItemBuilder().setName((Component)Component.translatable((String)"menu.nova.recipe.time", (ComponentLike[])componentLikeArray)));
        }
        Gui gui = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)gui, (String)"build(...)");
        return gui;
    }
}

