/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.ui.waila;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.integration.customitems.CustomItemServiceManager;
import xyz.xenondevs.nova.registry.NovaRegistries;
import xyz.xenondevs.nova.ui.overlay.bossbar.BossBarOverlayManager;
import xyz.xenondevs.nova.ui.waila.Waila$getInfo$;
import xyz.xenondevs.nova.ui.waila.WailaKt;
import xyz.xenondevs.nova.ui.waila.info.NovaWailaInfoProvider;
import xyz.xenondevs.nova.ui.waila.info.VanillaWailaInfoProvider;
import xyz.xenondevs.nova.ui.waila.info.WailaInfo;
import xyz.xenondevs.nova.ui.waila.info.WailaLine;
import xyz.xenondevs.nova.ui.waila.info.line.ToolLine;
import xyz.xenondevs.nova.ui.waila.overlay.WailaOverlayCompound;
import xyz.xenondevs.nova.util.BlockUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.BlockPosKt;
import xyz.xenondevs.nova.world.block.NovaBlock;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.format.WorldDataManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0015\u001a\u00020\u0014J\u0012\u0010\u0016\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\u0018\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lxyz/xenondevs/nova/ui/waila/Waila;", "", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Lorg/bukkit/entity/Player;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "lastPosUpdate", "", "lastDataUpdate", "lookingAt", "Lxyz/xenondevs/nova/world/BlockPos;", "active", "", "overlay", "Lxyz/xenondevs/nova/ui/waila/overlay/WailaOverlayCompound;", "prevInfo", "Lxyz/xenondevs/nova/ui/waila/info/WailaInfo;", "setActive", "", "handleTick", "update", "pos", "tryUpdate", "getInfo", "getCustomItemServiceInfo", "block", "Lorg/bukkit/block/Block;", "isBlacklisted", "id", "Lnet/kyori/adventure/key/Key;", "nova"})
@SourceDebugExtension(value={"SMAP\nWaila.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Waila.kt\nxyz/xenondevs/nova/ui/waila/Waila\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n477#2:146\n320#2,7:147\n477#2:154\n320#2,7:155\n1#3:162\n1761#4,3:163\n*S KotlinDebug\n*F\n+ 1 Waila.kt\nxyz/xenondevs/nova/ui/waila/Waila\n*L\n112#1:146\n113#1:147,7\n121#1:154\n122#1:155,7\n141#1:163,3\n*E\n"})
public final class Waila {
    @NotNull
    private final Player player;
    private int lastPosUpdate;
    private int lastDataUpdate;
    @Nullable
    private BlockPos lookingAt;
    private boolean active;
    @NotNull
    private final WailaOverlayCompound overlay;
    @Nullable
    private WailaInfo prevInfo;

    public Waila(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.player = player;
        this.overlay = new WailaOverlayCompound(this.player);
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    public final void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (active) {
            BossBarOverlayManager.INSTANCE.registerOverlay(this.player, this.overlay);
        } else {
            BossBarOverlayManager.INSTANCE.unregisterOverlay(this.player, this.overlay);
        }
    }

    public final void handleTick() {
        int serverTick = NMSUtilsKt.getServerTick();
        if (serverTick - this.lastPosUpdate >= WailaKt.access$getPOS_UPDATE_INTERVAL()) {
            BlockPos pos;
            this.lastPosUpdate = serverTick;
            AttributeInstance attributeInstance = this.player.getAttribute(Attribute.BLOCK_INTERACTION_RANGE);
            Intrinsics.checkNotNull((Object)attributeInstance);
            Block block = this.player.getTargetBlockExact(MathKt.roundToInt((double)attributeInstance.getValue()));
            BlockPos blockPos = pos = block != null ? BlockPosKt.getPos(block) : null;
            if (!Intrinsics.areEqual((Object)pos, (Object)this.lookingAt)) {
                this.lastDataUpdate = serverTick;
                this.update(pos);
            }
        }
        if (serverTick - this.lastDataUpdate >= WailaKt.access$getDATA_UPDATE_INTERVAL()) {
            this.lastDataUpdate = serverTick;
            this.update(this.lookingAt);
        }
    }

    private final void update(BlockPos pos) {
        this.lookingAt = pos;
        this.setActive(this.tryUpdate(pos));
    }

    private final boolean tryUpdate(BlockPos pos) {
        if (pos != null) {
            Key blockId = BlockUtilsKt.getId(pos.getBlock());
            if (this.isBlacklisted(blockId)) {
                return false;
            }
            WailaInfo wailaInfo = this.getInfo(this.player, pos);
            if (wailaInfo == null) {
                return false;
            }
            WailaInfo info = wailaInfo;
            if (!Intrinsics.areEqual((Object)info, (Object)this.prevInfo)) {
                this.prevInfo = info;
                this.overlay.update(info.getIcon(), info.getLines());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final WailaInfo getInfo(Player player, BlockPos pos) {
        NovaBlockState novaState = WorldDataManager.INSTANCE.getBlockState(pos);
        if (novaState != null) {
            void $this$lastOrNull$iv;
            Sequence $this$filterIsInstance$iv;
            NovaBlock material = novaState.getBlock();
            Sequence sequence = CollectionsKt.asSequence((Iterable)((Iterable)NovaRegistries.WAILA_INFO_PROVIDER));
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getInfo$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            $this$filterIsInstance$iv = sequence2;
            boolean $i$f$lastOrNull = false;
            Object last$iv = null;
            for (Object element$iv : $this$lastOrNull$iv) {
                NovaWailaInfoProvider it = (NovaWailaInfoProvider)element$iv;
                boolean bl = false;
                if (!(it.getBlocks() == null || it.getBlocks().contains(material))) continue;
                last$iv = element$iv;
            }
            NovaWailaInfoProvider novaWailaInfoProvider = last$iv;
            return novaWailaInfoProvider != null ? novaWailaInfoProvider.getInfo(player, pos, novaState) : null;
        }
        Block block = pos.getBlock();
        Material material = block.getType();
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
        Material type = material;
        WailaInfo wailaInfo = this.getCustomItemServiceInfo(player, block);
        if (wailaInfo == null) {
            void $this$lastOrNull$iv;
            Sequence $this$filterIsInstance$iv;
            Sequence last$iv = CollectionsKt.asSequence((Iterable)((Iterable)NovaRegistries.WAILA_INFO_PROVIDER));
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getInfo$$inlined$filterIsInstance$2.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            $this$filterIsInstance$iv = sequence;
            boolean $i$f$lastOrNull = false;
            Object last$iv2 = null;
            for (Object element$iv : $this$lastOrNull$iv) {
                VanillaWailaInfoProvider it = (VanillaWailaInfoProvider)element$iv;
                boolean bl = false;
                if (!(it.getMaterials() == null || it.getMaterials().contains(type))) continue;
                last$iv2 = element$iv;
            }
            VanillaWailaInfoProvider vanillaWailaInfoProvider = last$iv2;
            if (vanillaWailaInfoProvider != null) {
                BlockData blockData = block.getBlockData();
                Intrinsics.checkNotNullExpressionValue((Object)blockData, (String)"getBlockData(...)");
                wailaInfo = vanillaWailaInfoProvider.getInfo(player, pos, blockData);
            } else {
                wailaInfo = null;
            }
        }
        return wailaInfo;
    }

    private final WailaInfo getCustomItemServiceInfo(Player player, Block block) {
        String string;
        block7: {
            block6: {
                Object object;
                string = CustomItemServiceManager.INSTANCE.getId(block);
                if (string == null) break block6;
                String it = string;
                boolean bl = false;
                Object object2 = this;
                try {
                    Waila $this$getCustomItemServiceInfo_u24lambda_u240_u240 = object2;
                    boolean bl2 = false;
                    object = Result.constructor-impl((Object)Key.key((String)it));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                Key key = (Key)(Result.isFailure-impl((Object)object2) ? null : object2);
                string = key;
                if (key != null) break block7;
            }
            return null;
        }
        String blockId = string;
        String string2 = player.getLocale();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocale(...)");
        Component component2 = CustomItemServiceManager.INSTANCE.getName(block, string2);
        if (component2 == null) {
            return null;
        }
        Component blockName = component2;
        ArrayList lines = new ArrayList();
        ((Collection)lines).add(new WailaLine(blockName, WailaLine.Alignment.CENTERED));
        Collection collection = lines;
        TextComponent textComponent = Component.text((String)blockId.toString(), (TextColor)((TextColor)NamedTextColor.DARK_GRAY));
        Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(...)");
        collection.add(new WailaLine((Component)textComponent, WailaLine.Alignment.CENTERED));
        ((Collection)lines).add(ToolLine.INSTANCE.getCustomItemServiceToolLine(player, block));
        return new WailaInfo((Key)blockId, lines);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBlacklisted(Key id) {
        boolean bl;
        Iterable $this$any$iv = WailaKt.access$getBLACKLISTED_BLOCKS();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            Pair pair = (Pair)element$iv;
            boolean bl2 = false;
            Regex namespaceRegex = (Regex)pair.component1();
            Regex nameRegex = (Regex)pair.component2();
            String string = id.namespace();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"namespace(...)");
            if (namespaceRegex.matches((CharSequence)string)) {
                String string2 = id.value();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value(...)");
                if (nameRegex.matches((CharSequence)string2)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }
}

