/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.ui.waila.overlay;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.ShadowColor;
import net.kyori.adventure.util.ARGBLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.resources.builder.task.FontChar;
import xyz.xenondevs.nova.ui.overlay.bossbar.BossBarOverlay;
import xyz.xenondevs.nova.ui.waila.overlay.OverlayCacheKey;
import xyz.xenondevs.nova.ui.waila.overlay.OverlayData;
import xyz.xenondevs.nova.ui.waila.overlay.WailaImageOverlayKt;
import xyz.xenondevs.nova.util.component.adventure.ComponentUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0013J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0002R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lxyz/xenondevs/nova/ui/waila/overlay/WailaImageOverlay;", "Lxyz/xenondevs/nova/ui/overlay/bossbar/BossBarOverlay;", "<init>", "()V", "centerX", "", "getCenterX", "()Ljava/lang/Void;", "offset", "", "getOffset", "()I", "value", "Lnet/kyori/adventure/text/Component;", "component", "getComponent", "()Lnet/kyori/adventure/text/Component;", "update", "Lkotlin/Pair;", "", "icon", "Lxyz/xenondevs/nova/resources/builder/task/FontChar;", "lines", "longestLineLength", "getWidth", "locale", "", "getChar", "type", "nova"})
@SourceDebugExtension(value={"SMAP\nWailaImageOverlay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WailaImageOverlay.kt\nxyz/xenondevs/nova/ui/waila/overlay/WailaImageOverlay\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1#2:130\n*E\n"})
public final class WailaImageOverlay
implements BossBarOverlay {
    @Nullable
    private final Void centerX;
    private final int offset;
    @NotNull
    private Component component;

    public WailaImageOverlay() {
        TextComponent textComponent = Component.empty();
        Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"empty(...)");
        this.component = (Component)textComponent;
    }

    @Nullable
    public Void getCenterX() {
        return this.centerX;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    @NotNull
    public Component getComponent() {
        return this.component;
    }

    @NotNull
    public final Pair<Float, Float> update(@Nullable FontChar icon, int lines, float longestLineLength) {
        if (!(2 <= lines ? lines < 11 : false)) {
            boolean $i$a$-require-WailaImageOverlay$update$22 = false;
            String $i$a$-require-WailaImageOverlay$update$22 = "Unsupported line amount: " + lines;
            throw new IllegalArgumentException($i$a$-require-WailaImageOverlay$update$22.toString());
        }
        Object object = WailaImageOverlayKt.access$getOverlayCache$p().get((Object)new OverlayCacheKey(icon, lines, longestLineLength), () -> WailaImageOverlay.update$lambda$1(longestLineLength, icon, this, lines));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        OverlayData overlayData = (OverlayData)object;
        Component components = overlayData.component1();
        float textBeginX = overlayData.component2();
        float textCenterX = overlayData.component3();
        this.component = components;
        return TuplesKt.to((Object)Float.valueOf(textBeginX), (Object)Float.valueOf(textCenterX));
    }

    @Override
    public float getWidth(@NotNull String locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return 0.0f;
    }

    private final String getChar(int lines, int type) {
        int lineIndex = RangesKt.coerceAtLeast((int)(lines - 2), (int)0);
        return String.valueOf((char)(61440 + lineIndex * 3 + type));
    }

    private final Component getComponent(int lines, int type) {
        TextComponent textComponent = Component.text((String)this.getChar(lines, type));
        Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"text(...)");
        Component component2 = ComponentUtilsKt.font((Component)textComponent, "nova:waila").shadowColor((ARGBLike)ShadowColor.none());
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"shadowColor(...)");
        return component2;
    }

    private static final OverlayData update$lambda$1(float $longestLineLength, FontChar $icon, WailaImageOverlay this$0, int $lines) {
        float optimalWidth = (float)4 + $longestLineLength + (float)4;
        if ($icon != null) {
            optimalWidth += (float)34;
        }
        int partAmount = (int)Math.ceil((double)optimalWidth / 10.0);
        int actualWidth = 2 + partAmount * 10 + 2;
        float halfWidth = (float)actualWidth / 2.0f;
        TextComponent.Builder builder = Component.text();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"text(...)");
        ComponentBuilder componentBuilder = ((TextComponent.Builder)ComponentUtilsKt.move((ComponentBuilder)builder, Float.valueOf(-halfWidth))).append(this$0.getComponent($lines, 0));
        Intrinsics.checkNotNullExpressionValue((Object)componentBuilder, (String)"append(...)");
        TextComponent.Builder builder2 = (TextComponent.Builder)ComponentUtilsKt.move(componentBuilder, -1);
        int n = 0;
        while (n < partAmount) {
            int it = n++;
            boolean bl = false;
            ComponentBuilder componentBuilder2 = builder2.append(this$0.getComponent($lines, 1));
            Intrinsics.checkNotNullExpressionValue((Object)componentBuilder2, (String)"append(...)");
            ComponentUtilsKt.move(componentBuilder2, -1);
        }
        ComponentBuilder componentBuilder3 = builder2.append(this$0.getComponent($lines, 2));
        Intrinsics.checkNotNullExpressionValue((Object)componentBuilder3, (String)"append(...)");
        ComponentUtilsKt.moveTo$default(componentBuilder3, Float.valueOf(-halfWidth + (float)2 + (float)2), null, 2, null);
        if ($icon != null) {
            Intrinsics.checkNotNull((Object)builder2);
            ComponentUtilsKt.append((ComponentBuilder)builder2, $icon);
        }
        Intrinsics.checkNotNull((Object)builder2);
        ComponentUtilsKt.moveTo$default((ComponentBuilder)builder2, 0, null, 2, null);
        BuildableComponent buildableComponent = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)buildableComponent, (String)"build(...)");
        TextComponent component2 = (TextComponent)buildableComponent;
        float textMin = -halfWidth + (float)4;
        if ($icon != null) {
            textMin += (float)34;
        }
        float textMax = halfWidth - (float)4;
        float textCenterX = (textMin + textMax) / (float)2;
        return new OverlayData((Component)component2, textMin, textCenterX);
    }
}

