/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.commons.collections.MapsKt;
import xyz.xenondevs.nova.util.MetricPrefix;
import xyz.xenondevs.nova.util.NumberFormatUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0010J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010J \u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0002J(\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lxyz/xenondevs/nova/util/NumberFormatUtils;", "", "<init>", "()V", "IGNORED_ENERGY_PREFIXES", "", "IGNORED_FLUID_PREFIXES", "NUMBER_FORMAT", "Ljava/text/NumberFormat;", "kotlin.jvm.PlatformType", "ROMAN_NUMERALS", "Ljava/util/TreeMap;", "", "", "getEnergyString", "energy", "", "maxEnergy", "getFluidString", "fluid", "maxFluid", "getSoleString", "ignoredPrefixes", "number", "Ljava/math/BigDecimal;", "unit", "getOutOfString", "maxNumber", "getRomanNumeral", "nova"})
@SourceDebugExtension(value={"SMAP\nNumberFormatUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberFormatUtils.kt\nxyz/xenondevs/nova/util/NumberFormatUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public final class NumberFormatUtils {
    @NotNull
    public static final NumberFormatUtils INSTANCE = new NumberFormatUtils();
    @NotNull
    private static final boolean[] IGNORED_ENERGY_PREFIXES;
    @NotNull
    private static final boolean[] IGNORED_FLUID_PREFIXES;
    private static final NumberFormat NUMBER_FORMAT;
    @NotNull
    private static final TreeMap<Integer, String> ROMAN_NUMERALS;

    private NumberFormatUtils() {
    }

    @NotNull
    public final String getEnergyString(long energy) {
        return NumberFormatUtilsKt.access$getUSE_METRIC_PREFIXES() ? this.getSoleString(IGNORED_ENERGY_PREFIXES, new BigDecimal(energy), "J") : NUMBER_FORMAT.format(energy) + " J";
    }

    @NotNull
    public final String getEnergyString(long energy, long maxEnergy) {
        return NumberFormatUtilsKt.access$getUSE_METRIC_PREFIXES() ? this.getOutOfString(IGNORED_ENERGY_PREFIXES, new BigDecimal(energy), new BigDecimal(maxEnergy), "J") : NUMBER_FORMAT.format(energy) + " J / " + NUMBER_FORMAT.format(maxEnergy) + " J";
    }

    @NotNull
    public final String getFluidString(long fluid) {
        Object object;
        if (NumberFormatUtilsKt.access$getUSE_METRIC_PREFIXES()) {
            BigDecimal bigDecimal = new BigDecimal(fluid);
            BigDecimal bigDecimal2 = BigDecimal.valueOf(1000);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(...)");
            BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"divide(...)");
            object = this.getSoleString(IGNORED_FLUID_PREFIXES, bigDecimal3, "B");
        } else {
            object = NUMBER_FORMAT.format(fluid) + " mB";
        }
        return object;
    }

    @NotNull
    public final String getFluidString(long fluid, long maxFluid) {
        Object object;
        if (NumberFormatUtilsKt.access$getUSE_METRIC_PREFIXES()) {
            BigDecimal bigDecimal = new BigDecimal(fluid);
            BigDecimal bigDecimal2 = BigDecimal.valueOf(1000);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(...)");
            BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"divide(...)");
            BigDecimal bigDecimal4 = new BigDecimal(maxFluid);
            BigDecimal bigDecimal5 = BigDecimal.valueOf(1000);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"valueOf(...)");
            BigDecimal bigDecimal6 = bigDecimal4.divide(bigDecimal5);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal6, (String)"divide(...)");
            object = this.getOutOfString(IGNORED_FLUID_PREFIXES, bigDecimal3, bigDecimal6, "B");
        } else {
            object = NUMBER_FORMAT.format(fluid) + " mB / " + NUMBER_FORMAT.format(maxFluid) + " mB";
        }
        return object;
    }

    private final String getSoleString(boolean[] ignoredPrefixes, BigDecimal number, String unit) {
        Pair<BigDecimal, MetricPrefix> closest = MetricPrefix.Companion.findBestPrefix(number, ignoredPrefixes);
        MetricPrefix prefix = (MetricPrefix)((Object)closest.getSecond());
        BigDecimal it = ((BigDecimal)closest.getFirst()).setScale(2, RoundingMode.HALF_UP);
        boolean bl = false;
        String resultNumber = (prefix == MetricPrefix.NONE ? it.stripTrailingZeros() : it).toPlainString();
        return resultNumber + " " + prefix.getPrefixSymbol() + unit;
    }

    private final String getOutOfString(boolean[] ignoredPrefixes, BigDecimal number, BigDecimal maxNumber, String unit) {
        String string;
        Pair<BigDecimal, MetricPrefix> bestMaxNumber = MetricPrefix.Companion.findBestPrefix(maxNumber, ignoredPrefixes);
        MetricPrefix prefix = (MetricPrefix)((Object)bestMaxNumber.getSecond());
        if (Intrinsics.areEqual((Object)number, (Object)BigDecimal.ZERO)) {
            string = "0";
        } else {
            BigDecimal it = number.divide(prefix.getNumber()).setScale(2, RoundingMode.HALF_UP);
            boolean bl = false;
            string = (prefix == MetricPrefix.NONE ? it.stripTrailingZeros() : it).toPlainString();
        }
        String prefixedNumber = string;
        String prefixedMaxNumber = ((BigDecimal)bestMaxNumber.getFirst()).setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
        String prefixedUnit = prefix.getPrefixSymbol() + unit;
        return prefixedNumber + " " + prefixedUnit + " / " + prefixedMaxNumber + " " + prefixedUnit;
    }

    @NotNull
    public final String getRomanNumeral(int number) {
        Integer l = ROMAN_NUMERALS.floorKey(number);
        Integer n = l;
        if (n != null && number == n) {
            String string = ROMAN_NUMERALS.get(number);
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        String string = ROMAN_NUMERALS.get(l);
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNull((Object)l);
        return string + this.getRomanNumeral(number - l);
    }

    static {
        Object object = new MetricPrefix[]{MetricPrefix.YOCTO, MetricPrefix.ZEPTO, MetricPrefix.ATTO, MetricPrefix.FEMTO, MetricPrefix.PICO, MetricPrefix.NANO, MetricPrefix.MICRO, MetricPrefix.MILLI, MetricPrefix.CENTI, MetricPrefix.DECI, MetricPrefix.DEKA, MetricPrefix.HECTO};
        IGNORED_ENERGY_PREFIXES = MetricPrefix.Companion.generateIgnoredArray((MetricPrefix[])object);
        object = new MetricPrefix[]{MetricPrefix.YOCTO, MetricPrefix.ZEPTO, MetricPrefix.ATTO, MetricPrefix.FEMTO, MetricPrefix.PICO, MetricPrefix.NANO, MetricPrefix.MICRO, MetricPrefix.CENTI, MetricPrefix.DECI, MetricPrefix.DEKA, MetricPrefix.HECTO};
        IGNORED_FLUID_PREFIXES = MetricPrefix.Companion.generateIgnoredArray((MetricPrefix[])object);
        Object $this$NUMBER_FORMAT_u24lambda_u240 = object = NumberFormat.getInstance(Locale.US);
        boolean bl = false;
        ((NumberFormat)$this$NUMBER_FORMAT_u24lambda_u240).setGroupingUsed(true);
        NUMBER_FORMAT = object;
        object = new Pair[]{TuplesKt.to((Object)1, (Object)"I"), TuplesKt.to((Object)4, (Object)"IV"), TuplesKt.to((Object)5, (Object)"V"), TuplesKt.to((Object)9, (Object)"IX"), TuplesKt.to((Object)10, (Object)"X"), TuplesKt.to((Object)40, (Object)"XL"), TuplesKt.to((Object)50, (Object)"L"), TuplesKt.to((Object)90, (Object)"XC"), TuplesKt.to((Object)100, (Object)"C"), TuplesKt.to((Object)400, (Object)"CD"), TuplesKt.to((Object)500, (Object)"D"), TuplesKt.to((Object)900, (Object)"CM"), TuplesKt.to((Object)1000, (Object)"M")};
        ROMAN_NUMERALS = MapsKt.treeMapOf((Pair[])object);
    }
}

