/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.util.data;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.util.data.BinaryUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u001f\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0012\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lxyz/xenondevs/nova/util/data/HashUtils;", "", "<init>", "()V", "getFileHash", "", "file", "Ljava/nio/file/Path;", "algorithm", "", "Ljava/io/File;", "getHash", "inputStream", "Ljava/io/InputStream;", "data", "getUUID", "Ljava/util/UUID;", "objects", "", "([Ljava/lang/Object;)Ljava/util/UUID;", "nova"})
@SourceDebugExtension(value={"SMAP\nHashUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HashUtils.kt\nxyz/xenondevs/nova/util/data/HashUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,59:1\n1#2:60\n13805#3,2:61\n*S KotlinDebug\n*F\n+ 1 HashUtils.kt\nxyz/xenondevs/nova/util/data/HashUtils\n*L\n55#1:61,2\n*E\n"})
public final class HashUtils {
    @NotNull
    public static final HashUtils INSTANCE = new HashUtils();

    private HashUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] getFileHash(@NotNull Path file, @NotNull String algorithm) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            byArray = INSTANCE.getHash(it, algorithm);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] getFileHash(@NotNull File file, @NotNull String algorithm) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            byArray = INSTANCE.getHash(it, algorithm);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    @NotNull
    public final byte[] getHash(@NotNull InputStream inputStream, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        MessageDigest md = MessageDigest.getInstance(algorithm);
        int len = 0;
        byte[] buffer = new byte[4096];
        while (true) {
            HashUtils $this$getHash_u24lambda_u240 = this;
            boolean bl = false;
            len = inputStream.read(buffer);
            if (len == -1) break;
            md.update(buffer, 0, len);
        }
        byte[] byArray = md.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    @NotNull
    public final byte[] getHash(@NotNull byte[] data2, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(data2);
        byte[] byArray = md.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    @NotNull
    public final UUID getUUID(Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        ByteBuf buffer = Unpooled.buffer();
        Object[] $this$forEach$iv = objects;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            Object element$iv;
            Object it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            buffer.writeInt(it.hashCode());
        }
        Intrinsics.checkNotNull((Object)buffer);
        UUID uUID = UUID.nameUUIDFromBytes(BinaryUtilsKt.toByteArray(buffer));
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"nameUUIDFromBytes(...)");
        return uUID;
    }
}

