/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.tileentity;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.internal.HashMapSerializer;
import kotlinx.serialization.internal.HashSetSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import kotlinx.serialization.modules.SerializersModule;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.Nova;
import xyz.xenondevs.nova.config.PermanentStorage;
import xyz.xenondevs.nova.config.PermanentStorageMigrations;
import xyz.xenondevs.nova.initialize.DisableFun;
import xyz.xenondevs.nova.initialize.InitFun;
import xyz.xenondevs.nova.initialize.InternalInit;
import xyz.xenondevs.nova.initialize.InternalInitStage;
import xyz.xenondevs.nova.world.ChunkPos;

@InternalInit(stage=InternalInitStage.POST_WORLD, dependsOn={PermanentStorageMigrations.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0003J\b\u0010\u000b\u001a\u00020\nH\u0003J\u0016\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\bJ\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\bJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u0006H\u0002R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lxyz/xenondevs/nova/world/block/tileentity/ChunkLoadManager;", "", "<init>", "()V", "forceLoadedChunks", "Ljava/util/HashMap;", "Lxyz/xenondevs/nova/world/ChunkPos;", "Ljava/util/HashSet;", "Ljava/util/UUID;", "init", "", "disable", "submitChunkLoadRequest", "chunk", "uuid", "revokeChunkLoadRequest", "getChunkLoaderSet", "nova"})
@SourceDebugExtension(value={"SMAP\nChunkLoadManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkLoadManager.kt\nxyz/xenondevs/nova/world/block/tileentity/ChunkLoadManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 PermanentStorage.kt\nxyz/xenondevs/nova/config/PermanentStorage\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 IOUtils.kt\nxyz/xenondevs/nova/util/data/IOUtilsKt\n+ 6 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n*L\n1#1,56:1\n1374#2:57\n1460#2,5:58\n1869#2,2:63\n82#3:65\n85#3:71\n1#4:66\n1#4:70\n1#4:72\n100#5:67\n101#5:69\n75#5:73\n42#6:68\n80#6:74\n*S KotlinDebug\n*F\n+ 1 ChunkLoadManager.kt\nxyz/xenondevs/nova/world/block/tileentity/ChunkLoadManager\n*L\n24#1:57\n24#1:58,5\n24#1:63,2\n33#1:65\n20#1:71\n33#1:66\n20#1:72\n33#1:67\n33#1:69\n20#1:73\n33#1:68\n20#1:74\n*E\n"})
public final class ChunkLoadManager {
    @NotNull
    public static final ChunkLoadManager INSTANCE;
    @NotNull
    private static final HashMap<ChunkPos, HashSet<UUID>> forceLoadedChunks;

    private ChunkLoadManager() {
    }

    /*
     * WARNING - void declaration
     */
    @InitFun
    private final void init() {
        void $this$flatMapTo$iv$iv;
        List list = Bukkit.getWorlds();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getWorlds(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            World it = (World)element$iv$iv;
            boolean bl = false;
            Collection collection = it.getForceLoadedChunks();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getForceLoadedChunks(...)");
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Chunk it = (Chunk)element$iv;
            boolean bl = false;
            it.setForceLoaded(false);
        }
        Iterator<ChunkPos> iterator = forceLoadedChunks.keySet().iterator();
        while (iterator.hasNext()) {
            ChunkPos chunk;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            World world = chunk.getWorld();
            if (world == null) continue;
            world.addPluginChunkTicket(chunk.getX(), chunk.getZ(), (Plugin)Nova.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @DisableFun
    private final void disable() {
        void $this$writeJson$iv$iv;
        void key$iv;
        void this_$iv;
        PermanentStorage permanentStorage = PermanentStorage.INSTANCE;
        String string = "forceLoadedChunks";
        HashMap<ChunkPos, HashSet<UUID>> data$iv = forceLoadedChunks;
        boolean $i$f$store = false;
        Path path = this_$iv.getPath((String)key$iv);
        Object it$iv = path;
        boolean bl = false;
        PathsKt.createParentDirectories((Path)it$iv, (FileAttribute[])new FileAttribute[0]);
        it$iv = data$iv;
        Json json$iv$iv = this_$iv.getJSON();
        boolean $i$f$writeJson = false;
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream((Path)$this$writeJson$iv$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        Closeable closeable = outputStream;
        Throwable throwable = null;
        try {
            void value$iv$iv$iv;
            void $this$encodeToStream$iv$iv$iv;
            void value$iv$iv;
            OutputStream it$iv$iv = (OutputStream)closeable;
            boolean bl2 = false;
            Json json = json$iv$iv;
            void var14_17 = value$iv$iv;
            OutputStream stream$iv$iv$iv = it$iv$iv;
            boolean $i$f$encodeToStream = false;
            SerializersModule serializersModule = $this$encodeToStream$iv$iv$iv.getSerializersModule();
            JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv$iv$iv, (SerializationStrategy)((SerializationStrategy)new HashMapSerializer(ChunkPos.Companion.serializer(), (KSerializer)new HashSetSerializer(SerializersKt.noCompiledSerializer((SerializersModule)serializersModule, (KClass)Reflection.getOrCreateKotlinClass(UUID.class))))), (Object)value$iv$iv$iv, (OutputStream)stream$iv$iv$iv);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void submitChunkLoadRequest(@NotNull ChunkPos chunk, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        HashSet<UUID> requesterSet = this.getChunkLoaderSet(chunk);
        if (requesterSet.isEmpty()) {
            World world = chunk.getWorld();
            if (world != null) {
                world.addPluginChunkTicket(chunk.getX(), chunk.getZ(), (Plugin)Nova.INSTANCE);
            }
        }
        requesterSet.add(uuid);
    }

    public final void revokeChunkLoadRequest(@NotNull ChunkPos chunk, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        HashSet<UUID> requesterSet = this.getChunkLoaderSet(chunk);
        requesterSet.remove(uuid);
        if (requesterSet.isEmpty()) {
            World world = chunk.getWorld();
            if (world != null) {
                world.removePluginChunkTicket(chunk.getX(), chunk.getZ(), (Plugin)Nova.INSTANCE);
            }
            forceLoadedChunks.remove(chunk);
        }
    }

    private final HashSet<UUID> getChunkLoaderSet(ChunkPos chunk) {
        HashSet<UUID> hashSet = forceLoadedChunks.get(chunk);
        if (hashSet == null) {
            HashSet hashSet2;
            HashSet it = hashSet2 = new HashSet();
            boolean bl = false;
            ((Map)forceLoadedChunks).put(chunk, it);
            hashSet = hashSet2;
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static {
        HashMap hashMap;
        Object object;
        void this_$iv;
        Path path;
        INSTANCE = new ChunkLoadManager();
        PermanentStorage permanentStorage = PermanentStorage.INSTANCE;
        String key$iv = "forceLoadedChunks";
        boolean $i$f$retrieve = false;
        Path it$iv = path = this_$iv.getPath(key$iv);
        boolean bl = false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        Path path2 = Files.exists(it$iv, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path : null;
        if (path2 != null) {
            void $this$readJson$iv$iv;
            path = path2;
            Json json$iv$iv = this_$iv.getJSON();
            boolean $i$f$readJson = false;
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream((Path)$this$readJson$iv$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                void $this$decodeFromStream$iv$iv$iv;
                InputStream it$iv$iv = (InputStream)closeable;
                boolean bl2 = false;
                Json json = json$iv$iv;
                InputStream stream$iv$iv$iv = it$iv$iv;
                boolean $i$f$decodeFromStream = false;
                SerializersModule serializersModule = $this$decodeFromStream$iv$iv$iv.getSerializersModule();
                Object object2 = JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv$iv$iv, (DeserializationStrategy)((DeserializationStrategy)BuiltinSerializersKt.getNullable((KSerializer)new HashMapSerializer(ChunkPos.Companion.serializer(), (KSerializer)new HashSetSerializer(SerializersKt.noCompiledSerializer((SerializersModule)serializersModule, (KClass)Reflection.getOrCreateKotlinClass(UUID.class)))))), (InputStream)stream$iv$iv$iv);
                object = object2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            object = null;
        }
        if ((hashMap = (HashMap)object) == null) {
            hashMap = new HashMap();
        }
        forceLoadedChunks = hashMap;
    }
}

