/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.tileentity.network;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.NovaBootstrapperKt;
import xyz.xenondevs.nova.world.block.tileentity.network.ImmutableNetworkGroupData;
import xyz.xenondevs.nova.world.block.tileentity.network.Network;
import xyz.xenondevs.nova.world.block.tileentity.network.NetworkGroup;
import xyz.xenondevs.nova.world.block.tileentity.network.type.NetworkType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eJ\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eJ\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eJ\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eJ6\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u0010\"\u000e\b\u0000\u0010\u001a*\b\u0012\u0004\u0012\u0002H\u001a0\u00062\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0002J.\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u001b\u0010\u001f\u001a\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u00140 \u00a2\u0006\u0002\b!H\u0082\bJ\b\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u00100\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lxyz/xenondevs/nova/world/block/tileentity/network/NetworkCluster;", "", "uuid", "Ljava/util/UUID;", "networks", "", "Lxyz/xenondevs/nova/world/block/tileentity/network/Network;", "<init>", "(Ljava/util/UUID;Ljava/util/List;)V", "getUuid", "()Ljava/util/UUID;", "getNetworks", "()Ljava/util/List;", "tickOffset", "", "groups", "Lxyz/xenondevs/nova/world/block/tileentity/network/NetworkGroup;", "isValid", "", "preTickSync", "", "tick", "preTick", "postTick", "postTickSync", "createGroup", "T", "type", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/NetworkType;", "updateIsValid", "tickNetworks", "tickFun", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "toString", "", "nova"})
@SourceDebugExtension(value={"SMAP\nNetworkCluster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkCluster.kt\nxyz/xenondevs/nova/world/block/tileentity/network/NetworkCluster\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n56#1,14:140\n56#1,14:154\n56#1,14:168\n56#1,14:182\n56#1,14:196\n1491#2:121\n1516#2,3:122\n1519#2,3:132\n382#3,7:125\n126#4:135\n153#4,3:136\n1#5:139\n*S KotlinDebug\n*F\n+ 1 NetworkCluster.kt\nxyz/xenondevs/nova/world/block/tileentity/network/NetworkCluster\n*L\n29#1:140,14\n32#1:154,14\n33#1:168,14\n34#1:182,14\n35#1:196,14\n16#1:121\n16#1:122,3\n16#1:132,3\n16#1:125,7\n17#1:135\n17#1:136,3\n*E\n"})
public final class NetworkCluster {
    @NotNull
    private final UUID uuid;
    @NotNull
    private final List<Network<?>> networks;
    private final int tickOffset;
    @NotNull
    private final List<NetworkGroup<? extends Network<?>>> groups;
    private volatile boolean isValid;

    /*
     * WARNING - void declaration
     */
    public NetworkCluster(@NotNull UUID uuid, @NotNull List<? extends Network<?>> networks) {
        Comparable comparable;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter(networks, (String)"networks");
        this.uuid = uuid;
        this.networks = networks;
        Iterable iterable = this.networks;
        NetworkCluster networkCluster = this;
        boolean $i$f$groupBy = false;
        void var5_7 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Network it = (Network)element$iv$iv;
            boolean bl = false;
            NetworkType key$iv$iv = it.getType();
            Map map2 = destination$iv$iv;
            NetworkType key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            NetworkType type = (NetworkType)entry.getKey();
            List networks2 = (List)entry.getValue();
            object.add(this.createGroup(type, networks2));
        }
        networkCluster.groups = (List)destination$iv$iv;
        Iterator iterator2 = ((Iterable)this.networks).iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            Network it = (Network)iterator2.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(it.getType().getTickDelay());
            while (iterator2.hasNext()) {
                Network it2 = (Network)iterator2.next();
                $i$a$-maxOfOrNull-NetworkCluster$maxTickDelay$1 = false;
                Comparable comparable3 = Integer.valueOf(it2.getType().getTickDelay());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        int maxTickDelay = n != null ? n : 1;
        this.tickOffset = Random.Default.nextInt(maxTickDelay);
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public final List<Network<?>> getNetworks() {
        return this.networks;
    }

    /*
     * WARNING - void declaration
     */
    public final void preTickSync(int tick2) {
        void this_$iv;
        this.updateIsValid();
        NetworkCluster networkCluster = this;
        int tick$iv = tick2;
        boolean $i$f$tickNetworks = false;
        if (this_$iv.isValid) {
            for (NetworkGroup<Network<?>> group$iv : this_$iv.groups) {
                int tickDelay$iv = group$iv.getType().getTickDelay();
                if ((tick$iv + this_$iv.tickOffset) % tickDelay$iv != 0) continue;
                try {
                    NetworkGroup<Network<?>> p0 = group$iv;
                    boolean bl = false;
                    p0.preTickSync();
                }
                catch (Exception e$iv) {
                    NovaBootstrapperKt.getLOGGER().error("An exception occurred trying to tick " + group$iv + " in cluster " + (NetworkCluster)this_$iv, (Throwable)e$iv);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void preTick(int tick2) {
        void this_$iv;
        NetworkCluster networkCluster = this;
        int tick$iv = tick2;
        boolean $i$f$tickNetworks = false;
        if (this_$iv.isValid) {
            for (NetworkGroup<Network<?>> group$iv : this_$iv.groups) {
                int tickDelay$iv = group$iv.getType().getTickDelay();
                if ((tick$iv + this_$iv.tickOffset) % tickDelay$iv != 0) continue;
                try {
                    NetworkGroup<Network<?>> p0 = group$iv;
                    boolean bl = false;
                    p0.preTick();
                }
                catch (Exception e$iv) {
                    NovaBootstrapperKt.getLOGGER().error("An exception occurred trying to tick " + group$iv + " in cluster " + (NetworkCluster)this_$iv, (Throwable)e$iv);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void tick(int tick2) {
        void this_$iv;
        NetworkCluster networkCluster = this;
        int tick$iv = tick2;
        boolean $i$f$tickNetworks = false;
        if (this_$iv.isValid) {
            for (NetworkGroup<Network<?>> group$iv : this_$iv.groups) {
                int tickDelay$iv = group$iv.getType().getTickDelay();
                if ((tick$iv + this_$iv.tickOffset) % tickDelay$iv != 0) continue;
                try {
                    NetworkGroup<Network<?>> p0 = group$iv;
                    boolean bl = false;
                    p0.tick();
                }
                catch (Exception e$iv) {
                    NovaBootstrapperKt.getLOGGER().error("An exception occurred trying to tick " + group$iv + " in cluster " + (NetworkCluster)this_$iv, (Throwable)e$iv);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void postTick(int tick2) {
        void this_$iv;
        NetworkCluster networkCluster = this;
        int tick$iv = tick2;
        boolean $i$f$tickNetworks = false;
        if (this_$iv.isValid) {
            for (NetworkGroup<Network<?>> group$iv : this_$iv.groups) {
                int tickDelay$iv = group$iv.getType().getTickDelay();
                if ((tick$iv + this_$iv.tickOffset) % tickDelay$iv != 0) continue;
                try {
                    NetworkGroup<Network<?>> p0 = group$iv;
                    boolean bl = false;
                    p0.postTick();
                }
                catch (Exception e$iv) {
                    NovaBootstrapperKt.getLOGGER().error("An exception occurred trying to tick " + group$iv + " in cluster " + (NetworkCluster)this_$iv, (Throwable)e$iv);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void postTickSync(int tick2) {
        void this_$iv;
        NetworkCluster networkCluster = this;
        int tick$iv = tick2;
        boolean $i$f$tickNetworks = false;
        if (this_$iv.isValid) {
            for (NetworkGroup<Network<?>> group$iv : this_$iv.groups) {
                int tickDelay$iv = group$iv.getType().getTickDelay();
                if ((tick$iv + this_$iv.tickOffset) % tickDelay$iv != 0) continue;
                try {
                    NetworkGroup<Network<?>> p0 = group$iv;
                    boolean bl = false;
                    p0.postTickSync();
                }
                catch (Exception e$iv) {
                    NovaBootstrapperKt.getLOGGER().error("An exception occurred trying to tick " + group$iv + " in cluster " + (NetworkCluster)this_$iv, (Throwable)e$iv);
                }
            }
        }
    }

    private final <T extends Network<T>> NetworkGroup<T> createGroup(NetworkType<?> type, List<?> networks) {
        Intrinsics.checkNotNull(type, (String)"null cannot be cast to non-null type xyz.xenondevs.nova.world.block.tileentity.network.type.NetworkType<T of xyz.xenondevs.nova.world.block.tileentity.network.NetworkCluster.createGroup>");
        Intrinsics.checkNotNull(networks, (String)"null cannot be cast to non-null type kotlin.collections.List<T of xyz.xenondevs.nova.world.block.tileentity.network.NetworkCluster.createGroup>");
        ImmutableNetworkGroupData data2 = new ImmutableNetworkGroupData(type, networks);
        return (NetworkGroup)type.getCreateGroup().invoke(data2);
    }

    private final void updateIsValid() {
        for (Network<?> network : this.networks) {
            if (network.isValid()) continue;
            this.isValid = false;
            return;
        }
        this.isValid = true;
    }

    private final void tickNetworks(int tick2, Function1<? super NetworkGroup<?>, Unit> tickFun) {
        boolean $i$f$tickNetworks = false;
        if (!this.isValid) {
            return;
        }
        for (NetworkGroup<Network<?>> group : this.groups) {
            int tickDelay = group.getType().getTickDelay();
            if ((tick2 + this.tickOffset) % tickDelay != 0) continue;
            try {
                tickFun.invoke(group);
            }
            catch (Exception e) {
                NovaBootstrapperKt.getLOGGER().error("An exception occurred trying to tick " + group + " in cluster " + this, (Throwable)e);
            }
        }
    }

    @NotNull
    public String toString() {
        return "NetworkCluster(uuid=" + this.uuid + ", networks=" + this.networks + ")";
    }
}

