/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.tileentity.network;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.commons.collections.CollectionsKt;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.SchedulerUtilsKt;
import xyz.xenondevs.nova.util.particle.ParticleBuilder;
import xyz.xenondevs.nova.util.particle.ParticleBuilderKt;
import xyz.xenondevs.nova.world.block.tileentity.network.Network;
import xyz.xenondevs.nova.world.block.tileentity.network.NetworkCluster;
import xyz.xenondevs.nova.world.block.tileentity.network.NetworkManager;
import xyz.xenondevs.nova.world.block.tileentity.network.node.NetworkBridge;
import xyz.xenondevs.nova.world.block.tileentity.network.node.NetworkEndPoint;
import xyz.xenondevs.nova.world.block.tileentity.network.node.NetworkNode;
import xyz.xenondevs.nova.world.block.tileentity.network.node.NetworkNodeConnection;
import xyz.xenondevs.nova.world.block.tileentity.network.type.NetworkType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J*\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aH\u0002J&\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aH\u0002J.\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aH\u0002R$\u0010\u0004\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lxyz/xenondevs/nova/world/block/tileentity/network/NetworkDebugger;", "", "<init>", "()V", "networkDebuggers", "Ljava/util/HashMap;", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/NetworkType;", "Ljava/util/HashSet;", "Ljava/util/UUID;", "clusterDebuggers", "toggleDebugger", "", "type", "player", "Lorg/bukkit/entity/Player;", "toggleClusterDebugger", "handleTick", "", "tickNetworkDebuggers", "tickClusterDebuggers", "showNetwork", "color", "Ljava/awt/Color;", "network", "Lxyz/xenondevs/nova/world/block/tileentity/network/Network;", "players", "", "showNetworkBridge", "bridge", "Lxyz/xenondevs/nova/world/block/tileentity/network/node/NetworkBridge;", "showNetworkEndPoint", "endPoint", "Lxyz/xenondevs/nova/world/block/tileentity/network/node/NetworkEndPoint;", "face", "Lorg/bukkit/block/BlockFace;", "nova"})
@SourceDebugExtension(value={"SMAP\nNetworkDebugger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkDebugger.kt\nxyz/xenondevs/nova/world/block/tileentity/network/NetworkDebugger\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n382#2,7:114\n1617#3,9:121\n1869#3:130\n1870#3:132\n1626#3:133\n1617#3,9:134\n1869#3:143\n1870#3:145\n1626#3:146\n1869#3,2:147\n1#4:131\n1#4:144\n*S KotlinDebug\n*F\n+ 1 NetworkDebugger.kt\nxyz/xenondevs/nova/world/block/tileentity/network/NetworkDebugger\n*L\n30#1:114,7\n64#1:121,9\n64#1:130\n64#1:132\n64#1:133\n76#1:134,9\n76#1:143\n76#1:145\n76#1:146\n96#1:147,2\n64#1:131\n76#1:144\n*E\n"})
public final class NetworkDebugger {
    @NotNull
    public static final NetworkDebugger INSTANCE = new NetworkDebugger();
    @NotNull
    private static final HashMap<NetworkType<?>, HashSet<UUID>> networkDebuggers = new HashMap();
    @NotNull
    private static final HashSet<UUID> clusterDebuggers = new HashSet();

    private NetworkDebugger() {
    }

    /*
     * WARNING - void declaration
     */
    public final boolean toggleDebugger(@NotNull NetworkType<?> type, @NotNull Player player) {
        HashSet typeDebuggers;
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Map map2 = networkDebuggers;
        NetworkType<?> key$iv = type;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            HashSet answer$iv = new HashSet();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if ((typeDebuggers = (HashSet)object).contains(player.getUniqueId())) {
            ((Collection)typeDebuggers).remove(player.getUniqueId());
            if (typeDebuggers.isEmpty()) {
                ((Map)networkDebuggers).remove(type);
            }
            return false;
        }
        ((Collection)typeDebuggers).add(player.getUniqueId());
        return true;
    }

    public final boolean toggleClusterDebugger(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (clusterDebuggers.contains(player.getUniqueId())) {
            ((Collection)clusterDebuggers).remove(player.getUniqueId());
            return false;
        }
        ((Collection)clusterDebuggers).add(player.getUniqueId());
        return true;
    }

    private final void handleTick() {
        this.tickNetworkDebuggers();
        this.tickClusterDebuggers();
    }

    /*
     * WARNING - void declaration
     */
    private final void tickNetworkDebuggers() {
        if (networkDebuggers.isEmpty()) {
            return;
        }
        for (Network network : NetworkManager.INSTANCE.getNetworks()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            HashSet<UUID> hashSet = networkDebuggers.get(network.getType());
            if (hashSet == null) continue;
            Iterable iterable = hashSet;
            boolean $i$f$mapNotNull = false;
            void var7_7 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Player it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                UUID p0 = (UUID)element$iv$iv;
                boolean bl2 = false;
                if (Bukkit.getPlayer((UUID)p0) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            iterable = (List)CollectionsKt.takeUnlessEmpty((Collection)((List)destination$iv$iv));
            if (iterable == null) continue;
            Iterable players = iterable;
            this.showNetwork(new Color(network.getUuid().hashCode()), network, (List<? extends Player>)players);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void tickClusterDebuggers() {
        void $this$mapNotNullTo$iv$iv;
        if (clusterDebuggers.isEmpty()) {
            return;
        }
        Iterable $this$mapNotNull$iv = clusterDebuggers;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Player it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UUID p0 = (UUID)element$iv$iv;
            boolean bl2 = false;
            if (Bukkit.getPlayer((UUID)p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List players = (List)destination$iv$iv;
        if (players.isEmpty()) {
            return;
        }
        for (NetworkCluster cluster : NetworkManager.INSTANCE.getClusters()) {
            Color color = new Color(cluster.getUuid().hashCode());
            for (Network<?> network : cluster.getNetworks()) {
                this.showNetwork(color, network, players);
            }
        }
    }

    private final void showNetwork(Color color, Network<?> network, List<? extends Player> players) {
        for (NetworkNodeConnection networkNodeConnection : network.getNodes().values()) {
            NetworkNode node2 = networkNodeConnection.component1();
            Set<BlockFace> faces = networkNodeConnection.component2();
            List<Player> receivers = LocationUtilsKt.filterInRange((Iterable<? extends Player>)players, node2.getPos().getLocation(), 64.0);
            if (receivers.isEmpty()) continue;
            NetworkNode networkNode = node2;
            if (networkNode instanceof NetworkBridge) {
                this.showNetworkBridge((NetworkBridge)node2, color, receivers);
                continue;
            }
            if (networkNode instanceof NetworkEndPoint) {
                Iterable $this$forEach$iv = faces;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BlockFace it = (BlockFace)element$iv;
                    boolean bl = false;
                    INSTANCE.showNetworkEndPoint((NetworkEndPoint)node2, it, color, receivers);
                }
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void showNetworkBridge(NetworkBridge bridge, Color color, List<? extends Player> players) {
        Location location = bridge.getPos().getLocation().add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
        Location particleLocation = location;
        ParticleType particleType = ParticleTypes.DUST;
        Intrinsics.checkNotNullExpressionValue((Object)particleType, (String)"DUST");
        NMSUtilsKt.sendTo((Packet)ParticleBuilderKt.particle(particleType, particleLocation, arg_0 -> NetworkDebugger.showNetworkBridge$lambda$0(color, arg_0)), (Iterable<? extends Player>)players);
    }

    private final void showNetworkEndPoint(NetworkEndPoint endPoint, BlockFace face, Color color, List<? extends Player> players) {
        Location location = endPoint.getPos().getLocation().add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"add(...)");
        Location particleLocation = LocationUtilsKt.advance(location, face, 0.5);
        ParticleType particleType = ParticleTypes.DUST;
        Intrinsics.checkNotNullExpressionValue((Object)particleType, (String)"DUST");
        NMSUtilsKt.sendTo((Packet)ParticleBuilderKt.particle(particleType, particleLocation, arg_0 -> NetworkDebugger.showNetworkEndPoint$lambda$0(color, arg_0)), (Iterable<? extends Player>)players);
    }

    private static final Unit showNetworkBridge$lambda$0(Color $color, ParticleBuilder $this$particle) {
        Intrinsics.checkNotNullParameter((Object)$this$particle, (String)"$this$particle");
        ParticleBuilderKt.color($this$particle, $color);
        return Unit.INSTANCE;
    }

    private static final Unit showNetworkEndPoint$lambda$0(Color $color, ParticleBuilder $this$particle) {
        Intrinsics.checkNotNullParameter((Object)$this$particle, (String)"$this$particle");
        ParticleBuilderKt.color($this$particle, $color);
        return Unit.INSTANCE;
    }

    static {
        SchedulerUtilsKt.runTaskTimer(0L, 1L, (Function0<Unit>)((Function0)new Function0<Unit>((Object)INSTANCE){

            public final void invoke() {
                ((NetworkDebugger)this.receiver).handleTick();
            }
        }));
    }
}

