/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.tileentity.network.type.item.inventory.vanilla;

import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.block.tileentity.network.type.item.inventory.NetworkedInventory;
import xyz.xenondevs.nova.world.block.tileentity.network.type.item.inventory.vanilla.ItemStackContainer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\u001b\u0010\u001b\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001f\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lxyz/xenondevs/nova/world/block/tileentity/network/type/item/inventory/vanilla/NetworkedNMSInventory;", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/item/inventory/NetworkedInventory;", "container", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/item/inventory/vanilla/ItemStackContainer;", "<init>", "(Lxyz/xenondevs/nova/world/block/tileentity/network/type/item/inventory/vanilla/ItemStackContainer;)V", "getContainer", "()Lxyz/xenondevs/nova/world/block/tileentity/network/type/item/inventory/vanilla/ItemStackContainer;", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "size", "", "getSize", "()I", "add", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "amount", "canTake", "", "slot", "take", "", "isFull", "isEmpty", "copyContents", "destination", "", "([Lorg/bukkit/inventory/ItemStack;)V", "equals", "other", "", "hashCode", "nova"})
@SourceDebugExtension(value={"SMAP\nNetworkedNMSInventory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkedNMSInventory.kt\nxyz/xenondevs/nova/world/block/tileentity/network/type/item/inventory/vanilla/NetworkedNMSInventory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1740#2,3:92\n*S KotlinDebug\n*F\n+ 1 NetworkedNMSInventory.kt\nxyz/xenondevs/nova/world/block/tileentity/network/type/item/inventory/vanilla/NetworkedNMSInventory\n*L\n74#1:92,3\n*E\n"})
public class NetworkedNMSInventory
implements NetworkedInventory {
    @NotNull
    private final ItemStackContainer container;
    @NotNull
    private final UUID uuid;
    private final int size;

    public NetworkedNMSInventory(@NotNull ItemStackContainer container2) {
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        this.container = container2;
        this.uuid = new UUID(0L, 0L);
        this.size = this.container.getSize();
    }

    @NotNull
    protected final ItemStackContainer getContainer() {
        return this.container;
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int add(@NotNull ItemStack itemStack, int amount) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        int maxStackSize = itemStack.getMaxStackSize();
        int remaining = amount;
        for (net.minecraft.world.item.ItemStack current : this.container) {
            if (remaining <= 0) break;
            if (!net.minecraft.world.item.ItemStack.isSameItemSameComponents((net.minecraft.world.item.ItemStack)NMSUtilsKt.unwrap(itemStack), (net.minecraft.world.item.ItemStack)current)) continue;
            int transfer = Math.min(remaining, maxStackSize - current.getCount());
            current.setCount(current.getCount() + transfer);
            remaining -= transfer;
        }
        Iterator iterator = ((Iterable)this.container).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int slot = n++;
            net.minecraft.world.item.ItemStack current = (net.minecraft.world.item.ItemStack)iterator.next();
            if (remaining <= 0) break;
            if (!current.isEmpty()) continue;
            int transfer = Math.min(remaining, maxStackSize);
            net.minecraft.world.item.ItemStack itemStack2 = NMSUtilsKt.unwrap(itemStack).copyWithCount(transfer);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"copyWithCount(...)");
            this.container.set(slot, itemStack2);
            remaining -= transfer;
        }
        return remaining;
    }

    @Override
    public boolean canTake(int slot, int amount) {
        return true;
    }

    @Override
    public void take(int slot, int amount) {
        net.minecraft.world.item.ItemStack current = this.container.get(slot);
        if (current.isEmpty()) {
            return;
        }
        int transfer = Math.min(amount, current.getCount());
        current.setCount(current.getCount() - transfer);
    }

    @Override
    public boolean isFull() {
        for (net.minecraft.world.item.ItemStack item : this.container) {
            if (!item.isEmpty() && item.getCount() >= item.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.container;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    net.minecraft.world.item.ItemStack p0 = (net.minecraft.world.item.ItemStack)element$iv;
                    boolean bl2 = false;
                    if (p0.isEmpty()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void copyContents(@NotNull ItemStack[] destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Iterator iterator = ((Iterable)this.container).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            net.minecraft.world.item.ItemStack item = (net.minecraft.world.item.ItemStack)iterator.next();
            destination[index] = item.copy().asBukkitMirror();
        }
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof NetworkedNMSInventory && Intrinsics.areEqual((Object)this.container, (Object)((NetworkedNMSInventory)other).container);
    }

    public int hashCode() {
        return this.container.hashCode();
    }
}

