/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.format.chunk.container;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.cbf.io.ByteReader;
import xyz.xenondevs.cbf.io.ByteWriter;
import xyz.xenondevs.nova.world.format.IdResolver;
import xyz.xenondevs.nova.world.format.chunk.container.PalletizedSectionDataContainer;
import xyz.xenondevs.nova.world.format.chunk.data.CompactIntArray;
import xyz.xenondevs.nova.world.format.chunk.palette.LinearPalette;
import xyz.xenondevs.nova.world.format.chunk.palette.Palette;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0017\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001f\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010\u001f\u001a\u0004\u0018\u00018\u00002\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0017H\u0096\u0002\u00a2\u0006\u0002\u0010#J2\u0010$\u001a\u0004\u0018\u00018\u00002\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00172\b\u0010\u0016\u001a\u0004\u0018\u00018\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010%J\u0017\u0010&\u001a\u00020\u001c2\b\u0010\u0016\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010'J.\u0010(\u001a\u00020\u001c2$\u0010)\u001a \u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0*H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u0017H\u0014J\b\u00100\u001a\u00020\u0017H\u0014R \u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00061"}, d2={"Lxyz/xenondevs/nova/world/format/chunk/container/ArraySectionDataContainer;", "T", "Lxyz/xenondevs/nova/world/format/chunk/container/PalletizedSectionDataContainer;", "idResolver", "Lxyz/xenondevs/nova/world/format/IdResolver;", "<init>", "(Lxyz/xenondevs/nova/world/format/IdResolver;)V", "reader", "Lxyz/xenondevs/cbf/io/ByteReader;", "(Lxyz/xenondevs/nova/world/format/IdResolver;Lxyz/xenondevs/cbf/io/ByteReader;)V", "palette", "Lxyz/xenondevs/nova/world/format/chunk/palette/Palette;", "getPalette", "()Lxyz/xenondevs/nova/world/format/chunk/palette/Palette;", "setPalette", "(Lxyz/xenondevs/nova/world/format/chunk/palette/Palette;)V", "data", "Lxyz/xenondevs/nova/world/format/chunk/data/CompactIntArray;", "getData", "()Lxyz/xenondevs/nova/world/format/chunk/data/CompactIntArray;", "setData", "(Lxyz/xenondevs/nova/world/format/chunk/data/CompactIntArray;)V", "value", "", "nonEmptyBlockCount", "getNonEmptyBlockCount", "()I", "write", "", "writer", "Lxyz/xenondevs/cbf/io/ByteWriter;", "get", "x", "y", "z", "(III)Ljava/lang/Object;", "set", "(IIILjava/lang/Object;)Ljava/lang/Object;", "fill", "(Ljava/lang/Object;)V", "forEachNonEmpty", "action", "Lkotlin/Function4;", "isMonotone", "", "resizeData", "oldBitsPerEntry", "newBitsPerEntry", "determineBitsPerEntry", "nova"})
public final class ArraySectionDataContainer<T>
extends PalletizedSectionDataContainer<T> {
    @NotNull
    private Palette<T> palette;
    @NotNull
    private CompactIntArray data;
    private int nonEmptyBlockCount;

    @Override
    @NotNull
    protected Palette<T> getPalette() {
        return this.palette;
    }

    @Override
    protected void setPalette(@NotNull Palette<T> palette) {
        Intrinsics.checkNotNullParameter(palette, (String)"<set-?>");
        this.palette = palette;
    }

    @Override
    @NotNull
    protected CompactIntArray getData() {
        return this.data;
    }

    protected void setData(@NotNull CompactIntArray compactIntArray) {
        Intrinsics.checkNotNullParameter((Object)compactIntArray, (String)"<set-?>");
        this.data = compactIntArray;
    }

    @Override
    public int getNonEmptyBlockCount() {
        return this.nonEmptyBlockCount;
    }

    public ArraySectionDataContainer(@NotNull IdResolver<T> idResolver) {
        Intrinsics.checkNotNullParameter(idResolver, (String)"idResolver");
        super(idResolver, null);
        this.setPalette(new LinearPalette<T>(idResolver));
        this.setBitsPerEntry(this.determineBitsPerEntry());
        this.setData(CompactIntArray.Companion.create(4096, this.getBitsPerEntry()));
    }

    public ArraySectionDataContainer(@NotNull IdResolver<T> idResolver, @NotNull ByteReader reader) {
        Intrinsics.checkNotNullParameter(idResolver, (String)"idResolver");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        super(idResolver, null);
        this.setPalette(Palette.Companion.read(idResolver, reader));
        this.setBitsPerEntry(this.determineBitsPerEntry());
        this.setData(CompactIntArray.Companion.fromByteArray(4096, this.getBitsPerEntry(), reader.readBytes(4096 * this.getBitsPerEntry() / 8)));
        this.nonEmptyBlockCount = reader.readVarInt();
    }

    @Override
    public void write(@NotNull ByteWriter writer2) {
        Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
        this.remakePaletteResizeData();
        Palette.Companion.write(this.getPalette(), writer2);
        this.getData().write(writer2);
        writer2.writeVarInt(this.getNonEmptyBlockCount());
    }

    @Override
    @Nullable
    public T get(int x, int y, int z) {
        return this.getPalette().getValue(this.getData().get(this.pack(x, y, z)));
    }

    @Override
    @Nullable
    public T set(int x, int y, int z, @Nullable T value) {
        T previous = this.get(x, y, z);
        if (Intrinsics.areEqual(previous, value)) {
            return previous;
        }
        if (previous == null) {
            var6_6 = this.getNonEmptyBlockCount();
            this.nonEmptyBlockCount = var6_6 + 1;
        } else if (value == null) {
            var6_6 = this.getNonEmptyBlockCount();
            this.nonEmptyBlockCount = var6_6 + -1;
        }
        int id = this.toPalletizedId(value);
        this.getData().set(this.pack(x, y, z), id);
        return previous;
    }

    @Override
    public void fill(@Nullable T value) {
        this.nonEmptyBlockCount = value == null ? 0 : 4096;
        int id = this.toPalletizedId(value);
        this.getData().fill(id);
    }

    @Override
    public void forEachNonEmpty(@NotNull Function4<? super Integer, ? super Integer, ? super Integer, ? super T, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    T value = this.get(x, y, z);
                    if (value == null) continue;
                    action.invoke((Object)x, (Object)y, (Object)z, value);
                }
            }
        }
    }

    @Override
    public boolean isMonotone() {
        if (this.getNonEmptyBlockCount() == 0) {
            return true;
        }
        if (this.getNonEmptyBlockCount() != 4096) {
            return false;
        }
        int prev = this.getData().get(0);
        for (int i2 = 1; i2 < 4096; ++i2) {
            int now = this.getData().get(i2);
            if (now != prev) {
                return false;
            }
            prev = now;
        }
        return true;
    }

    @Override
    protected void resizeData(int oldBitsPerEntry, int newBitsPerEntry) {
        CompactIntArray oldData = this.getData();
        CompactIntArray newData = CompactIntArray.Companion.create(4096, newBitsPerEntry);
        for (int packedPos = 0; packedPos < 4096; ++packedPos) {
            newData.set(packedPos, oldData.get(packedPos));
        }
        this.setData(newData);
    }

    @Override
    protected int determineBitsPerEntry() {
        int n;
        int size = this.getPalette().getSize();
        if (size <= 3) {
            n = 2;
        } else if (size <= 15) {
            n = 4;
        } else if (size <= 255) {
            n = 8;
        } else if (size <= 65535) {
            n = 16;
        } else {
            throw new UnsupportedOperationException();
        }
        return n;
    }
}

