/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.format.chunk.container;

import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.shorts.Short2ByteMap;
import it.unimi.dsi.fastutil.shorts.Short2ShortMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.cbf.io.ByteReader;
import xyz.xenondevs.cbf.io.ByteWriter;
import xyz.xenondevs.nova.world.format.IdResolver;
import xyz.xenondevs.nova.world.format.chunk.container.PalletizedSectionDataContainer;
import xyz.xenondevs.nova.world.format.chunk.data.MappedCompactIntStorage;
import xyz.xenondevs.nova.world.format.chunk.data.Short2ByteMapCompactIntStorage;
import xyz.xenondevs.nova.world.format.chunk.data.Short2ShortMapCompactIntStorage;
import xyz.xenondevs.nova.world.format.chunk.palette.LinearPalette;
import xyz.xenondevs.nova.world.format.chunk.palette.Palette;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0017\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001f\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J(\u0010\u001e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0017H\u0096\u0002\u00a2\u0006\u0002\u0010\"J2\u0010#\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00172\b\u0010$\u001a\u0004\u0018\u00018\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010%J\u0017\u0010&\u001a\u00020\u001b2\b\u0010$\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010'J.\u0010(\u001a\u00020\u001b2$\u0010)\u001a \u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001b0*H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0018\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u0017H\u0014J\b\u00100\u001a\u00020\u0017H\u0014R \u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00061"}, d2={"Lxyz/xenondevs/nova/world/format/chunk/container/MapSectionDataContainer;", "T", "Lxyz/xenondevs/nova/world/format/chunk/container/PalletizedSectionDataContainer;", "idResolver", "Lxyz/xenondevs/nova/world/format/IdResolver;", "<init>", "(Lxyz/xenondevs/nova/world/format/IdResolver;)V", "reader", "Lxyz/xenondevs/cbf/io/ByteReader;", "(Lxyz/xenondevs/nova/world/format/IdResolver;Lxyz/xenondevs/cbf/io/ByteReader;)V", "palette", "Lxyz/xenondevs/nova/world/format/chunk/palette/Palette;", "getPalette", "()Lxyz/xenondevs/nova/world/format/chunk/palette/Palette;", "setPalette", "(Lxyz/xenondevs/nova/world/format/chunk/palette/Palette;)V", "data", "Lxyz/xenondevs/nova/world/format/chunk/data/MappedCompactIntStorage;", "getData", "()Lxyz/xenondevs/nova/world/format/chunk/data/MappedCompactIntStorage;", "setData", "(Lxyz/xenondevs/nova/world/format/chunk/data/MappedCompactIntStorage;)V", "nonEmptyBlockCount", "", "getNonEmptyBlockCount", "()I", "write", "", "writer", "Lxyz/xenondevs/cbf/io/ByteWriter;", "get", "x", "y", "z", "(III)Ljava/lang/Object;", "set", "value", "(IIILjava/lang/Object;)Ljava/lang/Object;", "fill", "(Ljava/lang/Object;)V", "forEachNonEmpty", "action", "Lkotlin/Function4;", "isMonotone", "", "resizeData", "oldBitsPerEntry", "newBitsPerEntry", "determineBitsPerEntry", "nova"})
@SourceDebugExtension(value={"SMAP\nMapSectionDataContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapSectionDataContainer.kt\nxyz/xenondevs/nova/world/format/chunk/container/MapSectionDataContainer\n+ 2 CompactIntMapWrappers.kt\nxyz/xenondevs/nova/world/format/chunk/data/CompactIntMapWrappersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n10#2,2:96\n12#2,2:100\n10#2,2:102\n12#2,2:106\n10#2,2:108\n12#2,2:112\n1869#3,2:98\n1869#3,2:104\n1869#3,2:110\n*S KotlinDebug\n*F\n+ 1 MapSectionDataContainer.kt\nxyz/xenondevs/nova/world/format/chunk/container/MapSectionDataContainer\n*L\n62#1:96,2\n62#1:100,2\n72#1:102,2\n72#1:106,2\n85#1:108,2\n85#1:112,2\n62#1:98,2\n72#1:104,2\n85#1:110,2\n*E\n"})
public final class MapSectionDataContainer<T>
extends PalletizedSectionDataContainer<T> {
    @NotNull
    private Palette<T> palette;
    @NotNull
    private MappedCompactIntStorage data;

    @Override
    @NotNull
    protected Palette<T> getPalette() {
        return this.palette;
    }

    @Override
    protected void setPalette(@NotNull Palette<T> palette) {
        Intrinsics.checkNotNullParameter(palette, (String)"<set-?>");
        this.palette = palette;
    }

    @Override
    @NotNull
    protected MappedCompactIntStorage getData() {
        return this.data;
    }

    protected void setData(@NotNull MappedCompactIntStorage mappedCompactIntStorage) {
        Intrinsics.checkNotNullParameter((Object)mappedCompactIntStorage, (String)"<set-?>");
        this.data = mappedCompactIntStorage;
    }

    @Override
    public int getNonEmptyBlockCount() {
        return this.getData().getMap().size();
    }

    public MapSectionDataContainer(@NotNull IdResolver<T> idResolver) {
        Intrinsics.checkNotNullParameter(idResolver, (String)"idResolver");
        super(idResolver, null);
        this.setPalette(new LinearPalette<T>(idResolver));
        this.setBitsPerEntry(this.determineBitsPerEntry());
        this.setData(MappedCompactIntStorage.Companion.create(this.getBitsPerEntry()));
    }

    public MapSectionDataContainer(@NotNull IdResolver<T> idResolver, @NotNull ByteReader reader) {
        Intrinsics.checkNotNullParameter(idResolver, (String)"idResolver");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        super(idResolver, null);
        this.setPalette(Palette.Companion.read(idResolver, reader));
        this.setBitsPerEntry(this.determineBitsPerEntry());
        this.setData(MappedCompactIntStorage.Companion.read(reader, this.getBitsPerEntry()));
    }

    @Override
    public void write(@NotNull ByteWriter writer2) {
        Intrinsics.checkNotNullParameter((Object)writer2, (String)"writer");
        this.remakePaletteResizeData();
        Palette.Companion.write(this.getPalette(), writer2);
        this.getData().write(writer2);
    }

    @Override
    @Nullable
    public T get(int x, int y, int z) {
        return this.getPalette().getValue(this.getData().get(this.pack(x, y, z)));
    }

    @Override
    @Nullable
    public T set(int x, int y, int z, @Nullable T value) {
        T previous = this.get(x, y, z);
        if (Intrinsics.areEqual(previous, value)) {
            return previous;
        }
        int id = this.toPalletizedId(value);
        this.getData().set(this.pack(x, y, z), id);
        return previous;
    }

    @Override
    public void fill(@Nullable T value) {
        if (value != null) {
            int id = this.toPalletizedId(value);
            for (int i2 = 0; i2 < 4096; ++i2) {
                this.getData().set(i2, id);
            }
        } else {
            this.getData().clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void forEachNonEmpty(@NotNull Function4<? super Integer, ? super Integer, ? super Integer, ? super T, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        MappedCompactIntStorage $this$forEach$iv = this.getData();
        boolean $i$f$forEach = false;
        MappedCompactIntStorage mappedCompactIntStorage = $this$forEach$iv;
        if (mappedCompactIntStorage instanceof Short2ByteMapCompactIntStorage) {
            ObjectSet objectSet = ((Short2ByteMapCompactIntStorage)$this$forEach$iv).getMap().short2ByteEntrySet();
            Intrinsics.checkNotNullExpressionValue((Object)objectSet, (String)"short2ByteEntrySet(...)");
            Iterable $this$forEach$iv$iv = (Iterable)objectSet;
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                void value;
                Short2ByteMap.Entry it$iv = (Short2ByteMap.Entry)element$iv$iv;
                boolean bl = false;
                byte by = it$iv.getByteValue();
                short packedPos = it$iv.getShortKey();
                boolean bl2 = false;
                Integer n = this.unpackX(packedPos);
                Integer n2 = this.unpackY(packedPos);
                Integer n3 = this.unpackZ(packedPos);
                T t = this.getPalette().getValue((int)value);
                Intrinsics.checkNotNull(t);
                action.invoke((Object)n, (Object)n2, (Object)n3, t);
            }
        } else if (mappedCompactIntStorage instanceof Short2ShortMapCompactIntStorage) {
            ObjectSet objectSet = ((Short2ShortMapCompactIntStorage)$this$forEach$iv).getMap().short2ShortEntrySet();
            Intrinsics.checkNotNullExpressionValue((Object)objectSet, (String)"short2ShortEntrySet(...)");
            Iterable $this$forEach$iv$iv = (Iterable)objectSet;
            boolean $i$f$forEach3 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Short2ShortMap.Entry it$iv = (Short2ShortMap.Entry)element$iv$iv;
                boolean bl = false;
                short value = it$iv.getShortValue();
                short packedPos = it$iv.getShortKey();
                boolean bl3 = false;
                Integer n = this.unpackX(packedPos);
                Integer n4 = this.unpackY(packedPos);
                Integer n5 = this.unpackZ(packedPos);
                T t = this.getPalette().getValue(value);
                Intrinsics.checkNotNull(t);
                action.invoke((Object)n, (Object)n4, (Object)n5, t);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isMonotone() {
        if (this.getNonEmptyBlockCount() == 0) {
            return true;
        }
        short prev = 0;
        MappedCompactIntStorage $this$forEach$iv = this.getData();
        boolean $i$f$forEach = false;
        MappedCompactIntStorage mappedCompactIntStorage = $this$forEach$iv;
        if (mappedCompactIntStorage instanceof Short2ByteMapCompactIntStorage) {
            ObjectSet objectSet = ((Short2ByteMapCompactIntStorage)$this$forEach$iv).getMap().short2ByteEntrySet();
            Intrinsics.checkNotNullExpressionValue((Object)objectSet, (String)"short2ByteEntrySet(...)");
            Iterable $this$forEach$iv$iv = (Iterable)objectSet;
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                void value;
                Short2ByteMap.Entry it$iv = (Short2ByteMap.Entry)element$iv$iv;
                boolean bl = false;
                it$iv.getShortKey();
                byte by = it$iv.getByteValue();
                boolean bl2 = false;
                if (prev == 0) {
                    prev = value;
                    continue;
                }
                if (prev == value) continue;
                return false;
            }
        } else if (mappedCompactIntStorage instanceof Short2ShortMapCompactIntStorage) {
            ObjectSet objectSet = ((Short2ShortMapCompactIntStorage)$this$forEach$iv).getMap().short2ShortEntrySet();
            Intrinsics.checkNotNullExpressionValue((Object)objectSet, (String)"short2ShortEntrySet(...)");
            Iterable $this$forEach$iv$iv = (Iterable)objectSet;
            boolean $i$f$forEach3 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Short2ShortMap.Entry it$iv = (Short2ShortMap.Entry)element$iv$iv;
                boolean bl = false;
                it$iv.getShortKey();
                short value = it$iv.getShortValue();
                boolean bl3 = false;
                if (prev == 0) {
                    prev = value;
                    continue;
                }
                if (prev == value) continue;
                return false;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return this.getNonEmptyBlockCount() == 4096;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void resizeData(int oldBitsPerEntry, int newBitsPerEntry) {
        MappedCompactIntStorage newMap = MappedCompactIntStorage.Companion.create(newBitsPerEntry);
        MappedCompactIntStorage $this$forEach$iv = this.getData();
        boolean $i$f$forEach = false;
        MappedCompactIntStorage mappedCompactIntStorage = $this$forEach$iv;
        if (mappedCompactIntStorage instanceof Short2ByteMapCompactIntStorage) {
            ObjectSet objectSet = ((Short2ByteMapCompactIntStorage)$this$forEach$iv).getMap().short2ByteEntrySet();
            Intrinsics.checkNotNullExpressionValue((Object)objectSet, (String)"short2ByteEntrySet(...)");
            Iterable $this$forEach$iv$iv = (Iterable)objectSet;
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                void value;
                Short2ByteMap.Entry it$iv = (Short2ByteMap.Entry)element$iv$iv;
                boolean bl = false;
                byte by = it$iv.getByteValue();
                short packedPos = it$iv.getShortKey();
                boolean bl2 = false;
                newMap.set(packedPos, (int)value);
            }
        } else if (mappedCompactIntStorage instanceof Short2ShortMapCompactIntStorage) {
            ObjectSet objectSet = ((Short2ShortMapCompactIntStorage)$this$forEach$iv).getMap().short2ShortEntrySet();
            Intrinsics.checkNotNullExpressionValue((Object)objectSet, (String)"short2ShortEntrySet(...)");
            Iterable $this$forEach$iv$iv = (Iterable)objectSet;
            boolean $i$f$forEach3 = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Short2ShortMap.Entry it$iv = (Short2ShortMap.Entry)element$iv$iv;
                boolean bl = false;
                short value = it$iv.getShortValue();
                short packedPos = it$iv.getShortKey();
                boolean bl3 = false;
                newMap.set(packedPos, value);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.setData(newMap);
    }

    @Override
    protected int determineBitsPerEntry() {
        int n;
        if (this.getPalette().getSize() < 255) {
            n = 8;
        } else if (this.getPalette().getSize() < 65535) {
            n = 16;
        } else {
            throw new UnsupportedOperationException();
        }
        return n;
    }
}

