/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.generation.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.key.Key;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.FixedPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.HeightmapPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceRelativeThresholdFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.NovaBootstrapperKt;
import xyz.xenondevs.nova.registry.RegistryElementBuilder;
import xyz.xenondevs.nova.registry.RegistryElementBuilderDsl;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.generation.ExperimentalWorldGen;

@ExperimentalWorldGen
@RegistryElementBuilderDsl
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\u000f\u001a\u00020\u00142\u0014\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r0\u0015J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0013J\u001f\u0010\u0011\u001a\u00020\u00142\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0017\"\u00020\u0013\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010\u0011\u001a\u00020\u00142\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019J\u0006\u0010\u001a\u001a\u00020\u0014J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020 J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020 H\u0007J&\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u001fJ\u001e\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u001fJ\u000e\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*J\u0016\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-J\u0016\u0010/\u001a\u00020\u00142\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-J\u0006\u00100\u001a\u00020\u0014J\u000e\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u00020\u0014J\u0006\u00105\u001a\u00020\u0014J\u0006\u00106\u001a\u00020\u0014J\u0006\u00107\u001a\u00020\u0014J\u0006\u00108\u001a\u00020\u0014J\u001e\u00109\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020<J\u001e\u0010>\u001a\u00020\u00142\u0006\u0010?\u001a\u00020<2\u0006\u0010@\u001a\u00020\u001f2\u0006\u0010A\u001a\u00020\u001fJ\u0016\u0010B\u001a\u00020\u00142\u0006\u0010C\u001a\u00020 2\u0006\u0010D\u001a\u00020 J\u0016\u0010B\u001a\u00020\u00142\u0006\u0010C\u001a\u00020\u001f2\u0006\u0010D\u001a\u00020\u001fJ\u000e\u0010E\u001a\u00020\u00142\u0006\u0010D\u001a\u00020 J\u000e\u0010E\u001a\u00020\u00142\u0006\u0010D\u001a\u00020\u001fJ\u000e\u0010F\u001a\u00020\u00142\u0006\u0010C\u001a\u00020 J\u000e\u0010F\u001a\u00020\u00142\u0006\u0010C\u001a\u00020\u001fJ\u000e\u0010G\u001a\u00020\u00142\u0006\u0010H\u001a\u00020\u001fJ\u001e\u0010I\u001a\u00020\u00142\u0006\u00102\u001a\u0002032\u0006\u0010,\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u001fJ\u000e\u0010J\u001a\u00020\u00142\u0006\u0010K\u001a\u00020\u001fJ\u001f\u0010L\u001a\u00020\u00142\u0012\u0010M\u001a\n\u0012\u0006\b\u0001\u0012\u00020N0\u0017\"\u00020N\u00a2\u0006\u0002\u0010OJ\u0014\u0010L\u001a\u00020\u00142\f\u0010M\u001a\b\u0012\u0004\u0012\u00020N0PJ\b\u0010Q\u001a\u00020\u0002H\u0014R,\u0010\u000b\u001a \u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \u000e*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lxyz/xenondevs/nova/world/generation/builder/PlacedFeatureBuilder;", "Lxyz/xenondevs/nova/registry/RegistryElementBuilder;", "Lnet/minecraft/world/level/levelgen/placement/PlacedFeature;", "id", "Lnet/kyori/adventure/key/Key;", "registry", "Lnet/minecraft/core/WritableRegistry;", "lookup", "Lnet/minecraft/resources/RegistryOps$RegistryInfoLookup;", "<init>", "(Lnet/kyori/adventure/key/Key;Lnet/minecraft/core/WritableRegistry;Lnet/minecraft/resources/RegistryOps$RegistryInfoLookup;)V", "configuredFeatureRegistry", "Lnet/minecraft/core/HolderGetter;", "Lnet/minecraft/world/level/levelgen/feature/ConfiguredFeature;", "kotlin.jvm.PlatformType", "configuredFeature", "Lnet/minecraft/core/Holder;", "modifiers", "", "Lnet/minecraft/world/level/levelgen/placement/PlacementModifier;", "", "Lnet/minecraft/resources/ResourceKey;", "modifier", "", "([Lnet/minecraft/world/level/levelgen/placement/PlacementModifier;)V", "", "biomeFilter", "blockPredicateFilter", "predicate", "Lnet/minecraft/world/level/levelgen/blockpredicates/BlockPredicate;", "count", "", "Lnet/minecraft/util/valueproviders/IntProvider;", "countOnEveryLayer", "environmentScan", "direction", "Lnet/minecraft/core/Direction;", "target", "continuePredicate", "maxSteps", "heightRange", "provider", "Lnet/minecraft/world/level/levelgen/heightproviders/HeightProvider;", "heightRangeUniform", "min", "Lnet/minecraft/world/level/levelgen/VerticalAnchor;", "max", "heightRangeTriangle", "inYWorldBounds", "heightMap", "heightmap", "Lnet/minecraft/world/level/levelgen/Heightmap$Types;", "moveToMotionBlocking", "moveToWorldSurface", "moveToOceanFloor", "moveToTopSolid", "inSquareSpread", "noiseBasedCount", "noiseToCountRatio", "noiseFactor", "", "noiseOffset", "noiseThresholdCount", "noiseLevel", "belowNoise", "aboveNoise", "randomOffset", "xzSpread", "ySpread", "randomVerticalOffset", "randomHorizontalOffset", "rarityFilter", "onAverageOnceEvery", "surfaceRelativeThresholdFilter", "surfaceWaterDepthFilter", "maxDepth", "fixedPlacement", "positions", "Lnet/minecraft/core/BlockPos;", "([Lnet/minecraft/core/BlockPos;)V", "", "build", "nova"})
@SourceDebugExtension(value={"SMAP\nPlacedFeatureBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlacedFeatureBuilder.kt\nxyz/xenondevs/nova/world/generation/builder/PlacedFeatureBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,400:1\n1#2:401\n*E\n"})
public final class PlacedFeatureBuilder
extends RegistryElementBuilder<PlacedFeature> {
    @NotNull
    private final HolderGetter<ConfiguredFeature<?, ?>> configuredFeatureRegistry;
    @Nullable
    private Holder<ConfiguredFeature<?, ?>> configuredFeature;
    @NotNull
    private final List<PlacementModifier> modifiers;

    public PlacedFeatureBuilder(@NotNull Key id, @NotNull WritableRegistry<PlacedFeature> registry, @NotNull RegistryOps.RegistryInfoLookup lookup2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)lookup2, (String)"lookup");
        super(registry, id);
        ResourceKey resourceKey = Registries.CONFIGURED_FEATURE;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"CONFIGURED_FEATURE");
        this.configuredFeatureRegistry = NMSUtilsKt.lookupGetterOrThrow(lookup2, resourceKey);
        this.modifiers = new ArrayList();
    }

    public final void configuredFeature(@NotNull ResourceKey<ConfiguredFeature<?, ?>> configuredFeature) {
        Intrinsics.checkNotNullParameter(configuredFeature, (String)"configuredFeature");
        this.configuredFeature = (Holder)this.configuredFeatureRegistry.getOrThrow(configuredFeature);
    }

    public final void modifier(@NotNull PlacementModifier modifier) {
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        ((Collection)this.modifiers).add(modifier);
    }

    public final void modifiers(PlacementModifier ... modifiers) {
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        CollectionsKt.addAll((Collection)this.modifiers, (Object[])modifiers);
    }

    public final void modifiers(@NotNull Collection<? extends PlacementModifier> modifiers) {
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        CollectionsKt.addAll((Collection)this.modifiers, (Iterable)modifiers);
    }

    public final void biomeFilter() {
        ((Collection)this.modifiers).add(BiomeFilter.biome());
    }

    public final void blockPredicateFilter(@NotNull BlockPredicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        ((Collection)this.modifiers).add(BlockPredicateFilter.forPredicate((BlockPredicate)predicate));
    }

    public final void count(int count) {
        ((Collection)this.modifiers).add(CountPlacement.of((int)count));
    }

    public final void count(@NotNull IntProvider count) {
        Intrinsics.checkNotNullParameter((Object)count, (String)"count");
        ((Collection)this.modifiers).add(CountPlacement.of((IntProvider)count));
    }

    @Deprecated(message="Deprecated in vanilla.")
    public final void countOnEveryLayer(int count) {
        ((Collection)this.modifiers).add(CountOnEveryLayerPlacement.of((int)count));
    }

    @Deprecated(message="Deprecated in vanilla.")
    public final void countOnEveryLayer(@NotNull IntProvider count) {
        Intrinsics.checkNotNullParameter((Object)count, (String)"count");
        ((Collection)this.modifiers).add(CountOnEveryLayerPlacement.of((IntProvider)count));
    }

    public final void environmentScan(@NotNull Direction direction, @NotNull BlockPredicate target, @NotNull BlockPredicate continuePredicate, int maxSteps) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)continuePredicate, (String)"continuePredicate");
        ((Collection)this.modifiers).add(EnvironmentScanPlacement.scanningFor((Direction)direction, (BlockPredicate)target, (BlockPredicate)continuePredicate, (int)maxSteps));
    }

    public final void environmentScan(@NotNull Direction direction, @NotNull BlockPredicate target, int maxSteps) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ((Collection)this.modifiers).add(EnvironmentScanPlacement.scanningFor((Direction)direction, (BlockPredicate)target, (int)maxSteps));
    }

    public final void heightRange(@NotNull HeightProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        ((Collection)this.modifiers).add(HeightRangePlacement.of((HeightProvider)provider));
    }

    public final void heightRangeUniform(@NotNull VerticalAnchor min, @NotNull VerticalAnchor max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        ((Collection)this.modifiers).add(HeightRangePlacement.uniform((VerticalAnchor)min, (VerticalAnchor)max));
    }

    public final void heightRangeTriangle(@NotNull VerticalAnchor min, @NotNull VerticalAnchor max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        ((Collection)this.modifiers).add(HeightRangePlacement.triangle((VerticalAnchor)min, (VerticalAnchor)max));
    }

    public final void inYWorldBounds() {
        ((Collection)this.modifiers).add(PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT);
    }

    public final void heightMap(@NotNull Heightmap.Types heightmap) {
        Intrinsics.checkNotNullParameter((Object)heightmap, (String)"heightmap");
        ((Collection)this.modifiers).add(HeightmapPlacement.onHeightmap((Heightmap.Types)heightmap));
    }

    public final void moveToMotionBlocking() {
        ((Collection)this.modifiers).add(PlacementUtils.HEIGHTMAP);
    }

    public final void moveToWorldSurface() {
        ((Collection)this.modifiers).add(PlacementUtils.HEIGHTMAP_WORLD_SURFACE);
    }

    public final void moveToOceanFloor() {
        ((Collection)this.modifiers).add(PlacementUtils.HEIGHTMAP_OCEAN_FLOOR);
    }

    public final void moveToTopSolid() {
        ((Collection)this.modifiers).add(PlacementUtils.HEIGHTMAP_TOP_SOLID);
    }

    public final void inSquareSpread() {
        ((Collection)this.modifiers).add(InSquarePlacement.spread());
    }

    public final void noiseBasedCount(int noiseToCountRatio, double noiseFactor, double noiseOffset) {
        ((Collection)this.modifiers).add(NoiseBasedCountPlacement.of((int)noiseToCountRatio, (double)noiseFactor, (double)noiseOffset));
    }

    public final void noiseThresholdCount(double noiseLevel, int belowNoise, int aboveNoise) {
        ((Collection)this.modifiers).add(NoiseThresholdCountPlacement.of((double)noiseLevel, (int)belowNoise, (int)aboveNoise));
    }

    public final void randomOffset(@NotNull IntProvider xzSpread, @NotNull IntProvider ySpread) {
        Intrinsics.checkNotNullParameter((Object)xzSpread, (String)"xzSpread");
        Intrinsics.checkNotNullParameter((Object)ySpread, (String)"ySpread");
        ((Collection)this.modifiers).add(RandomOffsetPlacement.of((IntProvider)xzSpread, (IntProvider)ySpread));
    }

    public final void randomOffset(int xzSpread, int ySpread) {
        ((Collection)this.modifiers).add(RandomOffsetPlacement.of((IntProvider)((IntProvider)ConstantInt.of((int)xzSpread)), (IntProvider)((IntProvider)ConstantInt.of((int)ySpread))));
    }

    public final void randomVerticalOffset(@NotNull IntProvider ySpread) {
        Intrinsics.checkNotNullParameter((Object)ySpread, (String)"ySpread");
        ((Collection)this.modifiers).add(RandomOffsetPlacement.of((IntProvider)((IntProvider)ConstantInt.of((int)0)), (IntProvider)ySpread));
    }

    public final void randomVerticalOffset(int ySpread) {
        ((Collection)this.modifiers).add(RandomOffsetPlacement.of((IntProvider)((IntProvider)ConstantInt.of((int)0)), (IntProvider)((IntProvider)ConstantInt.of((int)ySpread))));
    }

    public final void randomHorizontalOffset(@NotNull IntProvider xzSpread) {
        Intrinsics.checkNotNullParameter((Object)xzSpread, (String)"xzSpread");
        ((Collection)this.modifiers).add(RandomOffsetPlacement.of((IntProvider)xzSpread, (IntProvider)((IntProvider)ConstantInt.of((int)0))));
    }

    public final void randomHorizontalOffset(int xzSpread) {
        ((Collection)this.modifiers).add(RandomOffsetPlacement.of((IntProvider)((IntProvider)ConstantInt.of((int)xzSpread)), (IntProvider)((IntProvider)ConstantInt.of((int)0))));
    }

    public final void rarityFilter(int onAverageOnceEvery) {
        ((Collection)this.modifiers).add(RarityFilter.onAverageOnceEvery((int)onAverageOnceEvery));
    }

    public final void surfaceRelativeThresholdFilter(@NotNull Heightmap.Types heightmap, int min, int max) {
        Intrinsics.checkNotNullParameter((Object)heightmap, (String)"heightmap");
        ((Collection)this.modifiers).add(SurfaceRelativeThresholdFilter.of((Heightmap.Types)heightmap, (int)min, (int)max));
    }

    public final void surfaceWaterDepthFilter(int maxDepth) {
        ((Collection)this.modifiers).add(SurfaceWaterDepthFilter.forMaxDepth((int)maxDepth));
    }

    public final void fixedPlacement(BlockPos ... positions) {
        Intrinsics.checkNotNullParameter((Object)positions, (String)"positions");
        ((Collection)this.modifiers).add(new FixedPlacement(CollectionsKt.listOf((Object[])Arrays.copyOf(positions, positions.length))));
    }

    public final void fixedPlacement(@NotNull List<? extends BlockPos> positions) {
        Intrinsics.checkNotNullParameter(positions, (String)"positions");
        ((Collection)this.modifiers).add(new FixedPlacement(positions));
    }

    @Override
    @NotNull
    protected PlacedFeature build() {
        if (this.configuredFeature == null) {
            boolean bl = false;
            String string = "No configured feature was set for placed feature " + this.getId();
            throw new IllegalArgumentException(string.toString());
        }
        if (this.modifiers.isEmpty()) {
            NovaBootstrapperKt.getLOGGER().warn("Placed feature " + this.getId() + " has no placement modifiers!");
        }
        Holder<ConfiguredFeature<?, ?>> holder2 = this.configuredFeature;
        Intrinsics.checkNotNull(holder2);
        return new PlacedFeature(holder2, this.modifiers);
    }
}

