/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.item.behavior;

import com.google.common.collect.BiMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.bukkit.World;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.SchedulerUtilsKt;
import xyz.xenondevs.nova.world.BlockPosKt;
import xyz.xenondevs.nova.world.item.behavior.ItemBehavior;
import xyz.xenondevs.nova.world.item.behavior.StrippingKt;
import xyz.xenondevs.nova.world.player.WrappedPlayerInteractEvent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lxyz/xenondevs/nova/world/item/behavior/Stripping;", "Lxyz/xenondevs/nova/world/item/behavior/ItemBehavior;", "<init>", "()V", "handleInteract", "", "player", "Lorg/bukkit/entity/Player;", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "action", "Lorg/bukkit/event/block/Action;", "wrappedEvent", "Lxyz/xenondevs/nova/world/player/WrappedPlayerInteractEvent;", "stripBlock", "", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "level", "Lnet/minecraft/server/level/ServerLevel;", "pos", "Lnet/minecraft/core/BlockPos;", "nova"})
@SourceDebugExtension(value={"SMAP\nStripping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Stripping.kt\nxyz/xenondevs/nova/world/item/behavior/Stripping\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public final class Stripping
implements ItemBehavior {
    @NotNull
    public static final Stripping INSTANCE = new Stripping();

    private Stripping() {
    }

    @Override
    public void handleInteract(@NotNull org.bukkit.entity.Player player, @NotNull ItemStack itemStack, @NotNull Action action, @NotNull WrappedPlayerInteractEvent wrappedEvent) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)((Object)wrappedEvent), (String)"wrappedEvent");
        if (wrappedEvent.getActionPerformed()) {
            return;
        }
        PlayerInteractEvent event = wrappedEvent.getEvent();
        if (action == Action.RIGHT_CLICK_BLOCK) {
            org.bukkit.block.Block block = event.getClickedBlock();
            Intrinsics.checkNotNull((Object)block);
            org.bukkit.block.Block block2 = block;
            Player player2 = (Player)NMSUtilsKt.getServerPlayer(player);
            EquipmentSlot equipmentSlot = event.getHand();
            Intrinsics.checkNotNull((Object)equipmentSlot);
            InteractionHand interactionHand = NMSUtilsKt.getNmsInteractionHand(equipmentSlot);
            BlockState blockState = NMSUtilsKt.getNmsState(block2);
            World world = block2.getWorld();
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
            event.setCancelled(this.stripBlock(player2, interactionHand, blockState, NMSUtilsKt.getServerLevel(world), BlockPosKt.getPos(block2).getNmsPos()));
        }
    }

    private final boolean stripBlock(Player player, InteractionHand hand, BlockState state, ServerLevel level, BlockPos pos) {
        BlockState honeycomb;
        Block stripped;
        Block block = state.getBlock();
        net.minecraft.world.item.ItemStack itemStack = player.getItemInHand(hand);
        Block block2 = (Block)StrippingKt.access$getSTRIPPABLES$p().get(block);
        if (block2 != null && (block2 = block2.defaultBlockState()) != null) {
            Block block3;
            Block $this$stripBlock_u24lambda_u241 = block3 = block2;
            boolean bl = false;
            $this$stripBlock_u24lambda_u241.setValue((Property)RotatedPillarBlock.AXIS, state.getValue((Property)RotatedPillarBlock.AXIS));
            v1 = block3;
        } else {
            v1 = stripped = null;
        }
        if (stripped != null) {
            level.playSound(null, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            Stripping.stripBlock$setNewState(level, pos, itemStack, player, hand, (BlockState)stripped);
            return true;
        }
        BlockState copper = WeatheringCopper.getPrevious((BlockState)state).orElse(null);
        if (copper != null) {
            level.playSound(null, pos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent((Entity)player, 3005, pos, 0);
            Stripping.stripBlock$setNewState(level, pos, itemStack, player, hand, copper);
            return true;
        }
        Block block4 = (Block)((BiMap)HoneycombItem.WAX_OFF_BY_BLOCK.get()).get((Object)block);
        Object object = honeycomb = block4 != null ? block4.withPropertiesOf(state) : null;
        if (honeycomb != null) {
            level.playSound(null, pos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent((Entity)player, 3004, pos, 0);
            Stripping.stripBlock$setNewState(level, pos, itemStack, player, hand, honeycomb);
            return true;
        }
        return false;
    }

    private static final void stripBlock$setNewState(ServerLevel $level, BlockPos $pos, net.minecraft.world.item.ItemStack itemStack, Player $player, InteractionHand $hand, BlockState newState) {
        SchedulerUtilsKt.runTaskLater(1L, (Function0<Unit>)((Function0)() -> Stripping.stripBlock$setNewState$lambda$0($player, $hand)));
        $level.setBlock($pos, newState, 11);
        itemStack.hurtAndBreak(1, (LivingEntity)$player, NMSUtilsKt.getNmsEquipmentSlot($hand));
    }

    private static final Unit stripBlock$setNewState$lambda$0(Player $player, InteractionHand $hand) {
        $player.swing($hand, true);
        return Unit.INSTANCE;
    }
}

