/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.item.recipe;

import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.TransmuteResult;
import net.minecraft.world.level.Level;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.data.RecipeUtilsKt;
import xyz.xenondevs.nova.util.item.ItemUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lxyz/xenondevs/nova/world/item/recipe/NovaSmithingTransformRecipe;", "Lnet/minecraft/world/item/crafting/SmithingTransformRecipe;", "bukkitRecipe", "Lorg/bukkit/inventory/SmithingTransformRecipe;", "<init>", "(Lorg/bukkit/inventory/SmithingTransformRecipe;)V", "templateChoice", "Lorg/bukkit/inventory/RecipeChoice;", "Lorg/jetbrains/annotations/NotNull;", "baseChoice", "additionChoice", "matches", "", "input", "Lnet/minecraft/world/item/crafting/SmithingRecipeInput;", "world", "Lnet/minecraft/world/level/Level;", "assemble", "Lnet/minecraft/world/item/ItemStack;", "lookup", "Lnet/minecraft/core/HolderLookup$Provider;", "toBukkitRecipe", "Lorg/bukkit/inventory/Recipe;", "id", "Lorg/bukkit/NamespacedKey;", "nova"})
public final class NovaSmithingTransformRecipe
extends SmithingTransformRecipe {
    @NotNull
    private final org.bukkit.inventory.SmithingTransformRecipe bukkitRecipe;
    @NotNull
    private final RecipeChoice templateChoice;
    @NotNull
    private final RecipeChoice baseChoice;
    @NotNull
    private final RecipeChoice additionChoice;

    public NovaSmithingTransformRecipe(@NotNull org.bukkit.inventory.SmithingTransformRecipe bukkitRecipe) {
        Intrinsics.checkNotNullParameter((Object)bukkitRecipe, (String)"bukkitRecipe");
        RecipeChoice recipeChoice = bukkitRecipe.getTemplate();
        Intrinsics.checkNotNullExpressionValue((Object)recipeChoice, (String)"getTemplate(...)");
        Optional<Ingredient> optional = Optional.of(RecipeUtilsKt.toNmsIngredient(recipeChoice));
        RecipeChoice recipeChoice2 = bukkitRecipe.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)recipeChoice2, (String)"getBase(...)");
        Ingredient ingredient = RecipeUtilsKt.toNmsIngredient(recipeChoice2);
        RecipeChoice recipeChoice3 = bukkitRecipe.getAddition();
        Intrinsics.checkNotNullExpressionValue((Object)recipeChoice3, (String)"getAddition(...)");
        super(optional, ingredient, Optional.of(RecipeUtilsKt.toNmsIngredient(recipeChoice3)), new TransmuteResult(NMSUtilsKt.unwrap(bukkitRecipe.getResult()).getItemHolder(), bukkitRecipe.getResult().getAmount(), NMSUtilsKt.unwrap(bukkitRecipe.getResult()).getComponentsPatch()));
        this.bukkitRecipe = bukkitRecipe;
        RecipeChoice recipeChoice4 = this.bukkitRecipe.getTemplate();
        Intrinsics.checkNotNullExpressionValue((Object)recipeChoice4, (String)"getTemplate(...)");
        this.templateChoice = recipeChoice4;
        RecipeChoice recipeChoice5 = this.bukkitRecipe.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)recipeChoice5, (String)"getBase(...)");
        this.baseChoice = recipeChoice5;
        RecipeChoice recipeChoice6 = this.bukkitRecipe.getAddition();
        Intrinsics.checkNotNullExpressionValue((Object)recipeChoice6, (String)"getAddition(...)");
        this.additionChoice = recipeChoice6;
    }

    public boolean matches(@NotNull SmithingRecipeInput input, @NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return this.templateChoice.test(input.getItem(0).asBukkitMirror()) && this.baseChoice.test(input.getItem(1).asBukkitMirror()) && this.additionChoice.test(input.getItem(2).asBukkitMirror());
    }

    @NotNull
    public ItemStack assemble(@NotNull SmithingRecipeInput input, @NotNull HolderLookup.Provider lookup2) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)lookup2, (String)"lookup");
        ItemStack recipeResult = NMSUtilsKt.unwrap(this.bukkitRecipe.getResult());
        Object[] objectArray = new DataComponentPatch[]{input.base().getComponentsPatch(), recipeResult.getComponentsPatch()};
        DataComponentPatch mergedPatch = ItemUtils.INSTANCE.mergeDataComponentPatches$nova(CollectionsKt.listOf((Object[])objectArray));
        return new ItemStack(recipeResult.getItemHolder(), recipeResult.getCount(), mergedPatch);
    }

    @NotNull
    public Recipe toBukkitRecipe(@NotNull NamespacedKey id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return (Recipe)this.bukkitRecipe;
    }
}

