/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.CopyActionContext;
import kotlin.io.path.CopyActionResult;
import kotlin.io.path.FileVisitorBuilder;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.NovaBootstrapperKt;
import xyz.xenondevs.nova.addon.Addon;
import xyz.xenondevs.nova.addon.AddonBootstrapper;
import xyz.xenondevs.nova.addon.AddonKt;
import xyz.xenondevs.nova.config.PermanentStorage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010\r\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\b\u0010\u0010\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lxyz/xenondevs/nova/LegacyDataFolderMigrator;", "", "<init>", "()V", "PLUGINS_DIR", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "migrate", "", "determineDataFolder", "namespace", "", "prefixedFile", "migrateConfigs", "migratePrefixedDataFiles", "dir", "migrateWorldgen", "deleteEmptyDirs", "nova"})
@SourceDebugExtension(value={"SMAP\nLegacyDataFolderMigrator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyDataFolderMigrator.kt\nxyz/xenondevs/nova/LegacyDataFolderMigrator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 PermanentStorage.kt\nxyz/xenondevs/nova/config/PermanentStorage\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 IOUtils.kt\nxyz/xenondevs/nova/util/data/IOUtilsKt\n+ 7 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 8 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,191:1\n1321#2,2:192\n1321#2,2:222\n774#3:194\n865#3,2:195\n1869#3,2:197\n1252#3,4:205\n1869#3,2:237\n85#4:199\n82#4:209\n85#4:214\n85#4:218\n82#4:224\n85#4:229\n85#4:233\n82#4:239\n1#5:200\n1#5:210\n1#5:215\n1#5:219\n1#5:225\n1#5:230\n1#5:234\n1#5:240\n75#6:201\n100#6:211\n101#6:213\n75#6:216\n75#6:220\n100#6:226\n101#6:228\n75#6:231\n75#6:235\n100#6:241\n101#6:243\n80#7:202\n42#7:212\n80#7:217\n80#7:221\n42#7:227\n80#7:232\n80#7:236\n42#7:242\n478#8:203\n424#8:204\n*S KotlinDebug\n*F\n+ 1 LegacyDataFolderMigrator.kt\nxyz/xenondevs/nova/LegacyDataFolderMigrator\n*L\n72#1:192,2\n118#1:222,2\n80#1:194\n80#1:195,2\n81#1:197,2\n97#1:205,4\n145#1:237,2\n94#1:199\n104#1:209\n112#1:214\n113#1:218\n133#1:224\n142#1:229\n143#1:233\n174#1:239\n94#1:200\n104#1:210\n112#1:215\n113#1:219\n133#1:225\n142#1:230\n143#1:234\n174#1:240\n94#1:201\n104#1:211\n104#1:213\n112#1:216\n113#1:220\n133#1:226\n133#1:228\n142#1:231\n143#1:235\n174#1:241\n174#1:243\n94#1:202\n104#1:212\n112#1:217\n113#1:221\n133#1:227\n142#1:232\n143#1:236\n174#1:242\n97#1:203\n97#1:204\n*E\n"})
public final class LegacyDataFolderMigrator {
    @NotNull
    public static final LegacyDataFolderMigrator INSTANCE = new LegacyDataFolderMigrator();
    private static final Path PLUGINS_DIR = NovaBootstrapperKt.getDATA_FOLDER().getParent();

    private LegacyDataFolderMigrator() {
    }

    public final void migrate() {
        Path addonsDir = NovaBootstrapperKt.getDATA_FOLDER().resolve("addons");
        Intrinsics.checkNotNull((Object)addonsDir);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(addonsDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && !((Collection)PathsKt.listDirectoryEntries$default((Path)addonsDir, null, (int)1, null)).isEmpty()) {
            throw new Exception("plugins/Nova/addons exists, but addons are plugins now. Please move all addons to plugins/");
        }
        this.migrateConfigs();
        this.migratePrefixedDataFiles("recipes");
        this.migratePrefixedDataFiles("loot");
        this.migrateWorldgen();
        PermanentStorage.INSTANCE.remove("storedConfigs");
        PermanentStorage.INSTANCE.remove("updatableFileHashes");
    }

    private final Path determineDataFolder(String namespace) {
        for (Addon addon : AddonBootstrapper.getAddons()) {
            if (!Intrinsics.areEqual((Object)AddonKt.getId(addon), (Object)namespace)) continue;
            return addon.getDataFolder();
        }
        return null;
    }

    private final Path determineDataFolder(Path prefixedFile) {
        for (Addon addon : AddonBootstrapper.getAddons()) {
            if (!StringsKt.startsWith$default((String)PathsKt.getName((Path)prefixedFile), (String)(AddonKt.getId(addon) + "_"), (boolean)false, (int)2, null)) continue;
            return addon.getDataFolder();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void migrateConfigs() {
        Map storedConfigs;
        Object object;
        Object stream$iv$iv$iv;
        Object object2;
        Map $this$readJson$iv$iv;
        void this_$iv;
        Object newConfigDir;
        Object dataFolder;
        Path element$iv;
        Object $this$forEach$iv;
        Path configs = NovaBootstrapperKt.getDATA_FOLDER().resolve("configs");
        Intrinsics.checkNotNull((Object)configs);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(configs, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Iterator $this$filterTo$iv$iv;
            Path configsNova = configs.resolve("nova");
            Intrinsics.checkNotNull((Object)configsNova);
            $this$forEach$iv = SequencesKt.filter((Sequence)PathsKt.walk((Path)configsNova, (PathWalkOption[])new PathWalkOption[0]), LegacyDataFolderMigrator::migrateConfigs$lambda$0);
            boolean $i$f$forEach = false;
            Object object3 = $this$forEach$iv.iterator();
            while (object3.hasNext()) {
                Path path;
                Path it = element$iv = object3.next();
                boolean bl = false;
                Path path2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)it.getParent().getParent().resolve(PathsKt.getName((Path)it)), (String)"resolve(...)");
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                CopyOption[] copyOptionArray2 = copyOptionArray;
                Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, path, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
                PathsKt.deleteRecursively((Path)it);
            }
            PathsKt.deleteRecursively((Path)configsNova);
            Iterable $this$filter$iv = PathsKt.listDirectoryEntries$default((Path)configs, null, (int)1, null);
            boolean $i$f$filter = false;
            object3 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator bl = $this$filterTo$iv$iv.iterator();
            while (bl.hasNext()) {
                Object element$iv$iv = bl.next();
                Path it = (Path)element$iv$iv;
                boolean bl2 = false;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!(Files.isDirectory(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) && !Intrinsics.areEqual((Object)PathsKt.getName((Path)it), (Object)"nova"))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$forEach$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Path legacyConfigDir = element$iv = $this$filterTo$iv$iv.next();
                boolean bl3 = false;
                dataFolder = INSTANCE.determineDataFolder(PathsKt.getName((Path)legacyConfigDir));
                if (dataFolder != null) {
                    newConfigDir = dataFolder.resolve("configs/");
                    Intrinsics.checkNotNull((Object)newConfigDir);
                    FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)newConfigDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
                    PathsKt.copyToRecursively$default((Path)legacyConfigDir, (Path)newConfigDir, null, (boolean)false, (boolean)true, (int)2, null);
                    PathsKt.deleteRecursively((Path)legacyConfigDir);
                    continue;
                }
                NovaBootstrapperKt.getLOGGER().warn("Could not resolve addon " + PathsKt.getName((Path)legacyConfigDir) + " for config relocation");
            }
        }
        $this$forEach$iv = PermanentStorage.INSTANCE;
        String key$iv = "storedConfigs";
        boolean $i$f$retrieve = false;
        Path it$iv = element$iv = this_$iv.getPath(key$iv);
        boolean bl = false;
        LinkOption[] linkOptionArray3 = new LinkOption[]{};
        Path path = Files.exists(it$iv, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) ? element$iv : null;
        if (path != null) {
            element$iv = path;
            Json json$iv$iv = this_$iv.getJSON();
            boolean $i$f$readJson = false;
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream((Path)((Object)$this$readJson$iv$iv), Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            dataFolder = inputStream;
            newConfigDir = null;
            try {
                void $this$decodeFromStream$iv$iv$iv;
                Object it$iv$iv = (InputStream)dataFolder;
                boolean bl4 = false;
                object2 = json$iv$iv;
                stream$iv$iv$iv = it$iv$iv;
                boolean $i$f$decodeFromStream = false;
                $this$decodeFromStream$iv$iv$iv.getSerializersModule();
                it$iv$iv = JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv$iv$iv, (DeserializationStrategy)((DeserializationStrategy)BuiltinSerializersKt.getNullable((KSerializer)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE))), (InputStream)stream$iv$iv$iv);
                object = it$iv$iv;
            }
            catch (Throwable throwable) {
                newConfigDir = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)dataFolder, (Throwable)newConfigDir);
            }
        } else {
            object = null;
        }
        if ((storedConfigs = (Map)object) != null) {
            void $this$writeJson$iv$iv;
            void key$iv2;
            void this_$iv2;
            void it$iv$iv;
            String key;
            void $this$associateByTo$iv$iv$iv;
            void $this$mapKeysTo$iv$iv;
            Object $this$mapKeys$iv = storedConfigs;
            boolean $i$f$mapKeys22 = false;
            $this$readJson$iv$iv = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo22 = false;
            dataFolder = $this$mapKeysTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                stream$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv$iv;
                boolean bl5 = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                key = (String)stream$iv$iv$iv.getKey();
                String string = Intrinsics.areEqual((Object)key, (Object)"configs/config.yml") ? "nova:config" : StringsKt.removeSuffix((String)StringsKt.replaceFirst$default((String)StringsKt.substringAfter$default((String)key, (char)'/', null, (int)2, null), (char)'/', (char)':', (boolean)false, (int)4, null), (CharSequence)".yml");
                Map map3 = map2;
                boolean bl6 = false;
                stream$iv$iv$iv = it$iv$iv.getValue();
                map3.put(string, stream$iv$iv$iv);
            }
            Map newStoredConfigs = destination$iv$iv$iv;
            $this$mapKeys$iv = PermanentStorage.INSTANCE;
            String $i$f$mapKeys22 = "stored_configs";
            Map data$iv = newStoredConfigs;
            boolean $i$f$store = false;
            Path $i$f$mapKeysTo22 = this_$iv2.getPath((String)key$iv2);
            Object it$iv2 = $i$f$mapKeysTo22;
            boolean bl7 = false;
            PathsKt.createParentDirectories((Path)it$iv2, (FileAttribute[])new FileAttribute[0]);
            it$iv2 = data$iv;
            Json json$iv$iv = this_$iv2.getJSON();
            boolean $i$f$writeJson = false;
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream((Path)$this$writeJson$iv$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable closeable = outputStream;
            object2 = null;
            try {
                void value$iv$iv$iv;
                void $this$encodeToStream$iv$iv$iv;
                void value$iv$iv;
                OutputStream it$iv$iv2 = (OutputStream)closeable;
                boolean bl8 = false;
                key = json$iv$iv;
                it$iv$iv = value$iv$iv;
                OutputStream stream$iv$iv$iv2 = it$iv$iv2;
                boolean $i$f$encodeToStream = false;
                $this$encodeToStream$iv$iv$iv.getSerializersModule();
                JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv$iv$iv, (SerializationStrategy)((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE)), (Object)value$iv$iv$iv, (OutputStream)stream$iv$iv$iv2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
            PermanentStorage.INSTANCE.remove("storedConfigs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void migratePrefixedDataFiles(String dir) {
        Path legacyDir = NovaBootstrapperKt.getDATA_FOLDER().resolve(dir);
        Intrinsics.checkNotNull((Object)legacyDir);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(legacyDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            void $this$writeJson$iv$iv;
            Path legacyFile;
            PermanentStorage $this$forEach$iv;
            Map map2;
            Object object;
            CopyOption[] $this$decodeFromStream$iv$iv$iv;
            void this_$iv;
            Map map3;
            Object object2;
            InputStream stream$iv$iv$iv;
            Object it$iv$iv;
            Object object3;
            Object json$iv$iv;
            Sequence this_$iv2;
            Path path;
            PermanentStorage permanentStorage = PermanentStorage.INSTANCE;
            Object key$iv = "updatableFileHashes";
            boolean $i$f$retrieve = false;
            Path it$iv = path = this_$iv2.getPath((String)key$iv);
            boolean bl = false;
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            Path path2 = Files.exists(it$iv, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) ? path : null;
            if (path2 != null) {
                void $this$readJson$iv$iv;
                path = path2;
                json$iv$iv = this_$iv2.getJSON();
                boolean $i$f$readJson = false;
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream((Path)$this$readJson$iv$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                Closeable closeable = inputStream;
                object3 = null;
                try {
                    void $this$decodeFromStream$iv$iv$iv2;
                    it$iv$iv = (InputStream)closeable;
                    boolean bl2 = false;
                    Object object4 = json$iv$iv;
                    stream$iv$iv$iv = it$iv$iv;
                    boolean $i$f$decodeFromStream = false;
                    $this$decodeFromStream$iv$iv$iv2.getSerializersModule();
                    it$iv$iv = JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv$iv$iv2, (DeserializationStrategy)((DeserializationStrategy)BuiltinSerializersKt.getNullable((KSerializer)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE))), (InputStream)stream$iv$iv$iv);
                    object2 = it$iv$iv;
                }
                catch (Throwable bl2) {
                    object3 = bl2;
                    throw bl2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object3);
                }
            } else {
                object2 = null;
            }
            if ((map3 = (Map)object2) == null) {
                map3 = new HashMap();
            }
            Map oldUpdatableFiles = map3;
            key$iv = PermanentStorage.INSTANCE;
            Object key$iv2 = "updatable_file_hashes";
            boolean $i$f$retrieve2 = false;
            Object it$iv2 = json$iv$iv = this_$iv.getPath((String)key$iv2);
            $i$a$-takeIf-PermanentStorage$retrieve$2$iv = false;
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            Object object5 = Files.exists((Path)it$iv2, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) ? json$iv$iv : null;
            if (object5 != null) {
                void $this$readJson$iv$iv;
                json$iv$iv = object5;
                Json json$iv$iv2 = this_$iv.getJSON();
                boolean $i$f$readJson = false;
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream((Path)$this$readJson$iv$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                object3 = inputStream;
                it$iv$iv = null;
                try {
                    InputStream it$iv$iv2 = (InputStream)object3;
                    boolean bl3 = false;
                    stream$iv$iv$iv = json$iv$iv2;
                    InputStream stream$iv$iv$iv2 = it$iv$iv2;
                    boolean $i$f$decodeFromStream = false;
                    $this$decodeFromStream$iv$iv$iv.getSerializersModule();
                    Object object6 = JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv$iv$iv, (DeserializationStrategy)((DeserializationStrategy)BuiltinSerializersKt.getNullable((KSerializer)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE))), (InputStream)stream$iv$iv$iv2);
                    object = object6;
                }
                catch (Throwable bl3) {
                    it$iv$iv = bl3;
                    throw bl3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object3, (Throwable)it$iv$iv);
                }
            } else {
                object = null;
            }
            if ((map2 = (Map)object) == null) {
                map2 = new HashMap();
            }
            Map newUpdatableFiles = map2;
            this_$iv2 = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)PathsKt.walk((Path)legacyDir, (PathWalkOption[])new PathWalkOption[0]), LegacyDataFolderMigrator::migratePrefixedDataFiles$lambda$0), arg_0 -> LegacyDataFolderMigrator.migratePrefixedDataFiles$lambda$1(oldUpdatableFiles, arg_0));
            boolean $i$f$forEach22 = false;
            key$iv2 = $this$forEach$iv.iterator();
            while (key$iv2.hasNext()) {
                Object element$iv = key$iv2.next();
                legacyFile = (Path)element$iv;
                boolean bl4 = false;
                Path dataFolder = INSTANCE.determineDataFolder(legacyFile);
                if (dataFolder != null) {
                    Object $i$f$decodeFromStream;
                    Object object7 = PathsKt.relativeTo((Path)legacyFile, (Path)legacyDir).getParent();
                    if (object7 == null || (object7 = PathsKt.getInvariantSeparatorsPathString((Path)object7)) == null) {
                        object7 = "";
                    }
                    Object relDirPath = object7;
                    Path newFile = dataFolder.resolve(dir).resolve((String)relDirPath).resolve(StringsKt.substringAfter$default((String)PathsKt.getName((Path)legacyFile), (char)'_', null, (int)2, null));
                    Path path3 = newFile.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getParent(...)");
                    Object object8 = path3;
                    Object bl3 = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object8, Arrays.copyOf(bl3, ((FileAttribute[])bl3).length)), (String)"createDirectories(...)");
                    object8 = legacyFile;
                    Intrinsics.checkNotNull((Object)newFile);
                    bl3 = newFile;
                    $this$decodeFromStream$iv$iv$iv = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    CopyOption[] stream$iv$iv$iv2 = $this$decodeFromStream$iv$iv$iv;
                    Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object8, (Path)bl3, Arrays.copyOf(stream$iv$iv$iv2, stream$iv$iv$iv2.length)), (String)"copy(...)");
                    Files.delete(legacyFile);
                    object8 = newUpdatableFiles;
                    Path path4 = PLUGINS_DIR;
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"PLUGINS_DIR");
                    bl3 = PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)newFile, (Path)path4));
                    Intrinsics.checkNotNull(oldUpdatableFiles.get(((Object)legacyFile.toAbsolutePath()).toString()));
                    object8.put(bl3, $i$f$decodeFromStream);
                    continue;
                }
                NovaBootstrapperKt.getLOGGER().warn("Could not resolve addon for prefixed data file relocation of " + legacyFile);
            }
            $this$forEach$iv = PermanentStorage.INSTANCE;
            String $i$f$forEach22 = "updatable_file_hashes";
            Map data$iv = newUpdatableFiles;
            boolean $i$f$store = false;
            legacyFile = this_$iv2.getPath((String)key$iv);
            it$iv = legacyFile;
            boolean bl5 = false;
            PathsKt.createParentDirectories((Path)it$iv, (FileAttribute[])new FileAttribute[0]);
            it$iv = data$iv;
            Json json$iv$iv3 = this_$iv2.getJSON();
            boolean $i$f$writeJson = false;
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream((Path)$this$writeJson$iv$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable closeable = outputStream;
            Throwable throwable = null;
            try {
                void value$iv$iv$iv;
                void $this$encodeToStream$iv$iv$iv;
                void value$iv$iv;
                OutputStream it$iv$iv3 = (OutputStream)closeable;
                boolean bl6 = false;
                Json stream$iv$iv$iv2 = json$iv$iv3;
                void $i$f$decodeFromStream = value$iv$iv;
                OutputStream stream$iv$iv$iv3 = it$iv$iv3;
                boolean $i$f$encodeToStream = false;
                $this$encodeToStream$iv$iv$iv.getSerializersModule();
                JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv$iv$iv, (SerializationStrategy)((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE)), (Object)value$iv$iv$iv, (OutputStream)stream$iv$iv$iv3);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            this.deleteEmptyDirs(legacyDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void migrateWorldgen() {
        Path data2 = NovaBootstrapperKt.getDATA_FOLDER().resolve("data");
        Intrinsics.checkNotNull((Object)data2);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(data2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            void $this$writeJson$iv$iv;
            Path namespaceDir;
            Map map2;
            Object object;
            FileAttribute[] $this$decodeFromStream$iv$iv$iv;
            void this_$iv;
            Map map3;
            Object object2;
            InputStream stream$iv$iv$iv;
            Object it$iv$iv;
            Object object3;
            Object json$iv$iv;
            void this_$iv2;
            Path path;
            PermanentStorage permanentStorage = PermanentStorage.INSTANCE;
            Object key$iv = "updatableFileHashes";
            boolean $i$f$retrieve = false;
            Path it$iv = path = this_$iv2.getPath((String)key$iv);
            boolean bl = false;
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            Path path2 = Files.exists(it$iv, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) ? path : null;
            if (path2 != null) {
                void $this$readJson$iv$iv;
                path = path2;
                json$iv$iv = this_$iv2.getJSON();
                boolean $i$f$readJson = false;
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream((Path)$this$readJson$iv$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                Closeable closeable = inputStream;
                object3 = null;
                try {
                    void $this$decodeFromStream$iv$iv$iv2;
                    it$iv$iv = (InputStream)closeable;
                    boolean bl2 = false;
                    Object object4 = json$iv$iv;
                    stream$iv$iv$iv = it$iv$iv;
                    boolean $i$f$decodeFromStream = false;
                    $this$decodeFromStream$iv$iv$iv2.getSerializersModule();
                    it$iv$iv = JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv$iv$iv2, (DeserializationStrategy)((DeserializationStrategy)BuiltinSerializersKt.getNullable((KSerializer)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE))), (InputStream)stream$iv$iv$iv);
                    object2 = it$iv$iv;
                }
                catch (Throwable bl2) {
                    object3 = bl2;
                    throw bl2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object3);
                }
            } else {
                object2 = null;
            }
            if ((map3 = (Map)object2) == null) {
                map3 = new HashMap();
            }
            Map oldUpdatableFiles = map3;
            key$iv = PermanentStorage.INSTANCE;
            Object key$iv2 = "updatable_file_hashes";
            boolean $i$f$retrieve2 = false;
            Object it$iv2 = json$iv$iv = this_$iv.getPath((String)key$iv2);
            $i$a$-takeIf-PermanentStorage$retrieve$2$iv = false;
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            Object object5 = Files.exists((Path)it$iv2, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) ? json$iv$iv : null;
            if (object5 != null) {
                void $this$readJson$iv$iv;
                json$iv$iv = object5;
                Json json$iv$iv2 = this_$iv.getJSON();
                boolean $i$f$readJson = false;
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream((Path)$this$readJson$iv$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                object3 = inputStream;
                it$iv$iv = null;
                try {
                    Object it$iv$iv2 = (InputStream)object3;
                    boolean bl3 = false;
                    stream$iv$iv$iv = json$iv$iv2;
                    InputStream stream$iv$iv$iv2 = it$iv$iv2;
                    boolean $i$f$decodeFromStream = false;
                    $this$decodeFromStream$iv$iv$iv.getSerializersModule();
                    it$iv$iv2 = JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv$iv$iv, (DeserializationStrategy)((DeserializationStrategy)BuiltinSerializersKt.getNullable((KSerializer)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE))), (InputStream)stream$iv$iv$iv2);
                    object = it$iv$iv2;
                }
                catch (Throwable bl3) {
                    it$iv$iv = bl3;
                    throw bl3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object3, (Throwable)it$iv$iv);
                }
            } else {
                object = null;
            }
            if ((map2 = (Map)object) == null) {
                map2 = new HashMap();
            }
            Map newUpdatableFiles = map2;
            Object $this$forEach$iv = PathsKt.listDirectoryEntries$default((Path)data2, null, (int)1, null);
            boolean $i$f$forEach22 = false;
            key$iv2 = $this$forEach$iv.iterator();
            while (key$iv2.hasNext()) {
                Object element$iv = key$iv2.next();
                namespaceDir = (Path)element$iv;
                boolean bl4 = false;
                String addonId = PathsKt.getName((Path)namespaceDir);
                Path dataFolder = INSTANCE.determineDataFolder(addonId);
                if (dataFolder != null) {
                    Path bl3;
                    Path oldWorldgen = namespaceDir.resolve("worldgen");
                    Intrinsics.checkNotNull((Object)oldWorldgen);
                    LinkOption[] linkOptionArray4 = new LinkOption[]{};
                    if (!Files.exists(oldWorldgen, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length))) continue;
                    Path newWorldgen = dataFolder.resolve("worldgen");
                    Intrinsics.checkNotNullExpressionValue((Object)newWorldgen.getParent(), (String)"getParent(...)");
                    $this$decodeFromStream$iv$iv$iv = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(bl3, Arrays.copyOf($this$decodeFromStream$iv$iv$iv, $this$decodeFromStream$iv$iv$iv.length)), (String)"createDirectories(...)");
                    Intrinsics.checkNotNull((Object)newWorldgen);
                    PathsKt.copyToRecursively$default((Path)oldWorldgen, (Path)newWorldgen, null, (boolean)false, (arg_0, arg_1, arg_2) -> LegacyDataFolderMigrator.migrateWorldgen$lambda$0$0(oldUpdatableFiles, newUpdatableFiles, arg_0, arg_1, arg_2), (int)2, null);
                    PathsKt.deleteRecursively((Path)oldWorldgen);
                    continue;
                }
                NovaBootstrapperKt.getLOGGER().warn("Could not resolve addon " + addonId + " for worldgen relocation");
            }
            $this$forEach$iv = PermanentStorage.INSTANCE;
            String $i$f$forEach22 = "updatable_file_hashes";
            Map data$iv = newUpdatableFiles;
            boolean $i$f$store = false;
            namespaceDir = this_$iv2.getPath((String)key$iv);
            it$iv = namespaceDir;
            boolean bl5 = false;
            PathsKt.createParentDirectories((Path)it$iv, (FileAttribute[])new FileAttribute[0]);
            it$iv = data$iv;
            Json json$iv$iv3 = this_$iv2.getJSON();
            boolean $i$f$writeJson = false;
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream((Path)$this$writeJson$iv$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable closeable = outputStream;
            Throwable throwable = null;
            try {
                void value$iv$iv$iv;
                void $this$encodeToStream$iv$iv$iv;
                void value$iv$iv;
                OutputStream it$iv$iv3 = (OutputStream)closeable;
                boolean bl6 = false;
                Json stream$iv$iv$iv2 = json$iv$iv3;
                void $i$f$decodeFromStream = value$iv$iv;
                OutputStream stream$iv$iv$iv3 = it$iv$iv3;
                boolean $i$f$encodeToStream = false;
                $this$encodeToStream$iv$iv$iv.getSerializersModule();
                JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv$iv$iv, (SerializationStrategy)((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE)), (Object)value$iv$iv$iv, (OutputStream)stream$iv$iv$iv3);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            this.deleteEmptyDirs(data2);
        }
    }

    private final void deleteEmptyDirs(Path dir) {
        PathsKt.visitFileTree$default((Path)dir, (FileVisitor)PathsKt.fileVisitor(LegacyDataFolderMigrator::deleteEmptyDirs$lambda$0), (int)0, (boolean)false, (int)6, null);
    }

    private static final boolean migrateConfigs$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final boolean migratePrefixedDataFiles$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final boolean migratePrefixedDataFiles$lambda$1(Map $oldUpdatableFiles, Path legacyFile) {
        Intrinsics.checkNotNullParameter((Object)legacyFile, (String)"legacyFile");
        return $oldUpdatableFiles.containsKey(((Object)legacyFile.toAbsolutePath()).toString());
    }

    private static final CopyActionResult migrateWorldgen$lambda$0$0(Map $oldUpdatableFiles, Map $newUpdatableFiles, CopyActionContext $this$copyToRecursively, Path source, Path target) {
        Intrinsics.checkNotNullParameter((Object)$this$copyToRecursively, (String)"$this$copyToRecursively");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Path path = source;
        Object object = new LinkOption[]{};
        if (Files.isDirectory(path, Arrays.copyOf(object, ((LinkOption[])object).length))) {
            return CopyActionResult.CONTINUE;
        }
        Path path2 = target.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
        path = path2;
        object = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, (FileAttribute[])Arrays.copyOf(object, ((Object[])object).length)), (String)"createDirectories(...)");
        path = source;
        Object object2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Object object3 = object2;
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path, target, Arrays.copyOf(object3, ((CopyOption[])object3).length)), (String)"copy(...)");
        String hash = (String)$oldUpdatableFiles.get(((Object)source.toAbsolutePath()).toString());
        if (hash != null) {
            object = $newUpdatableFiles;
            Path path3 = PLUGINS_DIR;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"PLUGINS_DIR");
            object2 = PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)target, (Path)path3));
            object3 = hash;
            object.put(object2, object3);
        }
        return CopyActionResult.CONTINUE;
    }

    private static final Unit deleteEmptyDirs$lambda$0(FileVisitorBuilder $this$fileVisitor) {
        Intrinsics.checkNotNullParameter((Object)$this$fileVisitor, (String)"$this$fileVisitor");
        $this$fileVisitor.onPostVisitDirectory(LegacyDataFolderMigrator::deleteEmptyDirs$lambda$0$0);
        return Unit.INSTANCE;
    }

    private static final FileVisitResult deleteEmptyDirs$lambda$0$0(Path dir, IOException iOException) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (PathsKt.listDirectoryEntries$default((Path)dir, null, (int)1, null).isEmpty()) {
            Files.delete(dir);
        }
        return FileVisitResult.CONTINUE;
    }
}

