/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.mixin.block.behavior;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.Orientation;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.xenondevs.nova.NovaBootstrapperKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.block.state.model.BackingStateBlockModelProvider;
import xyz.xenondevs.nova.world.block.state.model.BlockModelProvider;
import xyz.xenondevs.nova.world.block.state.model.DisplayEntityBlockModelProvider;
import xyz.xenondevs.nova.world.block.state.model.ModelLessBlockModelProvider;
import xyz.xenondevs.nova.world.format.WorldDataManager;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
abstract class BlockBehaviourBlockStateBaseMixin {
    BlockBehaviourBlockStateBaseMixin() {
    }

    @Inject(method={"handleNeighborChanged"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleNeighborChanged(Level level, BlockPos pos, Block neighborBlock, Orientation orientation, boolean movedByPiston, CallbackInfo ci) {
        xyz.xenondevs.nova.world.BlockPos novaPos = NMSUtilsKt.toNovaPos(pos, (World)level.getWorld());
        NovaBlockState novaState = WorldDataManager.INSTANCE.getBlockState(novaPos);
        if (novaState == null) {
            return;
        }
        try {
            novaState.getBlock().handleNeighborChanged(novaPos, novaState);
        }
        catch (Exception e) {
            NovaBootstrapperKt.getLOGGER().error("Failed to handle neighbor change for {} at {}", new Object[]{novaState, novaPos, e});
        }
        ci.cancel();
    }

    @Inject(method={"updateShape"}, at={@At(value="HEAD")}, cancellable=true)
    private void updateShape(LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random, CallbackInfoReturnable<BlockState> cir) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        xyz.xenondevs.nova.world.BlockPos novaPos = NMSUtilsKt.toNovaPos(pos, (World)serverLevel.getWorld());
        NovaBlockState novaState = WorldDataManager.INSTANCE.getBlockState(novaPos);
        if (novaState == null) {
            return;
        }
        try {
            xyz.xenondevs.nova.world.BlockPos novaNeighborPos = NMSUtilsKt.toNovaPos(neighborPos, (World)serverLevel.getWorld());
            NovaBlockState newState = novaState.getBlock().updateShape(novaPos, novaState, novaNeighborPos);
            if (newState == novaState) {
                cir.setReturnValue((Object)((BlockState)this));
                return;
            }
            WorldDataManager.INSTANCE.setBlockState(novaPos, newState);
            BlockModelProvider blockModelProvider = newState.getModelProvider$nova();
            Objects.requireNonNull(blockModelProvider);
            BlockModelProvider blockModelProvider2 = blockModelProvider;
            int n = 0;
            BlockState ret = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BackingStateBlockModelProvider.class, ModelLessBlockModelProvider.class, DisplayEntityBlockModelProvider.class}, (Object)blockModelProvider2, n)) {
                case 0 -> {
                    BackingStateBlockModelProvider modelProvider = (BackingStateBlockModelProvider)blockModelProvider2;
                    yield modelProvider.getInfo().getVanillaBlockState();
                }
                case 1 -> {
                    ModelLessBlockModelProvider modelProvider = (ModelLessBlockModelProvider)blockModelProvider2;
                    yield modelProvider.getInfo();
                }
                case 2 -> {
                    DisplayEntityBlockModelProvider modelProvider = (DisplayEntityBlockModelProvider)blockModelProvider2;
                    novaState.getModelProvider$nova().unload(novaPos);
                    newState.getModelProvider$nova().load(novaPos);
                    yield modelProvider.getInfo().getHitboxType();
                }
                default -> throw new UnsupportedOperationException();
            };
            cir.setReturnValue((Object)ret);
        }
        catch (Exception e) {
            NovaBootstrapperKt.getLOGGER().error("Failed to update shape for {} at {}", new Object[]{novaState, novaPos, e});
        }
        cir.cancel();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void tick(ServerLevel level, BlockPos pos, RandomSource random, CallbackInfo ci) {
        xyz.xenondevs.nova.world.BlockPos novaPos = NMSUtilsKt.toNovaPos(pos, (World)level.getWorld());
        NovaBlockState novaState = WorldDataManager.INSTANCE.getBlockState(novaPos);
        if (novaState == null) {
            return;
        }
        try {
            novaState.getBlock().handleScheduledTick(novaPos, novaState);
        }
        catch (Exception e) {
            NovaBootstrapperKt.getLOGGER().error("Failed to handle vanilla scheduled tick for {} at {}", new Object[]{novaState, novaPos, e});
        }
        ci.cancel();
    }

    @Inject(method={"entityInside"}, at={@At(value="HEAD")}, cancellable=true)
    private void entityInside(Level level, BlockPos pos, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier effectApplier, CallbackInfo ci) {
        xyz.xenondevs.nova.world.BlockPos novaPos = NMSUtilsKt.toNovaPos(pos, (World)level.getWorld());
        NovaBlockState novaState = WorldDataManager.INSTANCE.getBlockState(novaPos);
        if (novaState == null) {
            return;
        }
        try {
            novaState.getBlock().handleEntityInside(novaPos, novaState, (Entity)entity.getBukkitEntity());
        }
        catch (Exception e) {
            NovaBootstrapperKt.getLOGGER().error("Failed to handle entity inside for {} at {}", new Object[]{novaState, novaPos, e});
        }
        ci.cancel();
    }
}

