/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.mixin.block.sound;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.xenondevs.nova.util.BlockUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.util.item.MaterialUtilsKt;
import xyz.xenondevs.nova.world.block.logic.sound.SoundEngine;
import xyz.xenondevs.nova.world.block.sound.SoundGroup;

@Mixin(value={Block.class})
abstract class BlockMixin {
    BlockMixin() {
    }

    @Inject(method={"playerWillDestroy"}, at={@At(value="TAIL")})
    private void playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player, CallbackInfoReturnable<BlockState> cir) {
        xyz.xenondevs.nova.world.BlockPos novaPos = NMSUtilsKt.toNovaPos(pos, (World)level.getWorld());
        SoundGroup soundGroup = BlockUtilsKt.getNovaSoundGroup(novaPos.getBlock());
        if (soundGroup == null) {
            return;
        }
        float volume = soundGroup.getBreakVolume();
        float pitch = soundGroup.getBreakPitch();
        String oldSound = MaterialUtilsKt.getSoundGroup(novaPos.getBlock().getType()).getBreakSound().key().value();
        SoundEngine.broadcastIfOverridden(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, volume > 1.0f ? (double)(16.0f * volume) : 16.0, oldSound, soundGroup.getBreakSound(), volume, pitch, SoundSource.BLOCKS);
    }
}

