/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.registry;

import com.mojang.serialization.Lifecycle;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.registry.FuzzyMappedRegistry;
import xyz.xenondevs.nova.registry.NovaRegistries;
import xyz.xenondevs.nova.registry.NovaRegistryAccess;
import xyz.xenondevs.nova.registry.WrappingRegistry;
import xyz.xenondevs.nova.ui.overlay.guitexture.GuiTexture;
import xyz.xenondevs.nova.ui.waila.info.WailaInfoProvider;
import xyz.xenondevs.nova.ui.waila.info.WailaToolIconProvider;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.block.NovaBlock;
import xyz.xenondevs.nova.world.block.tileentity.network.type.NetworkType;
import xyz.xenondevs.nova.world.block.tileentity.network.type.item.ItemFilterType;
import xyz.xenondevs.nova.world.generation.inject.biome.BiomeInjection;
import xyz.xenondevs.nova.world.generation.wrapper.WrapperBlock;
import xyz.xenondevs.nova.world.item.Equipment;
import xyz.xenondevs.nova.world.item.NovaItem;
import xyz.xenondevs.nova.world.item.TooltipStyle;
import xyz.xenondevs.nova.world.item.recipe.RecipeType;
import xyz.xenondevs.nova.world.item.tool.ToolCategory;
import xyz.xenondevs.nova.world.item.tool.ToolTier;
import xyz.xenondevs.nova.world.player.ability.AbilityType;
import xyz.xenondevs.nova.world.player.attachment.AttachmentType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0007J\u0010\u0010*\u001a\u00020\b2\u0006\u0010(\u001a\u00020)H\u0007J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\b0,H\u0007J \u0010-\u001a\b\u0012\u0004\u0012\u0002H.0\u0005\"\b\b\u0000\u0010.*\u00020\u00012\u0006\u0010/\u001a\u00020)H\u0002JL\u00100\u001a\b\u0012\u0004\u0012\u0002H.0\u0005\"\b\b\u0000\u0010.*\u00020\u0001\"\b\b\u0001\u00101*\u00020\u00012\u0006\u0010/\u001a\u00020)2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H10\u00052\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u0002H.\u0012\u0004\u0012\u0002H104H\u0002J \u00105\u001a\b\u0012\u0004\u0012\u0002H.0\n\"\b\b\u0000\u0010.*\u00020\u00012\u0006\u0010/\u001a\u00020)H\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lxyz/xenondevs/nova/registry/NovaRegistries;", "", "<init>", "()V", "WRAPPER_BLOCK", "Lnet/minecraft/core/WritableRegistry;", "Lxyz/xenondevs/nova/world/generation/wrapper/WrapperBlock;", "BLOCK", "Lxyz/xenondevs/nova/world/block/NovaBlock;", "ITEM", "Lxyz/xenondevs/nova/registry/FuzzyMappedRegistry;", "Lxyz/xenondevs/nova/world/item/NovaItem;", "EQUIPMENT", "Lxyz/xenondevs/nova/world/item/Equipment;", "TOOL_TIER", "Lxyz/xenondevs/nova/world/item/tool/ToolTier;", "TOOL_CATEGORY", "Lxyz/xenondevs/nova/world/item/tool/ToolCategory;", "NETWORK_TYPE", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/NetworkType;", "ABILITY_TYPE", "Lxyz/xenondevs/nova/world/player/ability/AbilityType;", "ATTACHMENT_TYPE", "Lxyz/xenondevs/nova/world/player/attachment/AttachmentType;", "RECIPE_TYPE", "Lxyz/xenondevs/nova/world/item/recipe/RecipeType;", "GUI_TEXTURE", "Lxyz/xenondevs/nova/ui/overlay/guitexture/GuiTexture;", "BIOME_INJECTION", "Lxyz/xenondevs/nova/world/generation/inject/biome/BiomeInjection;", "WAILA_INFO_PROVIDER", "Lxyz/xenondevs/nova/ui/waila/info/WailaInfoProvider;", "WAILA_TOOL_ICON_PROVIDER", "Lxyz/xenondevs/nova/ui/waila/info/WailaToolIconProvider;", "ITEM_FILTER_TYPE", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/item/ItemFilterType;", "TOOLTIP_STYLE", "Lxyz/xenondevs/nova/world/item/TooltipStyle;", "hasBlock", "", "block", "", "getBlockOrThrow", "blockStream", "Ljava/util/stream/Stream;", "simpleRegistry", "E", "name", "wrappingRegistry", "W", "wrapperRegistry", "toWrapper", "Lkotlin/Function1;", "fuzzyRegistry", "nova"})
public final class NovaRegistries {
    @NotNull
    public static final NovaRegistries INSTANCE = new NovaRegistries();
    @JvmField
    @NotNull
    public static final WritableRegistry<WrapperBlock> WRAPPER_BLOCK = INSTANCE.simpleRegistry("wrapper_block");
    @JvmField
    @NotNull
    public static final WritableRegistry<NovaBlock> BLOCK = INSTANCE.wrappingRegistry("block", WRAPPER_BLOCK, BLOCK.1.INSTANCE);
    @JvmField
    @NotNull
    public static final FuzzyMappedRegistry<NovaItem> ITEM = INSTANCE.fuzzyRegistry("item");
    @JvmField
    @NotNull
    public static final WritableRegistry<Equipment> EQUIPMENT = INSTANCE.simpleRegistry("armor");
    @JvmField
    @NotNull
    public static final WritableRegistry<ToolTier> TOOL_TIER = INSTANCE.simpleRegistry("tool_tier");
    @JvmField
    @NotNull
    public static final WritableRegistry<ToolCategory> TOOL_CATEGORY = INSTANCE.simpleRegistry("tool_category");
    @JvmField
    @NotNull
    public static final WritableRegistry<NetworkType<?>> NETWORK_TYPE = INSTANCE.simpleRegistry("network_type");
    @JvmField
    @NotNull
    public static final WritableRegistry<AbilityType<?>> ABILITY_TYPE = INSTANCE.simpleRegistry("ability_type");
    @JvmField
    @NotNull
    public static final WritableRegistry<AttachmentType<?>> ATTACHMENT_TYPE = INSTANCE.simpleRegistry("attachment_type");
    @JvmField
    @NotNull
    public static final WritableRegistry<RecipeType<?>> RECIPE_TYPE = INSTANCE.simpleRegistry("recipe_type");
    @JvmField
    @NotNull
    public static final WritableRegistry<GuiTexture> GUI_TEXTURE = INSTANCE.simpleRegistry("gui_texture");
    @JvmField
    @NotNull
    public static final WritableRegistry<BiomeInjection> BIOME_INJECTION = INSTANCE.simpleRegistry("biome_injection");
    @JvmField
    @NotNull
    public static final WritableRegistry<WailaInfoProvider<?>> WAILA_INFO_PROVIDER = INSTANCE.simpleRegistry("waila_info_provider");
    @JvmField
    @NotNull
    public static final WritableRegistry<WailaToolIconProvider> WAILA_TOOL_ICON_PROVIDER = INSTANCE.simpleRegistry("waila_tool_icon_provider");
    @JvmField
    @NotNull
    public static final WritableRegistry<ItemFilterType<?>> ITEM_FILTER_TYPE = INSTANCE.simpleRegistry("item_filter_type");
    @JvmField
    @NotNull
    public static final WritableRegistry<TooltipStyle> TOOLTIP_STYLE = INSTANCE.simpleRegistry("tooltip_style");

    private NovaRegistries() {
    }

    @ApiStatus.Internal
    public final boolean hasBlock(@NotNull String block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return NMSUtilsKt.contains((Registry)BLOCK, block);
    }

    @ApiStatus.Internal
    @NotNull
    public final NovaBlock getBlockOrThrow(@NotNull String block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Object t = NMSUtilsKt.getValueOrThrow((Registry)BLOCK, block);
        Intrinsics.checkNotNullExpressionValue(t, (String)"getValueOrThrow(...)");
        return (NovaBlock)t;
    }

    @ApiStatus.Internal
    @NotNull
    public final Stream<NovaBlock> blockStream() {
        Stream stream = BLOCK.stream();
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream(...)");
        return stream;
    }

    private final <E> WritableRegistry<E> simpleRegistry(String name) {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"nova", (String)name);
        Intrinsics.checkNotNull((Object)resourceLocation);
        return NovaRegistryAccess.INSTANCE.addRegistry$nova(resourceLocation);
    }

    private final <E, W> WritableRegistry<E> wrappingRegistry(String name, WritableRegistry<W> wrapperRegistry, Function1<? super E, ? extends W> toWrapper) {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"nova", (String)name);
        Intrinsics.checkNotNull((Object)resourceLocation);
        return (WritableRegistry)NovaRegistryAccess.INSTANCE.addRegistry$nova(resourceLocation, (arg_0, arg_1) -> NovaRegistries.wrappingRegistry$lambda$0(wrapperRegistry, toWrapper, arg_0, arg_1));
    }

    private final <E> FuzzyMappedRegistry<E> fuzzyRegistry(String name) {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"nova", (String)name);
        Intrinsics.checkNotNull((Object)resourceLocation);
        return NovaRegistryAccess.INSTANCE.addFuzzyRegistry$nova(resourceLocation);
    }

    private static final WritableRegistry wrappingRegistry$lambda$0(WritableRegistry $wrapperRegistry, Function1 $toWrapper, ResourceKey key, Lifecycle lifecycle) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
        return (WritableRegistry)new WrappingRegistry(key, lifecycle, $wrapperRegistry, $toWrapper);
    }
}

