/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.resources.builder.font.provider.unihex;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record UnihexGlyphs(@NotNull Int2ObjectOpenHashMap<int[]> glyphs8, @NotNull Int2ObjectOpenHashMap<int[]> glyphs16, @NotNull Int2ObjectOpenHashMap<int[]> glyphs24, @NotNull Int2ObjectOpenHashMap<int[]> glyphs32) {
    private static final byte[] HEX_CHARS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public UnihexGlyphs() {
        this((Int2ObjectOpenHashMap<int[]>)new Int2ObjectOpenHashMap(), (Int2ObjectOpenHashMap<int[]>)new Int2ObjectOpenHashMap(), (Int2ObjectOpenHashMap<int[]>)new Int2ObjectOpenHashMap(), (Int2ObjectOpenHashMap<int[]>)new Int2ObjectOpenHashMap());
    }

    @NotNull
    public static UnihexGlyphs readUnihexFile(@NotNull Path path) throws IOException {
        byte[] bin = Files.readAllBytes(path);
        return UnihexGlyphs.readUnihexFile(bin);
    }

    @NotNull
    public static UnihexGlyphs readUnihexFile(byte @NotNull [] bin) throws IOException {
        return UnihexGlyphs.readUnihexFile(new ByteArrayInputStream(bin));
    }

    @NotNull
    public static UnihexGlyphs readUnihexFile(@NotNull InputStream in) throws IOException {
        int i2;
        Int2ObjectOpenHashMap glyphs8 = new Int2ObjectOpenHashMap();
        Int2ObjectOpenHashMap glyphs16 = new Int2ObjectOpenHashMap();
        Int2ObjectOpenHashMap glyphs24 = new Int2ObjectOpenHashMap();
        Int2ObjectOpenHashMap glyphs32 = new Int2ObjectOpenHashMap();
        int codePoint = 0;
        ByteArrayList buffer = new ByteArrayList();
        while ((i2 = in.read()) != -1) {
            if (i2 == 58) {
                int size = buffer.size();
                if (size != 4 && size != 5 && size != 6) {
                    throw new IllegalArgumentException("Code point hex must be 4, 5, or 6 characters long");
                }
                for (int j = 0; j < size; ++j) {
                    codePoint = codePoint << 4 | UnihexGlyphs.fromHex(buffer.getByte(j));
                }
                buffer.clear();
                continue;
            }
            if (i2 == 10) {
                switch (buffer.size()) {
                    case 32: {
                        glyphs8.put(codePoint, (Object)UnihexGlyphs.read8(buffer.toByteArray()));
                        break;
                    }
                    case 64: {
                        glyphs16.put(codePoint, (Object)UnihexGlyphs.read16(buffer.toByteArray()));
                        break;
                    }
                    case 96: {
                        glyphs24.put(codePoint, (Object)UnihexGlyphs.read24(buffer.toByteArray()));
                        break;
                    }
                    case 128: {
                        glyphs32.put(codePoint, (Object)UnihexGlyphs.read32(buffer.toByteArray()));
                    }
                }
                buffer.clear();
                codePoint = 0;
                continue;
            }
            buffer.add((byte)i2);
        }
        return new UnihexGlyphs((Int2ObjectOpenHashMap<int[]>)glyphs8, (Int2ObjectOpenHashMap<int[]>)glyphs16, (Int2ObjectOpenHashMap<int[]>)glyphs24, (Int2ObjectOpenHashMap<int[]>)glyphs32);
    }

    public void writeUnihexFile(@NotNull Path path) throws IOException {
        Files.write(path, this.writeUnihexFile(), new OpenOption[0]);
    }

    public byte @NotNull [] writeUnihexFile() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeUnihexFile(out);
        return out.toByteArray();
    }

    public void writeUnihexFile(@NotNull OutputStream out) throws IOException {
        this.writeUnihexFile(out, (Int2ObjectMap<int[]>)this.glyphs8, UnihexGlyphs::write8);
        this.writeUnihexFile(out, (Int2ObjectMap<int[]>)this.glyphs16, UnihexGlyphs::write16);
        this.writeUnihexFile(out, (Int2ObjectMap<int[]>)this.glyphs24, UnihexGlyphs::write24);
        this.writeUnihexFile(out, (Int2ObjectMap<int[]>)this.glyphs32, UnihexGlyphs::write32);
    }

    private void writeUnihexFile(@NotNull OutputStream out, @NotNull @NotNull Int2ObjectMap<int @NotNull []> glyphs2, @NotNull @NotNull BiConsumer<@NotNull OutputStream, int @NotNull []> writer2) throws IOException {
        for (Int2ObjectMap.Entry glyph : glyphs2.int2ObjectEntrySet()) {
            UnihexGlyphs.writeCodePoint(out, glyph.getIntKey());
            out.write(58);
            writer2.accept(out, (int[])glyph.getValue());
            out.write(10);
        }
    }

    public void merge(@NotNull UnihexGlyphs other) {
        this.glyphs8.putAll(other.glyphs8);
        this.glyphs16.putAll(other.glyphs16);
        this.glyphs24.putAll(other.glyphs24);
        this.glyphs32.putAll(other.glyphs32);
    }

    public static int @NotNull [] read8(byte @NotNull [] bin) {
        int[] glyph = new int[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            int binIdx = i2 * 2;
            glyph[i2] = UnihexGlyphs.fromHex(bin[binIdx]) << 4 | UnihexGlyphs.fromHex(bin[binIdx + 1]);
        }
        return glyph;
    }

    public static int @NotNull [] read16(byte @NotNull [] bin) {
        int[] glyph = new int[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            int binIdx = i2 * 4;
            glyph[i2] = UnihexGlyphs.fromHex(bin[binIdx]) << 12 | UnihexGlyphs.fromHex(bin[binIdx + 1]) << 8 | UnihexGlyphs.fromHex(bin[binIdx + 2]) << 4 | UnihexGlyphs.fromHex(bin[binIdx + 3]);
        }
        return glyph;
    }

    public static int @NotNull [] read24(byte @NotNull [] bin) {
        int[] glyph = new int[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            int binIdx = i2 * 6;
            glyph[i2] = UnihexGlyphs.fromHex(bin[binIdx]) << 20 | UnihexGlyphs.fromHex(bin[binIdx + 1]) << 16 | UnihexGlyphs.fromHex(bin[binIdx + 2]) << 12 | UnihexGlyphs.fromHex(bin[binIdx + 3]) << 8 | UnihexGlyphs.fromHex(bin[binIdx + 4]) << 4 | UnihexGlyphs.fromHex(bin[binIdx + 5]);
        }
        return glyph;
    }

    public static int @NotNull [] read32(byte @NotNull [] bin) {
        int[] glyph = new int[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            int binIdx = i2 * 8;
            glyph[i2] = UnihexGlyphs.fromHex(bin[binIdx]) << 28 | UnihexGlyphs.fromHex(bin[binIdx + 1]) << 24 | UnihexGlyphs.fromHex(bin[binIdx + 2]) << 20 | UnihexGlyphs.fromHex(bin[binIdx + 3]) << 16 | UnihexGlyphs.fromHex(bin[binIdx + 4]) << 12 | UnihexGlyphs.fromHex(bin[binIdx + 5]) << 8 | UnihexGlyphs.fromHex(bin[binIdx + 6]) << 4 | UnihexGlyphs.fromHex(bin[binIdx + 7]);
        }
        return glyph;
    }

    public static void write8(@NotNull OutputStream out, int @NotNull [] glyph) {
        try {
            for (int i2 = 0; i2 < 16; ++i2) {
                int line = glyph[i2];
                out.write(HEX_CHARS[line >>> 4 & 0xF]);
                out.write(HEX_CHARS[line & 0xF]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write16(@NotNull OutputStream out, int @NotNull [] glyph) {
        try {
            for (int i2 = 0; i2 < 16; ++i2) {
                int line = glyph[i2];
                out.write(HEX_CHARS[line >>> 12 & 0xF]);
                out.write(HEX_CHARS[line >>> 8 & 0xF]);
                out.write(HEX_CHARS[line >>> 4 & 0xF]);
                out.write(HEX_CHARS[line & 0xF]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write24(@NotNull OutputStream out, int @NotNull [] glyph) {
        try {
            for (int i2 = 0; i2 < 16; ++i2) {
                int line = glyph[i2];
                out.write(HEX_CHARS[line >>> 20 & 0xF]);
                out.write(HEX_CHARS[line >>> 16 & 0xF]);
                out.write(HEX_CHARS[line >>> 12 & 0xF]);
                out.write(HEX_CHARS[line >>> 8 & 0xF]);
                out.write(HEX_CHARS[line >>> 4 & 0xF]);
                out.write(HEX_CHARS[line & 0xF]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write32(@NotNull OutputStream out, int @NotNull [] glyph) {
        try {
            for (int i2 = 0; i2 < 16; ++i2) {
                int line = glyph[i2];
                out.write(HEX_CHARS[line >>> 28 & 0xF]);
                out.write(HEX_CHARS[line >>> 24 & 0xF]);
                out.write(HEX_CHARS[line >>> 20 & 0xF]);
                out.write(HEX_CHARS[line >>> 16 & 0xF]);
                out.write(HEX_CHARS[line >>> 12 & 0xF]);
                out.write(HEX_CHARS[line >>> 8 & 0xF]);
                out.write(HEX_CHARS[line >>> 4 & 0xF]);
                out.write(HEX_CHARS[line & 0xF]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeCodePoint(@NotNull OutputStream out, int codePoint) {
        try {
            if (codePoint > 1048575) {
                out.write(HEX_CHARS[codePoint >>> 20 & 0xF]);
            }
            if (codePoint > 65535) {
                out.write(HEX_CHARS[codePoint >>> 16 & 0xF]);
            }
            out.write(HEX_CHARS[codePoint >>> 12 & 0xF]);
            out.write(HEX_CHARS[codePoint >>> 8 & 0xF]);
            out.write(HEX_CHARS[codePoint >>> 4 & 0xF]);
            out.write(HEX_CHARS[codePoint & 0xF]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int[] createArgbRaster(int width, int @NotNull [] glyph, int leftBorder, int rightBorder, int argb1, int argb0) {
        int rasterWidth = rightBorder - leftBorder + 1;
        int[] raster = new int[rasterWidth * 16];
        Arrays.fill(raster, argb0);
        int endX = Math.min(width, rightBorder + 1);
        for (int y = 0; y < 16; ++y) {
            int line = glyph[y];
            for (int x = leftBorder; x < endX; ++x) {
                if ((line >>> width - x - 1 & 1) != 1) continue;
                raster[y * rasterWidth + x - leftBorder] = argb1;
            }
        }
        return raster;
    }

    private static int fromHex(byte hexDigit) {
        return switch (hexDigit) {
            case 48 -> 0;
            case 49 -> 1;
            case 50 -> 2;
            case 51 -> 3;
            case 52 -> 4;
            case 53 -> 5;
            case 54 -> 6;
            case 55 -> 7;
            case 56 -> 8;
            case 57 -> 9;
            case 65, 97 -> 10;
            case 66, 98 -> 11;
            case 67, 99 -> 12;
            case 68, 100 -> 13;
            case 69, 101 -> 14;
            case 70, 102 -> 15;
            default -> throw new IllegalArgumentException("Invalid hex digit: " + hexDigit);
        };
    }

    public static int @Nullable [] findHorizontalBorders(int @NotNull [] glyph) {
        int top = -1;
        for (int i2 = 0; i2 < 16; ++i2) {
            if (glyph[i2] == 0) continue;
            top = i2;
            break;
        }
        if (top == -1) {
            return null;
        }
        int bottom = -1;
        for (int i3 = 15; i3 >= 0; --i3) {
            if (glyph[i3] == 0) continue;
            bottom = i3;
            break;
        }
        return new int[]{top, bottom};
    }

    public static int @Nullable [] findVerticalBorders(int width, int @NotNull [] glyph) {
        int left = -1;
        block0: for (int x = 0; x < width; ++x) {
            for (int y = 0; y < 16; ++y) {
                if ((glyph[y] >>> width - x - 1 & 1) != 1) continue;
                left = x;
                break block0;
            }
        }
        if (left == -1) {
            return null;
        }
        int right = -1;
        block2: for (int x = width - 1; x >= 0; --x) {
            for (int y = 0; y < 16; ++y) {
                if ((glyph[y] >>> width - x - 1 & 1) != 1) continue;
                right = x;
                break block2;
            }
        }
        return new int[]{left, right};
    }
}

