/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.serialization.json.serializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lxyz/xenondevs/nova/serialization/json/serializer/LocationSerialization;", "Lcom/google/gson/JsonSerializer;", "Lorg/bukkit/Location;", "Lcom/google/gson/JsonDeserializer;", "<init>", "()V", "serialize", "Lcom/google/gson/JsonElement;", "src", "typeOfSrc", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonSerializationContext;", "deserialize", "json", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "nova"})
public final class LocationSerialization
implements JsonSerializer<Location>,
JsonDeserializer<Location> {
    @NotNull
    public static final LocationSerialization INSTANCE = new LocationSerialization();

    private LocationSerialization() {
    }

    @NotNull
    public JsonElement serialize(@NotNull Location src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)typeOfSrc, (String)"typeOfSrc");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsonObject obj = new JsonObject();
        obj.addProperty("x", (Number)src.getX());
        obj.addProperty("y", (Number)src.getY());
        obj.addProperty("z", (Number)src.getZ());
        obj.addProperty("yaw", (Number)Float.valueOf(src.getYaw()));
        obj.addProperty("pitch", (Number)Float.valueOf(src.getPitch()));
        Object object = src.getWorld();
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        obj.addProperty("world", (String)object);
        return (JsonElement)obj;
    }

    @NotNull
    public Location deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsonObject obj = json.getAsJsonObject();
        double x = obj.getAsJsonPrimitive("x").getAsDouble();
        double y = obj.getAsJsonPrimitive("y").getAsDouble();
        double z = obj.getAsJsonPrimitive("z").getAsDouble();
        float yaw = obj.getAsJsonPrimitive("yaw").getAsFloat();
        float pitch = obj.getAsJsonPrimitive("pitch").getAsFloat();
        String worldName = obj.getAsJsonPrimitive("world").getAsString();
        return new Location(Bukkit.getWorld((String)worldName), x, y, z, yaw, pitch);
    }
}

