/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.ui.menu;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.invui.Click;
import xyz.xenondevs.invui.item.AbstractItem;
import xyz.xenondevs.invui.item.Item;
import xyz.xenondevs.invui.item.ItemBuilder;
import xyz.xenondevs.invui.item.ItemExtensionsKt;
import xyz.xenondevs.invui.item.ItemProvider;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.item.DefaultGuiItems;
import xyz.xenondevs.nova.world.item.NovaItem;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0002H\u0016J\u0006\u0010\u0011\u001a\u00020\u0012J(\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J \u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u00020\rj\b\u0012\u0004\u0012\u00020\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lxyz/xenondevs/nova/ui/menu/Canvas;", "Ljava/util/function/Supplier;", "Lxyz/xenondevs/invui/item/Item;", "canvasItem", "Lxyz/xenondevs/nova/world/item/NovaItem;", "itemResolution", "", "image", "Ljava/awt/image/BufferedImage;", "<init>", "(Lxyz/xenondevs/nova/world/item/NovaItem;ILjava/awt/image/BufferedImage;)V", "(Ljava/awt/image/BufferedImage;)V", "items", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "supplierIndex", "get", "notifyWindows", "", "modifyItemBuilder", "x", "y", "viewer", "Lorg/bukkit/entity/Player;", "itemBuilder", "Lxyz/xenondevs/invui/item/ItemBuilder;", "handleClick", "click", "Lxyz/xenondevs/invui/Click;", "CanvasPart", "nova"})
@SourceDebugExtension(value={"SMAP\nCanvas.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Canvas.kt\nxyz/xenondevs/nova/ui/menu/Canvas\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
public class Canvas
implements Supplier<Item> {
    @NotNull
    private final NovaItem canvasItem;
    private final int itemResolution;
    @NotNull
    private final BufferedImage image;
    @NotNull
    private final ArrayList<Item> items;
    private int supplierIndex;

    public Canvas(@NotNull NovaItem canvasItem, int itemResolution, @NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)canvasItem, (String)"canvasItem");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this.canvasItem = canvasItem;
        this.itemResolution = itemResolution;
        this.image = image;
        this.items = new ArrayList();
        if (!(this.image.getHeight() % this.itemResolution == 0)) {
            boolean $i$a$-require-Canvas$32 = false;
            String $i$a$-require-Canvas$32 = "Image height needs to be divisible by " + this.itemResolution;
            throw new IllegalArgumentException($i$a$-require-Canvas$32.toString());
        }
        if (!(this.image.getWidth() % this.itemResolution == 0)) {
            boolean bl = false;
            String string = "Image width needs to be divisible by " + this.itemResolution;
            throw new IllegalArgumentException(string.toString());
        }
        int n = this.image.getHeight() / this.itemResolution;
        for (int y = 0; y < n; ++y) {
            int n2 = this.image.getWidth() / this.itemResolution;
            for (int x = 0; x < n2; ++x) {
                ((Collection)this.items).add(new CanvasPart(x, y));
            }
        }
    }

    public Canvas(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this(DefaultGuiItems.INSTANCE.getCANVAS(), 18, image);
    }

    @Override
    @NotNull
    public Item get() {
        int n = this.supplierIndex;
        this.supplierIndex = n + 1;
        Item item = this.items.get(n);
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"get(...)");
        return item;
    }

    public final void notifyWindows() {
        ItemExtensionsKt.notifyWindows((Iterable)this.items);
    }

    protected void modifyItemBuilder(int x, int y, @NotNull Player viewer, @NotNull ItemBuilder itemBuilder) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        Intrinsics.checkNotNullParameter((Object)itemBuilder, (String)"itemBuilder");
    }

    protected void handleClick(int x, int y, @NotNull Click click) {
        Intrinsics.checkNotNullParameter((Object)click, (String)"click");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lxyz/xenondevs/nova/ui/menu/Canvas$CanvasPart;", "Lxyz/xenondevs/invui/item/AbstractItem;", "x", "", "y", "<init>", "(Lxyz/xenondevs/nova/ui/menu/Canvas;II)V", "colors", "", "getItemProvider", "Lxyz/xenondevs/invui/item/ItemProvider;", "viewer", "Lorg/bukkit/entity/Player;", "handleClick", "", "clickType", "Lorg/bukkit/event/inventory/ClickType;", "player", "click", "Lxyz/xenondevs/invui/Click;", "nova"})
    private final class CanvasPart
    extends AbstractItem {
        private final int x;
        private final int y;
        @NotNull
        private final int[] colors;

        public CanvasPart(int x, int y) {
            this.x = x;
            this.y = y;
            this.colors = new int[Canvas.this.itemResolution * Canvas.this.itemResolution];
        }

        @NotNull
        public ItemProvider getItemProvider(@NotNull Player viewer) {
            Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
            Canvas.this.image.getRGB(this.x * Canvas.this.itemResolution, this.y * Canvas.this.itemResolution, Canvas.this.itemResolution, Canvas.this.itemResolution, this.colors, 0, Canvas.this.itemResolution);
            ItemStack itemStack = NMSUtilsKt.unwrap(Canvas.this.canvasItem.getClientsideProvider().get()).copy();
            itemStack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), (List)new IntArrayList(this.colors)));
            ItemBuilder builder = new ItemBuilder(itemStack.asBukkitMirror());
            Canvas.this.modifyItemBuilder(this.x, this.y, viewer, builder);
            return (ItemProvider)builder;
        }

        public void handleClick(@NotNull ClickType clickType, @NotNull Player player, @NotNull Click click) {
            Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)click, (String)"click");
            Canvas.this.handleClick(this.x, this.y, click);
        }
    }
}

