/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.util.data;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nJ\u0015\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\bJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\nJ\u0015\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\bJ\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0005H\u0007J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 J\u001e\u0010\u001c\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010\"\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lxyz/xenondevs/nova/util/data/ImageUtils;", "", "<init>", "()V", "ARGB_BIT_MASKS", "", "findVerticalBorders", "Lkotlin/Pair;", "", "image", "Ljava/awt/image/BufferedImage;", "findLeftBorder", "(Ljava/awt/image/BufferedImage;)Ljava/lang/Integer;", "findRightBorder", "isColumnEmpty", "", "x", "findTopBottomBorders", "Lorg/joml/Vector2ic;", "findTopBorder", "findBottomBorder", "isRowEmpty", "y", "createImageFromArgbRaster", "width", "raster", "removeSemiTransparentPixels", "", "lerp", "from", "to", "blendFactor", "", "Ljava/awt/Color;", "copyToARGB", "nova"})
public final class ImageUtils {
    @NotNull
    public static final ImageUtils INSTANCE = new ImageUtils();
    @NotNull
    private static final int[] ARGB_BIT_MASKS;

    private ImageUtils() {
    }

    @Nullable
    public final Pair<Integer, Integer> findVerticalBorders(@NotNull BufferedImage image) {
        int right;
        int left;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        for (left = 0; left < image.getWidth() && this.isColumnEmpty(image, left); ++left) {
        }
        if (left == image.getWidth()) {
            return null;
        }
        for (right = image.getWidth() - 1; right > left && this.isColumnEmpty(image, right); --right) {
        }
        return TuplesKt.to((Object)left, (Object)right);
    }

    @Nullable
    public final Integer findLeftBorder(@NotNull BufferedImage image) {
        int x;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        for (x = 0; x < image.getWidth() && this.isColumnEmpty(image, x); ++x) {
        }
        return x != image.getWidth() ? Integer.valueOf(x) : null;
    }

    @Nullable
    public final Integer findRightBorder(@NotNull BufferedImage image) {
        int x;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        for (x = image.getWidth() - 1; x >= 0 && this.isColumnEmpty(image, x); --x) {
        }
        return x != -1 ? Integer.valueOf(x) : null;
    }

    public final boolean isColumnEmpty(@NotNull BufferedImage image, int x) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int n = image.getHeight();
        for (int y = 0; y < n; ++y) {
            if (image.getRGB(x, y) >>> 24 == 0) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public final Vector2ic findTopBottomBorders(@NotNull BufferedImage image) {
        int bottom;
        int top;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        for (top = 0; top < image.getHeight() && this.isRowEmpty(image, top); ++top) {
        }
        if (top == image.getHeight()) {
            return null;
        }
        for (bottom = image.getHeight() - 1; bottom > top && this.isRowEmpty(image, bottom); --bottom) {
        }
        return (Vector2ic)new Vector2i(top, bottom);
    }

    @Nullable
    public final Integer findTopBorder(@NotNull BufferedImage image) {
        int y;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        for (y = 0; y < image.getHeight() && this.isRowEmpty(image, y); ++y) {
        }
        return y != image.getHeight() ? Integer.valueOf(y) : null;
    }

    @Nullable
    public final Integer findBottomBorder(@NotNull BufferedImage image) {
        int y;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        for (y = image.getHeight() - 1; y >= 0 && this.isRowEmpty(image, y); --y) {
        }
        return y != -1 ? Integer.valueOf(y) : null;
    }

    public final boolean isRowEmpty(@NotNull BufferedImage image, int y) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int n = image.getWidth();
        for (int x = 0; x < n; ++x) {
            if (image.getRGB(x, y) >>> 24 == 0) continue;
            return false;
        }
        return true;
    }

    @JvmStatic
    @NotNull
    public static final BufferedImage createImageFromArgbRaster(int width, @NotNull int[] raster) {
        Intrinsics.checkNotNullParameter((Object)raster, (String)"raster");
        SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(3, width, raster.length / width, ARGB_BIT_MASKS);
        DataBufferInt db = new DataBufferInt(raster, raster.length);
        WritableRaster wr = Raster.createWritableRaster(sm, db, new Point());
        return new BufferedImage(ColorModel.getRGBdefault(), wr, false, null);
    }

    public final void removeSemiTransparentPixels(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int n = image.getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = image.getHeight();
            block4: for (int y = 0; y < n2; ++y) {
                int rgb = image.getRGB(x, y);
                int alpha = rgb >>> 24;
                switch (alpha) {
                    case 0: 
                    case 255: {
                        continue block4;
                    }
                    default: {
                        if (alpha > 127) {
                            image.setRGB(x, y, rgb | 0xFF000000);
                            continue block4;
                        }
                        image.setRGB(x, y, 0);
                    }
                }
            }
        }
    }

    @NotNull
    public final BufferedImage lerp(@NotNull BufferedImage from, @NotNull BufferedImage to, float blendFactor) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        int width = from.getWidth();
        int height = from.getHeight();
        BufferedImage result = new BufferedImage(width, height, 2);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int fromARGB = from.getRGB(x, y);
                int toARGB = to.getRGB(x, y);
                int fromA = fromARGB >>> 24 & 0xFF;
                int fromR = fromARGB >>> 16 & 0xFF;
                int fromG = fromARGB >>> 8 & 0xFF;
                int fromB = fromARGB & 0xFF;
                int toA = toARGB >>> 24 & 0xFF;
                int toR = toARGB >>> 16 & 0xFF;
                int toG = toARGB >>> 8 & 0xFF;
                int toB = toARGB & 0xFF;
                int resultA = (int)((float)fromA + (float)(toA - fromA) * blendFactor);
                int resultR = (int)((float)fromR + (float)(toR - fromR) * blendFactor);
                int resultG = (int)((float)fromG + (float)(toG - fromG) * blendFactor);
                int resultB = (int)((float)fromB + (float)(toB - fromB) * blendFactor);
                int resultARGB = resultA << 24 | resultR << 16 | resultG << 8 | resultB;
                result.setRGB(x, y, resultARGB);
            }
        }
        return result;
    }

    @NotNull
    public final Color lerp(@NotNull Color from, @NotNull Color to, float blendFactor) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        int fromA = from.getAlpha();
        int fromR = from.getRed();
        int fromG = from.getGreen();
        int fromB = from.getBlue();
        int toA = to.getAlpha();
        int toR = to.getRed();
        int toG = to.getGreen();
        int toB = to.getBlue();
        int resultA = (int)((float)fromA + (float)(toA - fromA) * blendFactor);
        int resultR = (int)((float)fromR + (float)(toR - fromR) * blendFactor);
        int resultG = (int)((float)fromG + (float)(toG - fromG) * blendFactor);
        int resultB = (int)((float)fromB + (float)(toB - fromB) * blendFactor);
        return new Color(resultR, resultG, resultB, resultA);
    }

    @NotNull
    public final BufferedImage copyToARGB(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        BufferedImage copy = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D graphics = copy.createGraphics();
        graphics.drawImage((Image)image, 0, 0, null);
        graphics.dispose();
        return copy;
    }

    static {
        int[] nArray = new int[]{0xFF0000, 65280, 255, -16777216};
        ARGB_BIT_MASKS = nArray;
    }
}

