/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.util.data;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.internal.HashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.addon.Addon;
import xyz.xenondevs.nova.addon.AddonBootstrapper;
import xyz.xenondevs.nova.config.PermanentStorage;
import xyz.xenondevs.nova.initialize.DisableFun;
import xyz.xenondevs.nova.resources.ResourcePath;
import xyz.xenondevs.nova.util.data.BinaryUtilsKt;
import xyz.xenondevs.nova.util.data.HashUtils;
import xyz.xenondevs.nova.util.data.UpdatableFileKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u000bJ*\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00120\u0011J\u0016\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eJ\b\u0010\u0016\u001a\u00020\tH\u0003J\u0016\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000eJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u000eJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0018\u001a\u00020\u000eJ\u000e\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000eJ\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\f\u0010\u001f\u001a\u00020\u001a*\u00020\u000eH\u0002J\f\u0010\u001f\u001a\u00020\u001a*\u00020\u001aH\u0002R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lxyz/xenondevs/nova/util/data/UpdatableFile;", "", "<init>", "()V", "fileHashes", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "extractIdNamedFromAllAddons", "", "dirName", "extractIdNamedFromAllAddons$nova", "extractAll", "fromDir", "Ljava/nio/file/Path;", "toDir", "filter", "Lkotlin/Function1;", "", "load", "from", "to", "disable", "storeHash", "file", "hash", "", "getStoredHashString", "getStoredHash", "removeStoredHash", "id", "generateMD5Hash", "nova"})
@SourceDebugExtension(value={"SMAP\nUpdatableFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdatableFile.kt\nxyz/xenondevs/nova/util/data/UpdatableFile\n+ 2 IOUtils.kt\nxyz/xenondevs/nova/util/data/IOUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 PermanentStorage.kt\nxyz/xenondevs/nova/config/PermanentStorage\n+ 6 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n*L\n1#1,122:1\n64#2,3:123\n100#2:133\n101#2:135\n75#2:138\n1#3:126\n1#3:132\n1#3:137\n1321#4,2:127\n1321#4,2:129\n82#5:131\n85#5:136\n42#6:134\n80#6:139\n*S KotlinDebug\n*F\n+ 1 UpdatableFile.kt\nxyz/xenondevs/nova/util/data/UpdatableFile\n*L\n30#1:123,3\n92#1:133\n92#1:135\n26#1:138\n30#1:126\n92#1:132\n26#1:137\n44#1:127,2\n55#1:129,2\n92#1:131\n26#1:136\n92#1:134\n26#1:139\n*E\n"})
public final class UpdatableFile {
    @NotNull
    public static final UpdatableFile INSTANCE;
    @NotNull
    private static final HashMap<String, String> fileHashes;

    private UpdatableFile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extractIdNamedFromAllAddons$nova(@NotNull String dirName) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        for (Addon addon : AddonBootstrapper.getAddons()) {
            Path $this$useZip_u24default$iv = addon.getFile();
            boolean create$iv = false;
            boolean $i$f$useZip = false;
            Map env$iv = MapsKt.emptyMap();
            Closeable closeable = FileSystems.newFileSystem($this$useZip_u24default$iv, env$iv);
            Throwable throwable = null;
            try {
                FileSystem it$iv = (FileSystem)closeable;
                boolean bl = false;
                Iterable<Path> iterable = it$iv.getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                Object object = CollectionsKt.first(iterable);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                Path zip = (Path)object;
                boolean bl2 = false;
                Path path = zip.resolve(dirName);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                Path path2 = addon.getDataFolder().resolve(dirName);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                INSTANCE.extractAll(path, path2, (Function1<? super Path, Boolean>)((Function1)UpdatableFile::extractIdNamedFromAllAddons$lambda$0$0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    public final void extractAll(@NotNull Path fromDir, @NotNull Path toDir, @NotNull Function1<? super Path, Boolean> filter) {
        Sequence $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)fromDir, (String)"fromDir");
        Intrinsics.checkNotNullParameter((Object)toDir, (String)"toDir");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        HashSet<Path> existingPaths = new HashSet<Path>();
        Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)PathsKt.walk((Path)fromDir, (PathWalkOption[])new PathWalkOption[0]), UpdatableFile::extractAll$lambda$0), filter);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path from = (Path)element$iv;
            boolean bl = false;
            String relativePath = PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)from, (Path)fromDir));
            Path to = toDir.resolve(relativePath);
            Intrinsics.checkNotNull((Object)to);
            INSTANCE.load(from, to);
            existingPaths.add(to);
        }
        $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)PathsKt.walk((Path)toDir, (PathWalkOption[])new PathWalkOption[0]), UpdatableFile::extractAll$lambda$2), filter);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path path = (Path)element$iv;
            boolean bl = false;
            if (existingPaths.contains(path) || !Arrays.equals(INSTANCE.generateMD5Hash(path), INSTANCE.getStoredHash(path))) continue;
            Files.delete(path);
            INSTANCE.removeStoredHash(path);
        }
    }

    public final void load(@NotNull Path from, @NotNull Path to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        byte[] storedHash = this.getStoredHash(to);
        Path path = to;
        Object[] objectArray = new LinkOption[]{};
        if (Files.exists(path, Arrays.copyOf(objectArray, objectArray.length)) && storedHash != null) {
            byte[] existingFileHash = this.generateMD5Hash(to);
            objectArray = existingFileHash;
            if (Arrays.equals((byte[])objectArray, storedHash)) {
                byte[] byArray = Files.readAllBytes(from);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                byte[] newFileData = byArray;
                byte[] newFileHash = this.generateMD5Hash(newFileData);
                if (!Arrays.equals(existingFileHash, newFileHash)) {
                    Path path2 = to;
                    OpenOption[] openOptionArray = new OpenOption[]{};
                    Files.write(path2, newFileData, Arrays.copyOf(openOptionArray, openOptionArray.length));
                    this.storeHash(to, newFileHash);
                }
            }
        } else if (storedHash == null) {
            Path path3 = to.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getParent(...)");
            path = path3;
            objectArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, (FileAttribute[])Arrays.copyOf(objectArray, objectArray.length)), (String)"createDirectories(...)");
            path = from;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray2 = copyOptionArray;
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path, to, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
            this.storeHash(to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @DisableFun
    private final void disable() {
        void $this$writeJson$iv$iv;
        void key$iv;
        void this_$iv;
        PermanentStorage permanentStorage = PermanentStorage.INSTANCE;
        String string = "updatable_file_hashes";
        HashMap<String, String> data$iv = fileHashes;
        boolean $i$f$store = false;
        Path path = this_$iv.getPath((String)key$iv);
        Object it$iv = path;
        boolean bl = false;
        PathsKt.createParentDirectories((Path)it$iv, (FileAttribute[])new FileAttribute[0]);
        it$iv = data$iv;
        Json json$iv$iv = this_$iv.getJSON();
        boolean $i$f$writeJson = false;
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream((Path)$this$writeJson$iv$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        Closeable closeable = outputStream;
        Throwable throwable = null;
        try {
            void value$iv$iv$iv;
            void $this$encodeToStream$iv$iv$iv;
            void value$iv$iv;
            OutputStream it$iv$iv = (OutputStream)closeable;
            boolean bl2 = false;
            Json json = json$iv$iv;
            void var14_17 = value$iv$iv;
            OutputStream stream$iv$iv$iv = it$iv$iv;
            boolean $i$f$encodeToStream = false;
            $this$encodeToStream$iv$iv$iv.getSerializersModule();
            JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv$iv$iv, (SerializationStrategy)((SerializationStrategy)new HashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE)), (Object)value$iv$iv$iv, (OutputStream)stream$iv$iv$iv);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void storeHash(@NotNull Path file, @NotNull byte[] hash) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        ((Map)fileHashes).put(PathsKt.getInvariantSeparatorsPathString((Path)file), BinaryUtilsKt.encodeBase64(hash));
    }

    public final void storeHash(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ((Map)fileHashes).put(this.id(file), BinaryUtilsKt.encodeBase64(this.generateMD5Hash(file)));
    }

    @Nullable
    public final String getStoredHashString(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return fileHashes.get(this.id(file));
    }

    @Nullable
    public final byte[] getStoredHash(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = this.getStoredHashString(file);
        return (byte[])(string != null ? BinaryUtilsKt.decodeBase64(string) : null);
    }

    public final void removeStoredHash(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ((Map)fileHashes).remove(this.id(file));
    }

    private final String id(Path file) {
        Path path = UpdatableFileKt.access$getPLUGINS_DIR$p();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"access$getPLUGINS_DIR$p(...)");
        return PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)file, (Path)path));
    }

    private final byte[] generateMD5Hash(Path $this$generateMD5Hash) {
        return HashUtils.INSTANCE.getFileHash($this$generateMD5Hash, "MD5");
    }

    private final byte[] generateMD5Hash(byte[] $this$generateMD5Hash) {
        return HashUtils.INSTANCE.getHash($this$generateMD5Hash, "MD5");
    }

    private static final boolean extractIdNamedFromAllAddons$lambda$0$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ResourcePath.Companion.isValidPath(PathsKt.getName((Path)it));
    }

    private static final boolean extractAll$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final boolean extractAll$lambda$2(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static {
        HashMap hashMap;
        Object object;
        void this_$iv;
        Path path;
        INSTANCE = new UpdatableFile();
        PermanentStorage permanentStorage = PermanentStorage.INSTANCE;
        String key$iv = "updatable_file_hashes";
        boolean $i$f$retrieve = false;
        Path it$iv = path = this_$iv.getPath(key$iv);
        boolean bl = false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        Path path2 = Files.exists(it$iv, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path : null;
        if (path2 != null) {
            void $this$readJson$iv$iv;
            path = path2;
            Json json$iv$iv = this_$iv.getJSON();
            boolean $i$f$readJson = false;
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream((Path)$this$readJson$iv$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                void $this$decodeFromStream$iv$iv$iv;
                InputStream it$iv$iv = (InputStream)closeable;
                boolean bl2 = false;
                Json json = json$iv$iv;
                InputStream stream$iv$iv$iv = it$iv$iv;
                boolean $i$f$decodeFromStream = false;
                $this$decodeFromStream$iv$iv$iv.getSerializersModule();
                Object object2 = JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv$iv$iv, (DeserializationStrategy)((DeserializationStrategy)BuiltinSerializersKt.getNullable((KSerializer)new HashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE))), (InputStream)stream$iv$iv$iv);
                object = object2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            object = null;
        }
        if ((hashMap = (HashMap)object) == null) {
            hashMap = new HashMap();
        }
        fileHashes = hashMap;
    }
}

