/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.ChunkPos;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.format.WorldDataManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u00107\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005J\u0018\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020:2\b\b\u0002\u0010;\u001a\u00020\u0005J\u001e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AJ&\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010C\u001a\u00020D2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AJ\u001e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020E2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AJ\b\u0010F\u001a\u00020?H\u0016J\t\u0010G\u001a\u00020\u0003H\u00c6\u0003J\t\u0010H\u001a\u00020\u0005H\u00c6\u0003J\t\u0010I\u001a\u00020\u0005H\u00c6\u0003J\t\u0010J\u001a\u00020\u0005H\u00c6\u0003J1\u0010K\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010L\u001a\u00020M2\b\u0010N\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010O\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0013\u0010$\u001a\u0004\u0018\u00010%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0013\u0010,\u001a\u0004\u0018\u00010-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u0002018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u0006P"}, d2={"Lxyz/xenondevs/nova/world/BlockPos;", "", "world", "Lorg/bukkit/World;", "x", "", "y", "z", "<init>", "(Lorg/bukkit/World;III)V", "getWorld", "()Lorg/bukkit/World;", "getX", "()I", "getY", "getZ", "nmsPos", "Lnet/minecraft/core/BlockPos;", "getNmsPos", "()Lnet/minecraft/core/BlockPos;", "location", "Lorg/bukkit/Location;", "getLocation", "()Lorg/bukkit/Location;", "vector3i", "Lorg/joml/Vector3i;", "getVector3i", "()Lorg/joml/Vector3i;", "block", "Lorg/bukkit/block/Block;", "getBlock", "()Lorg/bukkit/block/Block;", "blockState", "Lorg/bukkit/block/BlockState;", "getBlockState", "()Lorg/bukkit/block/BlockState;", "novaBlockState", "Lxyz/xenondevs/nova/world/block/state/NovaBlockState;", "getNovaBlockState", "()Lxyz/xenondevs/nova/world/block/state/NovaBlockState;", "nmsBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "getNmsBlockState", "()Lnet/minecraft/world/level/block/state/BlockState;", "nmsBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "getNmsBlockEntity", "()Lnet/minecraft/world/level/block/entity/BlockEntity;", "chunkPos", "Lxyz/xenondevs/nova/world/ChunkPos;", "getChunkPos", "()Lxyz/xenondevs/nova/world/ChunkPos;", "below", "getBelow", "()Lxyz/xenondevs/nova/world/BlockPos;", "add", "advance", "face", "Lorg/bukkit/block/BlockFace;", "step", "playSound", "", "sound", "", "volume", "", "pitch", "category", "Lorg/bukkit/SoundCategory;", "Lorg/bukkit/Sound;", "toString", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "nova"})
public final class BlockPos {
    @NotNull
    private final World world;
    private final int x;
    private final int y;
    private final int z;

    public BlockPos(@NotNull World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getZ() {
        return this.z;
    }

    @NotNull
    public final net.minecraft.core.BlockPos getNmsPos() {
        return new net.minecraft.core.BlockPos(this.x, this.y, this.z);
    }

    @NotNull
    public final Location getLocation() {
        return LocationUtilsKt.Location$default(this.world, this.x, this.y, this.z, null, null, 48, null);
    }

    @NotNull
    public final Vector3i getVector3i() {
        return new Vector3i(this.x, this.y, this.z);
    }

    @NotNull
    public final Block getBlock() {
        Block block = this.world.getBlockAt(this.x, this.y, this.z);
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlockAt(...)");
        return block;
    }

    @NotNull
    public final BlockState getBlockState() {
        BlockState blockState = this.world.getBlockState(this.x, this.y, this.z);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        return blockState;
    }

    @Nullable
    public final NovaBlockState getNovaBlockState() {
        return WorldDataManager.INSTANCE.getBlockState(this);
    }

    @NotNull
    public final net.minecraft.world.level.block.state.BlockState getNmsBlockState() {
        net.minecraft.world.level.block.state.BlockState blockState = NMSUtilsKt.getServerLevel(this.world).getBlockState(this.getNmsPos());
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        return blockState;
    }

    @Nullable
    public final BlockEntity getNmsBlockEntity() {
        return NMSUtilsKt.getServerLevel(this.world).getBlockEntity(this.getNmsPos());
    }

    @NotNull
    public final ChunkPos getChunkPos() {
        UUID uUID = this.world.getUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUID(...)");
        return new ChunkPos(uUID, this.x >> 4, this.z >> 4);
    }

    @NotNull
    public final BlockPos getBelow() {
        return this.add(0, -1, 0);
    }

    @NotNull
    public final BlockPos add(int x, int y, int z) {
        return new BlockPos(this.world, this.x + x, this.y + y, this.z + z);
    }

    @NotNull
    public final BlockPos advance(@NotNull BlockFace face, int step) {
        Intrinsics.checkNotNullParameter((Object)face, (String)"face");
        return this.add(face.getModX() * step, face.getModY() * step, face.getModZ() * step);
    }

    public static /* synthetic */ BlockPos advance$default(BlockPos blockPos, BlockFace blockFace, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return blockPos.advance(blockFace, n);
    }

    public final void playSound(@NotNull String sound, float volume, float pitch) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        this.world.playSound(new Location(this.world, (double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5), sound, volume, pitch);
    }

    public final void playSound(@NotNull String sound, @NotNull SoundCategory category, float volume, float pitch) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        this.world.playSound(new Location(this.world, (double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5), sound, category, volume, pitch);
    }

    public final void playSound(@NotNull Sound sound, float volume, float pitch) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        this.world.playSound(new Location(this.world, (double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5), sound, volume, pitch);
    }

    @NotNull
    public String toString() {
        return "BlockPos(world=" + this.world.getName() + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    @NotNull
    public final World component1() {
        return this.world;
    }

    public final int component2() {
        return this.x;
    }

    public final int component3() {
        return this.y;
    }

    public final int component4() {
        return this.z;
    }

    @NotNull
    public final BlockPos copy(@NotNull World world, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return new BlockPos(world, x, y, z);
    }

    public static /* synthetic */ BlockPos copy$default(BlockPos blockPos, World world, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            world = blockPos.world;
        }
        if ((n4 & 2) != 0) {
            n = blockPos.x;
        }
        if ((n4 & 4) != 0) {
            n2 = blockPos.y;
        }
        if ((n4 & 8) != 0) {
            n3 = blockPos.z;
        }
        return blockPos.copy(world, n, n2, n3);
    }

    public int hashCode() {
        int result = this.world.hashCode();
        result = result * 31 + Integer.hashCode(this.x);
        result = result * 31 + Integer.hashCode(this.y);
        result = result * 31 + Integer.hashCode(this.z);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BlockPos)) {
            return false;
        }
        BlockPos blockPos = (BlockPos)other;
        if (!Intrinsics.areEqual((Object)this.world, (Object)blockPos.world)) {
            return false;
        }
        if (this.x != blockPos.x) {
            return false;
        }
        if (this.y != blockPos.y) {
            return false;
        }
        return this.z == blockPos.z;
    }
}

