/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.hitbox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.xenondevs.nova.world.block.hitbox.HitboxManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003BI\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020+J\u0013\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00028\u0000\u00a2\u0006\u0002\u0010/J\u0013\u00100\u001a\u00020+2\u0006\u0010.\u001a\u00028\u0001\u00a2\u0006\u0002\u0010/J\u0011\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0086\u0002J\u0010\u00105\u001a\u0004\u0018\u0001062\u0006\u00103\u001a\u000207R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u001a\u0010\u000b\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\r\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0019\"\u0004\b\u001d\u0010\u001bR\u001a\u0010\u000e\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0019\"\u0004\b\u001f\u0010\u001bR\u001e\u0010 \u001a\u0012\u0012\u0004\u0012\u00028\u00000!j\b\u0012\u0004\u0012\u00028\u0000`\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001e\u0010'\u001a\u0012\u0012\u0004\u0012\u00028\u00010!j\b\u0012\u0004\u0012\u00028\u0001`\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010$8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010&\u00a8\u00068"}, d2={"Lxyz/xenondevs/nova/world/block/hitbox/Hitbox;", "L", "R", "", "world", "Lorg/bukkit/World;", "baseCenter", "Lorg/joml/Vector3fc;", "center", "from", "to", "xWidth", "", "zWidth", "height", "<init>", "(Lorg/bukkit/World;Lorg/joml/Vector3fc;Lorg/joml/Vector3fc;Lorg/joml/Vector3fc;Lorg/joml/Vector3fc;FFF)V", "getWorld", "()Lorg/bukkit/World;", "getBaseCenter", "()Lorg/joml/Vector3fc;", "getCenter", "getFrom", "getTo", "getXWidth", "()F", "setXWidth", "(F)V", "getZWidth", "setZWidth", "getHeight", "setHeight", "_leftClickHandlers", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "leftClickHandlers", "", "getLeftClickHandlers", "()Ljava/util/List;", "_rightClickHandlers", "rightClickHandlers", "getRightClickHandlers", "register", "", "remove", "addLeftClickHandler", "handler", "(Ljava/lang/Object;)V", "addRightClickHandler", "contains", "", "location", "Lorg/bukkit/Location;", "determineBlockFace", "Lorg/bukkit/block/BlockFace;", "Lorg/joml/Vector3f;", "nova"})
public abstract class Hitbox<L, R> {
    @NotNull
    private final World world;
    @NotNull
    private final Vector3fc baseCenter;
    @NotNull
    private final Vector3fc center;
    @NotNull
    private final Vector3fc from;
    @NotNull
    private final Vector3fc to;
    private float xWidth;
    private float zWidth;
    private float height;
    @NotNull
    private final ArrayList<L> _leftClickHandlers;
    @NotNull
    private final ArrayList<R> _rightClickHandlers;

    public Hitbox(@NotNull World world, @NotNull Vector3fc baseCenter, @NotNull Vector3fc center, @NotNull Vector3fc from, @NotNull Vector3fc to, float xWidth, float zWidth, float height) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)baseCenter, (String)"baseCenter");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.world = world;
        this.baseCenter = baseCenter;
        this.center = center;
        this.from = from;
        this.to = to;
        this.xWidth = xWidth;
        this.zWidth = zWidth;
        this.height = height;
        this._leftClickHandlers = new ArrayList(1);
        this._rightClickHandlers = new ArrayList(1);
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    @NotNull
    public final Vector3fc getBaseCenter() {
        return this.baseCenter;
    }

    @NotNull
    public final Vector3fc getCenter() {
        return this.center;
    }

    @NotNull
    public final Vector3fc getFrom() {
        return this.from;
    }

    @NotNull
    public final Vector3fc getTo() {
        return this.to;
    }

    protected final float getXWidth() {
        return this.xWidth;
    }

    protected final void setXWidth(float f) {
        this.xWidth = f;
    }

    protected final float getZWidth() {
        return this.zWidth;
    }

    protected final void setZWidth(float f) {
        this.zWidth = f;
    }

    protected final float getHeight() {
        return this.height;
    }

    protected final void setHeight(float f) {
        this.height = f;
    }

    @NotNull
    public final List<L> getLeftClickHandlers() {
        return this._leftClickHandlers;
    }

    @NotNull
    public final List<R> getRightClickHandlers() {
        return this._rightClickHandlers;
    }

    public final void register() {
        HitboxManager.INSTANCE.registerHitbox$nova(this);
    }

    public final void remove() {
        HitboxManager.INSTANCE.removeHitbox$nova(this);
    }

    public final void addLeftClickHandler(L handler) {
        ((Collection)this._leftClickHandlers).add(handler);
    }

    public final void addRightClickHandler(R handler) {
        ((Collection)this._rightClickHandlers).add(handler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean contains(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (!Intrinsics.areEqual((Object)location.getWorld(), (Object)this.world)) return false;
        float f = this.from.x();
        float f2 = this.to.x();
        double d = location.getX();
        if (!((double)f <= d)) return false;
        if (!(d <= (double)f2)) return false;
        boolean bl = true;
        if (!bl) return false;
        f = this.from.y();
        f2 = this.to.y();
        d = location.getY();
        if (!((double)f <= d)) return false;
        if (!(d <= (double)f2)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        f = this.from.z();
        f2 = this.to.z();
        d = location.getZ();
        if (!((double)f <= d)) return false;
        if (!(d <= (double)f2)) return false;
        return true;
    }

    @Nullable
    public final BlockFace determineBlockFace(@NotNull Vector3f location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return location.y == 0.0f ? BlockFace.DOWN : (Math.abs(location.y - this.height) < 1.0E-4f ? BlockFace.UP : (Math.abs(location.x + this.xWidth / (float)2) < 1.0E-4f ? BlockFace.WEST : (Math.abs(location.x - this.xWidth / (float)2) < 1.0E-4f ? BlockFace.EAST : (Math.abs(location.z + this.zWidth / (float)2) < 1.0E-4f ? BlockFace.NORTH : (Math.abs(location.z - this.zWidth / (float)2) < 1.0E-4f ? BlockFace.SOUTH : null)))));
    }
}

