/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.hitbox;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.xenondevs.nova.util.LocationUtilsKt;
import xyz.xenondevs.nova.world.block.hitbox.PhysicalHitbox;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u00a8\u0006\u0005"}, d2={"PhysicalHitbox", "Lxyz/xenondevs/nova/world/block/hitbox/PhysicalHitbox;", "from", "Lorg/bukkit/Location;", "to", "nova"})
@SourceDebugExtension(value={"SMAP\nPhysicalHitbox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicalHitbox.kt\nxyz/xenondevs/nova/world/block/hitbox/PhysicalHitboxKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class PhysicalHitboxKt {
    @NotNull
    public static final PhysicalHitbox PhysicalHitbox(@NotNull Location from, @NotNull Location to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (!(from.getWorld() != null && Intrinsics.areEqual((Object)from.getWorld(), (Object)to.getWorld()))) {
            boolean $i$a$-require-PhysicalHitboxKt$PhysicalHitbox$62 = false;
            String $i$a$-require-PhysicalHitboxKt$PhysicalHitbox$62 = "from and to must be in the same world";
            throw new IllegalArgumentException($i$a$-require-PhysicalHitboxKt$PhysicalHitbox$62.toString());
        }
        if (!(from.getX() < to.getX())) {
            boolean $i$a$-require-PhysicalHitboxKt$PhysicalHitbox$72 = false;
            String $i$a$-require-PhysicalHitboxKt$PhysicalHitbox$72 = "from.x must be smaller than to.x";
            throw new IllegalArgumentException($i$a$-require-PhysicalHitboxKt$PhysicalHitbox$72.toString());
        }
        if (!(from.getY() < to.getY())) {
            boolean $i$a$-require-PhysicalHitboxKt$PhysicalHitbox$82 = false;
            String $i$a$-require-PhysicalHitboxKt$PhysicalHitbox$82 = "from.y must be smaller than to.y";
            throw new IllegalArgumentException($i$a$-require-PhysicalHitboxKt$PhysicalHitbox$82.toString());
        }
        if (!(from.getZ() < to.getZ())) {
            boolean $i$a$-require-PhysicalHitboxKt$PhysicalHitbox$92 = false;
            String $i$a$-require-PhysicalHitboxKt$PhysicalHitbox$92 = "from.z must be smaller than to.z";
            throw new IllegalArgumentException($i$a$-require-PhysicalHitboxKt$PhysicalHitbox$92.toString());
        }
        Vector3f fromVec = LocationUtilsKt.toVector3f(from);
        Vector3f toVec = LocationUtilsKt.toVector3f(to);
        float width = toVec.x - fromVec.x;
        if (!(width == toVec.z - fromVec.z)) {
            boolean $i$a$-require-PhysicalHitboxKt$PhysicalHitbox$102 = false;
            String $i$a$-require-PhysicalHitboxKt$PhysicalHitbox$102 = "The hitbox base area must be a square";
            throw new IllegalArgumentException($i$a$-require-PhysicalHitboxKt$PhysicalHitbox$102.toString());
        }
        float height = toVec.y - fromVec.y;
        Vector3f baseCenter = new Vector3f(fromVec.x + width / 2.0f, fromVec.y, fromVec.z + width / 2.0f);
        Vector3f center = new Vector3f(fromVec.x + width / 2.0f, fromVec.y + height / 2.0f, fromVec.z + width / 2.0f);
        World world = from.getWorld();
        Intrinsics.checkNotNull((Object)world);
        return new PhysicalHitbox(world, (Vector3fc)baseCenter, (Vector3fc)center, (Vector3fc)fromVec, (Vector3fc)toVec, width, width, height);
    }
}

