/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.logic.interact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.context.Context;
import xyz.xenondevs.nova.context.intention.ContextIntention;
import xyz.xenondevs.nova.context.intention.DefaultContextIntentions;
import xyz.xenondevs.nova.context.param.DefaultContextParamTypes;
import xyz.xenondevs.nova.initialize.InitFun;
import xyz.xenondevs.nova.initialize.InternalInit;
import xyz.xenondevs.nova.initialize.InternalInitStage;
import xyz.xenondevs.nova.integration.protection.ProtectionManager;
import xyz.xenondevs.nova.network.event.PacketListener;
import xyz.xenondevs.nova.network.event.PacketListenerKt;
import xyz.xenondevs.nova.util.BlockUtils;
import xyz.xenondevs.nova.util.EventUtilsKt;
import xyz.xenondevs.nova.world.BlockPos;
import xyz.xenondevs.nova.world.BlockPosKt;
import xyz.xenondevs.nova.world.block.NovaBlock;
import xyz.xenondevs.nova.world.block.state.NovaBlockState;
import xyz.xenondevs.nova.world.format.WorldDataManager;
import xyz.xenondevs.nova.world.player.WrappedPlayerInteractEvent;

@InternalInit(stage=InternalInitStage.POST_WORLD, dependsOn={WorldDataManager.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0003J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0003J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u000eH\u0003J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0010H\u0003J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0012H\u0003J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0014H\u0003J\u0016\u0010\u0015\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u00a8\u0006\u0019"}, d2={"Lxyz/xenondevs/nova/world/block/logic/interact/BlockInteracting;", "Lorg/bukkit/event/Listener;", "Lxyz/xenondevs/nova/network/event/PacketListener;", "<init>", "()V", "init", "", "handleInteract", "wrappedEvent", "Lxyz/xenondevs/nova/world/player/WrappedPlayerInteractEvent;", "handlePistonExtend", "event", "Lorg/bukkit/event/block/BlockPistonExtendEvent;", "handlePistonRetract", "Lorg/bukkit/event/block/BlockPistonRetractEvent;", "handleEntityChangeBlock", "Lorg/bukkit/event/entity/EntityChangeBlockEvent;", "handleEntityExplosion", "Lorg/bukkit/event/entity/EntityExplodeEvent;", "handleBlockExplosion", "Lorg/bukkit/event/block/BlockExplodeEvent;", "handleExplosion", "blockList", "", "Lorg/bukkit/block/Block;", "nova"})
@SourceDebugExtension(value={"SMAP\nBlockInteracting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockInteracting.kt\nxyz/xenondevs/nova/world/block/logic/interact/BlockInteracting\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1761#2,3:113\n1761#2,3:116\n774#2:119\n865#2,2:120\n1869#2,2:122\n*S KotlinDebug\n*F\n+ 1 BlockInteracting.kt\nxyz/xenondevs/nova/world/block/logic/interact/BlockInteracting\n*L\n74#1:113,3\n79#1:116,3\n100#1:119\n100#1:120,2\n102#1:122,2\n*E\n"})
public final class BlockInteracting
implements Listener,
PacketListener {
    @NotNull
    public static final BlockInteracting INSTANCE = new BlockInteracting();

    private BlockInteracting() {
    }

    @InitFun
    private final void init() {
        EventUtilsKt.registerEvents(this);
        PacketListenerKt.registerPacketListener(this);
    }

    @EventHandler(priority=EventPriority.LOW)
    public final void handleInteract(@NotNull WrappedPlayerInteractEvent wrappedEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)wrappedEvent), (String)"wrappedEvent");
        if (wrappedEvent.getActionPerformed()) {
            return;
        }
        PlayerInteractEvent event = wrappedEvent.getEvent();
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Block block = event.getClickedBlock();
            Intrinsics.checkNotNull((Object)block);
            BlockPos pos = BlockPosKt.getPos(block);
            NovaBlockState blockState = WorldDataManager.INSTANCE.getBlockState(pos);
            if (blockState != null && ProtectionManager.INSTANCE.canUseBlock(player2, event.getItem(), pos)) {
                NovaBlock block2 = blockState.getBlock();
                Context<ContextIntention> ctx = Context.Companion.intention((ContextIntention)DefaultContextIntentions.BlockInteract.INSTANCE).param(DefaultContextParamTypes.INSTANCE.getBLOCK_POS(), pos).param(DefaultContextParamTypes.INSTANCE.getBLOCK_TYPE_NOVA(), block2).param(DefaultContextParamTypes.INSTANCE.getSOURCE_ENTITY(), player2).param(DefaultContextParamTypes.INSTANCE.getCLICKED_BLOCK_FACE(), event.getBlockFace()).param(DefaultContextParamTypes.INSTANCE.getINTERACTION_HAND(), event.getHand()).param(DefaultContextParamTypes.INSTANCE.getINTERACTION_ITEM_STACK(), event.getItem()).build();
                boolean actionPerformed = block2.handleInteract(pos, blockState, ctx);
                event.setCancelled(actionPerformed);
                wrappedEvent.setActionPerformed(actionPerformed);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private final void handlePistonExtend(BlockPistonExtendEvent event) {
        boolean bl;
        block4: {
            List list = event.getBlocks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBlocks(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Block it = (Block)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!(WorldDataManager.INSTANCE.getBlockState(BlockPosKt.getPos(it)) != null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private final void handlePistonRetract(BlockPistonRetractEvent event) {
        boolean bl;
        block4: {
            List list = event.getBlocks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBlocks(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Block it = (Block)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!(WorldDataManager.INSTANCE.getBlockState(BlockPosKt.getPos(it)) != null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private final void handleEntityChangeBlock(EntityChangeBlockEvent event) {
        EntityType entityType = event.getEntityType();
        Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"getEntityType(...)");
        EntityType type = entityType;
        if (type == EntityType.SILVERFISH || type == EntityType.ENDERMAN) {
            Block block = event.getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
            if (WorldDataManager.INSTANCE.getBlockState(BlockPosKt.getPos(block)) != null) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private final void handleEntityExplosion(EntityExplodeEvent event) {
        if (event.getEntityType() == EntityType.WIND_CHARGE) {
            return;
        }
        List list = event.blockList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"blockList(...)");
        this.handleExplosion(list);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private final void handleBlockExplosion(BlockExplodeEvent event) {
        List list = event.blockList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"blockList(...)");
        this.handleExplosion(list);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleExplosion(List<Block> blockList) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = blockList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Block it = (Block)element$iv$iv;
            boolean bl = false;
            if (!(WorldDataManager.INSTANCE.getBlockState(BlockPosKt.getPos(it)) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List novaBlocks = (List)destination$iv$iv;
        blockList.removeAll(novaBlocks);
        Iterable $this$forEach$iv = novaBlocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Block it = (Block)element$iv;
            boolean bl = false;
            Context<ContextIntention> ctx = Context.Companion.intention((ContextIntention)DefaultContextIntentions.BlockBreak.INSTANCE).param(DefaultContextParamTypes.INSTANCE.getBLOCK_POS(), BlockPosKt.getPos(it)).param(DefaultContextParamTypes.INSTANCE.getBLOCK_BREAK_EFFECTS(), false).param(DefaultContextParamTypes.INSTANCE.getBLOCK_DROPS(), true).build();
            BlockUtils.INSTANCE.breakBlockNaturally(ctx);
        }
    }
}

