/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.block.tileentity.network.type.item.channel;

import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.util.RoundRobinCounter;
import xyz.xenondevs.nova.world.block.tileentity.network.type.item.channel.FilteredNetworkedInventory;
import xyz.xenondevs.nova.world.block.tileentity.network.type.item.inventory.NetworkedInventory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0000\u0018\u00002\u00020\u0001BK\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\b\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0013Ji\u0010(\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u00132\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00172\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u00170\u00172\u0006\u0010+\u001a\u00020\u00182\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u00a2\u0006\u0002\u0010-J\u0016\u0010.\u001a\u00020\u001d2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002J3\u0010/\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u00062\f\u00102\u001a\b\u0012\u0004\u0012\u00020 0\u0017H\u0002\u00a2\u0006\u0002\u00103R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u001d\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u001c\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u001c\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00170\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR.\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u00170\u00170\u0017X\u0086.\u00a2\u0006\u0010\n\u0002\u0010%\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u00064"}, d2={"Lxyz/xenondevs/nova/world/block/tileentity/network/type/item/channel/ItemDistributor;", "", "providers", "", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/item/inventory/NetworkedInventory;", "filteredProviders", "Lxyz/xenondevs/nova/world/block/tileentity/network/type/item/channel/FilteredNetworkedInventory;", "providerLevels", "", "consumerLevels", "<init>", "(Ljava/util/Collection;Ljava/util/Collection;Ljava/util/List;Ljava/util/List;)V", "getProviders", "()Ljava/util/Collection;", "getFilteredProviders", "getProviderLevels", "()Ljava/util/List;", "getConsumerLevels", "levels", "", "getLevels", "()I", "consumerRRCounters", "", "Lxyz/xenondevs/nova/util/RoundRobinCounter;", "[Lxyz/xenondevs/nova/util/RoundRobinCounter;", "providerRRCounters", "[[Lxyz/xenondevs/nova/util/RoundRobinCounter;", "ignoredProviders", "Ljava/util/BitSet;", "[[Ljava/util/BitSet;", "providerSnapshots", "Lorg/bukkit/inventory/ItemStack;", "getProviderSnapshots", "()[[[Lorg/bukkit/inventory/ItemStack;", "setProviderSnapshots", "([[[Lorg/bukkit/inventory/ItemStack;)V", "[[[Lorg/bukkit/inventory/ItemStack;", "distribute", "transferAmount", "distributeBetween", "consumers", "ignoredProvidersPerConsumer", "consumerRR", "providersRR", "(ILjava/util/List;Ljava/util/List;[Ljava/util/BitSet;[[Lorg/bukkit/inventory/ItemStack;Lxyz/xenondevs/nova/util/RoundRobinCounter;[Lxyz/xenondevs/nova/util/RoundRobinCounter;)I", "createIgnoredConsumers", "distributeDirectlyBetween", "consumer", "provider", "providerSnapshot", "(ILxyz/xenondevs/nova/world/block/tileentity/network/type/item/channel/FilteredNetworkedInventory;Lxyz/xenondevs/nova/world/block/tileentity/network/type/item/channel/FilteredNetworkedInventory;[Lorg/bukkit/inventory/ItemStack;)I", "nova"})
@SourceDebugExtension(value={"SMAP\nItemDistributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemDistributor.kt\nxyz/xenondevs/nova/world/block/tileentity/network/type/item/channel/ItemDistributor\n+ 2 Arrays.kt\nxyz/xenondevs/commons/collections/ArraysKt\n*L\n1#1,225:1\n33#2:226\n*S KotlinDebug\n*F\n+ 1 ItemDistributor.kt\nxyz/xenondevs/nova/world/block/tileentity/network/type/item/channel/ItemDistributor\n*L\n85#1:226\n*E\n"})
public final class ItemDistributor {
    @NotNull
    private final Collection<NetworkedInventory> providers;
    @NotNull
    private final Collection<FilteredNetworkedInventory> filteredProviders;
    @NotNull
    private final List<List<FilteredNetworkedInventory>> providerLevels;
    @NotNull
    private final List<List<FilteredNetworkedInventory>> consumerLevels;
    private final int levels;
    @NotNull
    private final RoundRobinCounter[] consumerRRCounters;
    @NotNull
    private final RoundRobinCounter[][] providerRRCounters;
    @NotNull
    private final BitSet[][] ignoredProviders;
    public ItemStack[][][] providerSnapshots;

    public ItemDistributor(@NotNull Collection<? extends NetworkedInventory> providers, @NotNull Collection<FilteredNetworkedInventory> filteredProviders, @NotNull List<? extends List<FilteredNetworkedInventory>> providerLevels, @NotNull List<? extends List<FilteredNetworkedInventory>> consumerLevels) {
        RoundRobinCounter[] roundRobinCounterArray;
        int n;
        int n2;
        int consumerCount;
        int n3;
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        Intrinsics.checkNotNullParameter(filteredProviders, (String)"filteredProviders");
        Intrinsics.checkNotNullParameter(providerLevels, (String)"providerLevels");
        Intrinsics.checkNotNullParameter(consumerLevels, (String)"consumerLevels");
        this.providers = providers;
        this.filteredProviders = filteredProviders;
        this.providerLevels = providerLevels;
        this.consumerLevels = consumerLevels;
        this.levels = this.providerLevels.size();
        if (!(this.providerLevels.size() == this.consumerLevels.size())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int n4 = 0;
        int n5 = this.levels;
        RoundRobinCounter[] roundRobinCounterArray2 = new RoundRobinCounter[n5];
        ItemDistributor itemDistributor = this;
        while (n4 < n5) {
            n3 = n4++;
            consumerCount = this.consumerLevels.get(n3).size();
            roundRobinCounterArray2[n3] = new RoundRobinCounter(consumerCount);
        }
        itemDistributor.consumerRRCounters = roundRobinCounterArray2;
        n5 = this.levels;
        roundRobinCounterArray2 = new RoundRobinCounter[n5][];
        itemDistributor = this;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = n4;
            consumerCount = this.consumerLevels.get(n3).size();
            int providerCount = this.providerLevels.get(n3).size();
            n2 = 0;
            RoundRobinCounter[] roundRobinCounterArray3 = new RoundRobinCounter[consumerCount];
            n = n3;
            roundRobinCounterArray = roundRobinCounterArray2;
            while (n2 < consumerCount) {
                int n6 = n2++;
                roundRobinCounterArray3[n6] = new RoundRobinCounter(providerCount);
            }
            roundRobinCounterArray[n] = roundRobinCounterArray3;
        }
        itemDistributor.providerRRCounters = roundRobinCounterArray2;
        n5 = this.levels;
        roundRobinCounterArray2 = new BitSet[n5][];
        itemDistributor = this;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = n4;
            List<FilteredNetworkedInventory> consumersInLevel = this.consumerLevels.get(n3);
            List<FilteredNetworkedInventory> providersInLevel = this.providerLevels.get(n3);
            int n7 = consumersInLevel.size();
            BitSet[] bitSetArray = new BitSet[n7];
            n = n3;
            roundRobinCounterArray = roundRobinCounterArray2;
            for (n2 = 0; n2 < n7; ++n2) {
                int n8 = n2;
                FilteredNetworkedInventory consumer = consumersInLevel.get(n8);
                int providerCount = providersInLevel.size();
                BitSet ignoredProviders = new BitSet(providerCount);
                int n9 = n8;
                BitSet[] bitSetArray2 = bitSetArray;
                for (int providerIdx = 0; providerIdx < providerCount; ++providerIdx) {
                    FilteredNetworkedInventory provider = providersInLevel.get(providerIdx);
                    if (provider.canExchangeItemsWith(consumer)) continue;
                    ignoredProviders.set(providerIdx);
                }
                bitSetArray2[n9] = ignoredProviders;
            }
            roundRobinCounterArray[n] = bitSetArray;
        }
        itemDistributor.ignoredProviders = roundRobinCounterArray2;
    }

    @NotNull
    public final Collection<NetworkedInventory> getProviders() {
        return this.providers;
    }

    @NotNull
    public final Collection<FilteredNetworkedInventory> getFilteredProviders() {
        return this.filteredProviders;
    }

    @NotNull
    public final List<List<FilteredNetworkedInventory>> getProviderLevels() {
        return this.providerLevels;
    }

    @NotNull
    public final List<List<FilteredNetworkedInventory>> getConsumerLevels() {
        return this.consumerLevels;
    }

    public final int getLevels() {
        return this.levels;
    }

    @NotNull
    public final ItemStack[][][] getProviderSnapshots() {
        if (this.providerSnapshots != null) {
            return this.providerSnapshots;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"providerSnapshots");
        return null;
    }

    public final void setProviderSnapshots(@NotNull ItemStack[][][] itemStackArray) {
        Intrinsics.checkNotNullParameter((Object)itemStackArray, (String)"<set-?>");
        this.providerSnapshots = itemStackArray;
    }

    /*
     * WARNING - void declaration
     */
    public final int distribute(int transferAmount) {
        int transfersLeft = transferAmount;
        int n = this.levels;
        for (int level = 0; level < n; ++level) {
            List<FilteredNetworkedInventory> consumersInScope = this.consumerLevels.get(level);
            List<FilteredNetworkedInventory> providersInScope = this.providerLevels.get(level);
            if (consumersInScope.size() == 1 && providersInScope.size() == 1) {
                transfersLeft = this.distributeDirectlyBetween(transfersLeft, consumersInScope.get(0), providersInScope.get(0), this.getProviderSnapshots()[level][0]);
            } else if (!((Collection)consumersInScope).isEmpty() && !((Collection)providersInScope).isEmpty()) {
                BitSet[] bitSetArray;
                void $this$mapToArray$iv;
                BitSet[] bitSetArray2 = this.ignoredProviders[level];
                List<FilteredNetworkedInventory> list = providersInScope;
                List<FilteredNetworkedInventory> list2 = consumersInScope;
                int n2 = transfersLeft;
                ItemDistributor itemDistributor = this;
                boolean $i$f$mapToArray = false;
                int n3 = 0;
                int n4 = ((void)$this$mapToArray$iv).length;
                BitSet[] bitSetArray3 = new BitSet[n4];
                while (n3 < n4) {
                    BitSet bitSet;
                    void it;
                    int n5 = n3++;
                    void var13_13 = $this$mapToArray$iv[n5];
                    int n6 = n5;
                    bitSetArray = bitSetArray3;
                    boolean bl = false;
                    Object object = it.clone();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.BitSet");
                    bitSetArray[n6] = bitSet = (BitSet)object;
                }
                bitSetArray = bitSetArray3;
                transfersLeft = itemDistributor.distributeBetween(n2, list2, list, bitSetArray, this.getProviderSnapshots()[level], this.consumerRRCounters[level], this.providerRRCounters[level]);
            }
            if (transfersLeft <= 0) break;
        }
        return transfersLeft;
    }

    private final int distributeBetween(int transferAmount, List<FilteredNetworkedInventory> consumers, List<FilteredNetworkedInventory> providers, BitSet[] ignoredProvidersPerConsumer, ItemStack[][] providerSnapshots, RoundRobinCounter consumerRR, RoundRobinCounter[] providersRR) {
        int transfersLeft = transferAmount;
        BitSet ignoredConsumers = this.createIgnoredConsumers(consumers);
        while (transfersLeft > 0 && ignoredConsumers.nextClearBit(0) < consumers.size()) {
            int consumerIdx = consumerRR.next();
            if (ignoredConsumers.get(consumerIdx)) continue;
            FilteredNetworkedInventory consumer = consumers.get(consumerIdx);
            boolean hasConsumed = false;
            BitSet ignoredProviders = ignoredProvidersPerConsumer[consumerIdx];
            RoundRobinCounter providerRR = providersRR[consumerIdx];
            while (ignoredProviders.nextClearBit(0) < providers.size()) {
                int providerIdx = providerRR.next();
                if (ignoredProviders.get(providerIdx)) continue;
                FilteredNetworkedInventory provider = providers.get(providerIdx);
                ItemStack[] providerContent = providerSnapshots[providerIdx];
                boolean hasProvided = false;
                int n = providerContent.length;
                for (int j = 0; j < n; ++j) {
                    int slot = j;
                    ItemStack itemStack = providerContent[j];
                    if (itemStack.isEmpty() || consumer.denies(itemStack) || !provider.getInventory().canTake(slot, 1) || consumer.getInventory().add(itemStack, 1) != 0) continue;
                    provider.getInventory().take(slot, 1);
                    ItemStack itemStack2 = providerContent[slot];
                    int n2 = itemStack2.getAmount();
                    itemStack2.setAmount(n2 + -1);
                    --transfersLeft;
                    hasConsumed = true;
                    hasProvided = true;
                    break;
                }
                if (!hasProvided) {
                    ignoredProviders.set(providerIdx);
                }
                if (!hasConsumed) continue;
            }
            if (hasConsumed) continue;
            ignoredConsumers.set(consumerIdx);
        }
        return transfersLeft;
    }

    private final BitSet createIgnoredConsumers(List<FilteredNetworkedInventory> consumers) {
        BitSet bitSet = new BitSet(consumers.size());
        Iterator iterator = ((Iterable)consumers).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int idx = n++;
            FilteredNetworkedInventory consumer = (FilteredNetworkedInventory)iterator.next();
            if (!consumer.getInventory().isFull()) continue;
            bitSet.set(idx);
        }
        return bitSet;
    }

    private final int distributeDirectlyBetween(int transferAmount, FilteredNetworkedInventory consumer, FilteredNetworkedInventory provider, ItemStack[] providerSnapshot) {
        if (!consumer.canExchangeItemsWith(provider) || consumer.getInventory().isFull() || provider.getInventory().isEmpty()) {
            return transferAmount;
        }
        int transfersLeft = transferAmount;
        int n = providerSnapshot.length;
        for (int j = 0; j < n; ++j) {
            int slot = j;
            ItemStack itemStack = providerSnapshot[j];
            if (itemStack.isEmpty() || consumer.denies(itemStack)) continue;
            int idealAmount = Math.min(itemStack.getAmount(), transfersLeft);
            if (!provider.getInventory().canTake(slot, idealAmount)) continue;
            int transferred = idealAmount - consumer.getInventory().add(itemStack, idealAmount);
            provider.getInventory().take(slot, transferred);
            if ((transfersLeft -= transferred) <= 0) break;
        }
        return transfersLeft;
    }
}

