/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.format.chunk.container;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.world.format.IdResolver;
import xyz.xenondevs.nova.world.format.chunk.container.ArraySectionDataContainer;
import xyz.xenondevs.nova.world.format.chunk.container.MapSectionDataContainer;
import xyz.xenondevs.nova.world.format.chunk.container.SectionDataContainer;
import xyz.xenondevs.nova.world.format.chunk.data.CompactIntStorage;
import xyz.xenondevs.nova.world.format.chunk.palette.LinearPalette;
import xyz.xenondevs.nova.world.format.chunk.palette.Palette;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0017\b\u0004\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0017\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0004J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012H$J\b\u0010 \u001a\u00020\u0012H$R\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u00a4\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u0082\u0001\u0002!\"\u00a8\u0006#"}, d2={"Lxyz/xenondevs/nova/world/format/chunk/container/PalletizedSectionDataContainer;", "T", "Lxyz/xenondevs/nova/world/format/chunk/container/SectionDataContainer;", "idResolver", "Lxyz/xenondevs/nova/world/format/IdResolver;", "<init>", "(Lxyz/xenondevs/nova/world/format/IdResolver;)V", "palette", "Lxyz/xenondevs/nova/world/format/chunk/palette/Palette;", "getPalette", "()Lxyz/xenondevs/nova/world/format/chunk/palette/Palette;", "setPalette", "(Lxyz/xenondevs/nova/world/format/chunk/palette/Palette;)V", "data", "Lxyz/xenondevs/nova/world/format/chunk/data/CompactIntStorage;", "getData", "()Lxyz/xenondevs/nova/world/format/chunk/data/CompactIntStorage;", "bitsPerEntry", "", "getBitsPerEntry", "()I", "setBitsPerEntry", "(I)V", "toPalletizedId", "value", "(Ljava/lang/Object;)I", "remakePaletteResizeData", "", "remakePalette", "resizeData", "oldBitsPerEntry", "newBitsPerEntry", "determineBitsPerEntry", "Lxyz/xenondevs/nova/world/format/chunk/container/ArraySectionDataContainer;", "Lxyz/xenondevs/nova/world/format/chunk/container/MapSectionDataContainer;", "nova"})
public abstract sealed class PalletizedSectionDataContainer<T>
extends SectionDataContainer<T>
permits ArraySectionDataContainer, MapSectionDataContainer {
    private int bitsPerEntry;

    private PalletizedSectionDataContainer(IdResolver<T> idResolver) {
        super(idResolver, null);
    }

    @NotNull
    protected abstract Palette<T> getPalette();

    protected abstract void setPalette(@NotNull Palette<T> var1);

    @NotNull
    protected abstract CompactIntStorage getData();

    protected final int getBitsPerEntry() {
        return this.bitsPerEntry;
    }

    protected final void setBitsPerEntry(int n) {
        this.bitsPerEntry = n;
    }

    public final int toPalletizedId(@Nullable T value) {
        if (value == null) {
            return 0;
        }
        int existingId = this.getPalette().getId(value);
        if (existingId != 0) {
            return existingId;
        }
        int oldBitsPerEntry = this.bitsPerEntry;
        if (this.getPalette().getSize() >= 65535) {
            this.remakePalette();
        }
        if (this.getPalette() instanceof LinearPalette && this.getPalette().getSize() >= 16) {
            Palette<T> palette = this.getPalette();
            Intrinsics.checkNotNull(palette, (String)"null cannot be cast to non-null type xyz.xenondevs.nova.world.format.chunk.palette.LinearPalette<T of xyz.xenondevs.nova.world.format.chunk.container.PalletizedSectionDataContainer>");
            this.setPalette(((LinearPalette)palette).toHashPalette());
        }
        int newId = this.getPalette().putValue(value);
        int newBitsPerEntry = this.determineBitsPerEntry();
        if (newBitsPerEntry != oldBitsPerEntry) {
            this.resizeData(oldBitsPerEntry, newBitsPerEntry);
            this.bitsPerEntry = newBitsPerEntry;
        }
        return newId;
    }

    protected final void remakePaletteResizeData() {
        int oldBitsPerEntry = this.bitsPerEntry;
        this.remakePalette();
        int newBitsPerEntry = this.determineBitsPerEntry();
        if (oldBitsPerEntry != newBitsPerEntry) {
            this.bitsPerEntry = newBitsPerEntry;
            this.resizeData(oldBitsPerEntry, newBitsPerEntry);
        }
    }

    private final void remakePalette() {
        if (this.getPalette() instanceof LinearPalette) {
            return;
        }
        Palette<T> currentPalette = this.getPalette();
        Palette newPalette = new LinearPalette(this.getIdResolver());
        CompactIntStorage data2 = this.getData();
        for (int packedPos = 0; packedPos < 4096; ++packedPos) {
            T value;
            int oldPalletizedId = data2.get(packedPos);
            if (oldPalletizedId == 0) continue;
            Intrinsics.checkNotNull(currentPalette.getValue(oldPalletizedId));
            int newPalletizedId = newPalette.getId(value);
            if (newPalletizedId == 0) {
                if (newPalette instanceof LinearPalette && ((LinearPalette)newPalette).getSize() >= 16) {
                    newPalette = ((LinearPalette)newPalette).toHashPalette();
                }
                newPalletizedId = newPalette.putValue(value);
            }
            data2.set(packedPos, newPalletizedId);
        }
        this.setPalette(newPalette);
    }

    protected abstract void resizeData(int var1, int var2);

    protected abstract int determineBitsPerEntry();

    public /* synthetic */ PalletizedSectionDataContainer(IdResolver idResolver, DefaultConstructorMarker $constructor_marker) {
        this(idResolver);
    }
}

