/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.generation;

import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.block.NovaBlock;
import xyz.xenondevs.nova.world.format.WorldDataManager;
import xyz.xenondevs.nova.world.generation.ExperimentalWorldGen;

@ExperimentalWorldGen
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H&J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J.\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001dH\u0014J5\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010#J\u0018\u0010$\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006%"}, d2={"Lxyz/xenondevs/nova/world/generation/FeatureType;", "FC", "Lnet/minecraft/world/level/levelgen/feature/configurations/FeatureConfiguration;", "Lnet/minecraft/world/level/levelgen/feature/Feature;", "codec", "Lcom/mojang/serialization/Codec;", "<init>", "(Lcom/mojang/serialization/Codec;)V", "setBlock", "", "level", "Lnet/minecraft/world/level/WorldGenLevel;", "pos", "Lnet/minecraft/core/BlockPos;", "material", "Lorg/bukkit/Material;", "flags", "", "block", "Lxyz/xenondevs/nova/world/block/NovaBlock;", "place", "", "ctx", "Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;", "Lnet/minecraft/world/level/LevelWriter;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "safeSetBlock", "predicate", "Ljava/util/function/Predicate;", "config", "generator", "Lnet/minecraft/world/level/chunk/ChunkGenerator;", "random", "Lnet/minecraft/util/RandomSource;", "(Lnet/minecraft/world/level/levelgen/feature/configurations/FeatureConfiguration;Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/world/level/chunk/ChunkGenerator;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;)Z", "markAboveForPostProcessing", "nova"})
public abstract class FeatureType<FC extends FeatureConfiguration>
extends Feature<FC> {
    public FeatureType(@NotNull Codec<FC> codec) {
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        super(codec);
    }

    protected final void setBlock(@NotNull WorldGenLevel level, @NotNull BlockPos pos, @NotNull Material material) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        level.setBlock(pos, NMSUtilsKt.getNmsBlock(material).defaultBlockState(), 3);
    }

    protected final void setBlock(@NotNull WorldGenLevel level, @NotNull BlockPos pos, @NotNull Material material, int flags) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        level.setBlock(pos, NMSUtilsKt.getNmsBlock(material).defaultBlockState(), flags);
    }

    protected final void setBlock(@NotNull WorldGenLevel level, @NotNull BlockPos pos, @NotNull NovaBlock block) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        CraftWorld craftWorld = level.getLevel().getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)craftWorld, (String)"getWorld(...)");
        WorldDataManager.INSTANCE.setBlockState(NMSUtilsKt.toNovaPos(pos, (World)craftWorld), block.getDefaultBlockState());
    }

    public abstract boolean place(@NotNull FeaturePlaceContext<FC> var1);

    protected void setBlock(@NotNull LevelWriter level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.setBlock(level, pos, state);
    }

    protected void safeSetBlock(@NotNull WorldGenLevel level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Predicate<BlockState> predicate) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        super.safeSetBlock(level, pos, state, predicate);
    }

    public boolean place(@NotNull FC config, @NotNull WorldGenLevel level, @NotNull ChunkGenerator generator, @NotNull RandomSource random, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return super.place(config, level, generator, random, pos);
    }

    protected void markAboveForPostProcessing(@NotNull WorldGenLevel level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        super.markAboveForPostProcessing(level, pos);
    }
}

