/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.generation.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.key.Key;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.xenondevs.nova.registry.RegistryElementBuilder;
import xyz.xenondevs.nova.util.NMSUtilsKt;
import xyz.xenondevs.nova.world.generation.ExperimentalWorldGen;
import xyz.xenondevs.nova.world.generation.builder.BiomeClimateSettingsBuilder;
import xyz.xenondevs.nova.world.generation.builder.BiomeSpecialEffectsBuilder;
import xyz.xenondevs.nova.world.generation.builder.MobSpawnSettingsBuilder;

@ExperimentalWorldGen
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0012J\u001f\u0010\u0011\u001a\u00020\u001f2\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u001f0 \u00a2\u0006\u0002\b\"J\u000e\u0010\u001d\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001f\u0010\u001d\u001a\u00020\u001f2\u0017\u0010\u001d\u001a\u0013\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u001f0 \u00a2\u0006\u0002\b\"J\u000e\u0010\u0013\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0014J\u001f\u0010\u0013\u001a\u00020\u001f2\u0017\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001f0 \u00a2\u0006\u0002\b\"J3\u0010\u0015\u001a\u00020\u001f2&\u0010%\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0&0\u001a\"\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0&\u00a2\u0006\u0002\u0010'J3\u0010\u0019\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)2\u001e\u0010*\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00100&0\u001a\"\b\u0012\u0004\u0012\u00020\u00100&\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020\u0002H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u000e*\b\u0012\u0002\b\u0003\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00100\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0015\u001a&\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u00170\u0016j\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u0017`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00170\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lxyz/xenondevs/nova/world/generation/builder/BiomeBuilder;", "Lxyz/xenondevs/nova/registry/RegistryElementBuilder;", "Lnet/minecraft/world/level/biome/Biome;", "id", "Lnet/kyori/adventure/key/Key;", "registry", "Lnet/minecraft/core/WritableRegistry;", "lookup", "Lnet/minecraft/resources/RegistryOps$RegistryInfoLookup;", "<init>", "(Lnet/kyori/adventure/key/Key;Lnet/minecraft/core/WritableRegistry;Lnet/minecraft/resources/RegistryOps$RegistryInfoLookup;)V", "configuredCarverRegistry", "Lnet/minecraft/core/HolderGetter;", "Lnet/minecraft/world/level/levelgen/carver/ConfiguredWorldCarver;", "kotlin.jvm.PlatformType", "placedFeatureRegistry", "Lnet/minecraft/world/level/levelgen/placement/PlacedFeature;", "climateSettings", "Lnet/minecraft/world/level/biome/Biome$ClimateSettings;", "specialEffects", "Lnet/minecraft/world/level/biome/BiomeSpecialEffects;", "carvers", "Ljava/util/ArrayList;", "Lnet/minecraft/core/Holder;", "Lkotlin/collections/ArrayList;", "features", "", "", "[Ljava/util/List;", "mobSpawnSettings", "Lnet/minecraft/world/level/biome/MobSpawnSettings;", "", "Lkotlin/Function1;", "Lxyz/xenondevs/nova/world/generation/builder/BiomeClimateSettingsBuilder;", "Lkotlin/ExtensionFunctionType;", "Lxyz/xenondevs/nova/world/generation/builder/MobSpawnSettingsBuilder;", "Lxyz/xenondevs/nova/world/generation/builder/BiomeSpecialEffectsBuilder;", "configuredCarvers", "Lnet/minecraft/resources/ResourceKey;", "([Lnet/minecraft/resources/ResourceKey;)V", "step", "Lnet/minecraft/world/level/levelgen/GenerationStep$Decoration;", "placedFeatures", "(Lnet/minecraft/world/level/levelgen/GenerationStep$Decoration;[Lnet/minecraft/resources/ResourceKey;)V", "build", "nova"})
@SourceDebugExtension(value={"SMAP\nBiomeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BiomeBuilder.kt\nxyz/xenondevs/nova/world/generation/builder/BiomeBuilder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,726:1\n11561#2:727\n11896#2,3:728\n*S KotlinDebug\n*F\n+ 1 BiomeBuilder.kt\nxyz/xenondevs/nova/world/generation/builder/BiomeBuilder\n*L\n153#1:727\n153#1:728,3\n*E\n"})
public final class BiomeBuilder
extends RegistryElementBuilder<Biome> {
    @NotNull
    private final RegistryOps.RegistryInfoLookup lookup;
    @NotNull
    private final HolderGetter<ConfiguredWorldCarver<?>> configuredCarverRegistry;
    @NotNull
    private final HolderGetter<PlacedFeature> placedFeatureRegistry;
    @Nullable
    private Biome.ClimateSettings climateSettings;
    @Nullable
    private BiomeSpecialEffects specialEffects;
    @NotNull
    private final ArrayList<Holder<ConfiguredWorldCarver<?>>> carvers;
    @NotNull
    private final List<Holder<PlacedFeature>>[] features;
    @Nullable
    private MobSpawnSettings mobSpawnSettings;

    public BiomeBuilder(@NotNull Key id, @NotNull WritableRegistry<Biome> registry, @NotNull RegistryOps.RegistryInfoLookup lookup2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)lookup2, (String)"lookup");
        super(registry, id);
        this.lookup = lookup2;
        ResourceKey resourceKey = Registries.CONFIGURED_CARVER;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"CONFIGURED_CARVER");
        this.configuredCarverRegistry = NMSUtilsKt.lookupGetterOrThrow(this.lookup, resourceKey);
        ResourceKey resourceKey2 = Registries.PLACED_FEATURE;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey2, (String)"PLACED_FEATURE");
        this.placedFeatureRegistry = NMSUtilsKt.lookupGetterOrThrow(this.lookup, resourceKey2);
        this.carvers = new ArrayList();
        int n = 0;
        List[] listArray = new List[11];
        BiomeBuilder biomeBuilder = this;
        while (n < 11) {
            int n2 = n++;
            listArray[n2] = new ArrayList();
        }
        biomeBuilder.features = listArray;
    }

    public final void climateSettings(@NotNull Biome.ClimateSettings climateSettings) {
        Intrinsics.checkNotNullParameter((Object)climateSettings, (String)"climateSettings");
        this.climateSettings = climateSettings;
    }

    public final void climateSettings(@NotNull Function1<? super BiomeClimateSettingsBuilder, Unit> climateSettings) {
        Intrinsics.checkNotNullParameter(climateSettings, (String)"climateSettings");
        BiomeClimateSettingsBuilder biomeClimateSettingsBuilder = new BiomeClimateSettingsBuilder();
        climateSettings.invoke((Object)biomeClimateSettingsBuilder);
        this.climateSettings = biomeClimateSettingsBuilder.build();
    }

    public final void mobSpawnSettings(@NotNull MobSpawnSettings mobSpawnSettings) {
        Intrinsics.checkNotNullParameter((Object)mobSpawnSettings, (String)"mobSpawnSettings");
        this.mobSpawnSettings = mobSpawnSettings;
    }

    public final void mobSpawnSettings(@NotNull Function1<? super MobSpawnSettingsBuilder, Unit> mobSpawnSettings) {
        Intrinsics.checkNotNullParameter(mobSpawnSettings, (String)"mobSpawnSettings");
        MobSpawnSettingsBuilder mobSpawnSettingsBuilder = new MobSpawnSettingsBuilder();
        mobSpawnSettings.invoke((Object)mobSpawnSettingsBuilder);
        this.mobSpawnSettings = mobSpawnSettingsBuilder.build$nova();
    }

    public final void specialEffects(@NotNull BiomeSpecialEffects specialEffects) {
        Intrinsics.checkNotNullParameter((Object)specialEffects, (String)"specialEffects");
        this.specialEffects = specialEffects;
    }

    public final void specialEffects(@NotNull Function1<? super BiomeSpecialEffectsBuilder, Unit> specialEffects) {
        Intrinsics.checkNotNullParameter(specialEffects, (String)"specialEffects");
        BiomeSpecialEffectsBuilder biomeSpecialEffectsBuilder = new BiomeSpecialEffectsBuilder(this.lookup);
        specialEffects.invoke((Object)biomeSpecialEffectsBuilder);
        this.specialEffects = biomeSpecialEffectsBuilder.build$nova();
    }

    public final void carvers(ResourceKey<ConfiguredWorldCarver<?>> ... configuredCarvers) {
        Intrinsics.checkNotNullParameter(configuredCarvers, (String)"configuredCarvers");
        for (ResourceKey<ConfiguredWorldCarver<?>> key : configuredCarvers) {
            ((Collection)this.carvers).add(this.configuredCarverRegistry.getOrThrow(key));
        }
    }

    public final void features(@NotNull GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... placedFeatures) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        Intrinsics.checkNotNullParameter(placedFeatures, (String)"placedFeatures");
        for (ResourceKey<PlacedFeature> key : placedFeatures) {
            ((Collection)this.features[step.ordinal()]).add(this.placedFeatureRegistry.getOrThrow(key));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Biome build() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        BiomeSpecialEffects biomeSpecialEffects;
        Biome.ClimateSettings climateSettings;
        Biome.ClimateSettings climateSettings2 = this.climateSettings;
        if (climateSettings2 == null) {
            climateSettings2 = climateSettings = new BiomeClimateSettingsBuilder().build();
        }
        if ((biomeSpecialEffects = this.specialEffects) == null) {
            biomeSpecialEffects = new BiomeSpecialEffectsBuilder(this.lookup).build$nova();
        }
        BiomeSpecialEffects specialEffects = biomeSpecialEffects;
        List<Holder<PlacedFeature>>[] listArray = this.features;
        HolderSet holderSet = (HolderSet)HolderSet.direct((List)this.carvers);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var12_12 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(HolderSet.direct((List)it));
        }
        List list = (List)destination$iv$iv;
        HolderSet holderSet2 = holderSet;
        BiomeGenerationSettings generationSettings = new BiomeGenerationSettings(holderSet2, list);
        MobSpawnSettings mobSpawnSettings = this.mobSpawnSettings;
        if (mobSpawnSettings == null) {
            mobSpawnSettings = MobSpawnSettings.EMPTY;
        }
        MobSpawnSettings mobSpawnSettings2 = mobSpawnSettings;
        return new Biome(climateSettings, specialEffects, generationSettings, mobSpawnSettings2);
    }
}

