/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.item.behavior;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.util.NMSUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001:\u0001\u0010J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J \u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH&J(\u0010\f\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lxyz/xenondevs/nova/world/item/behavior/BowLogic;", "", "canDraw", "", "entity", "Lorg/bukkit/entity/LivingEntity;", "bow", "Lorg/bukkit/inventory/ItemStack;", "handleDrawTick", "", "tick", "", "shoot", "hand", "Lorg/bukkit/inventory/EquipmentSlot;", "chargeTime", "Vanilla", "nova"})
public interface BowLogic {
    public boolean canDraw(@NotNull LivingEntity var1, @NotNull ItemStack var2);

    public void handleDrawTick(@NotNull LivingEntity var1, @NotNull ItemStack var2, int var3);

    @NotNull
    public ItemStack shoot(@NotNull LivingEntity var1, @NotNull EquipmentSlot var2, @NotNull ItemStack var3, int var4);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\rH\u0016\u00a8\u0006\u0012"}, d2={"Lxyz/xenondevs/nova/world/item/behavior/BowLogic$Vanilla;", "Lxyz/xenondevs/nova/world/item/behavior/BowLogic;", "<init>", "()V", "canDraw", "", "entity", "Lorg/bukkit/entity/LivingEntity;", "bow", "Lorg/bukkit/inventory/ItemStack;", "handleDrawTick", "", "tick", "", "shoot", "hand", "Lorg/bukkit/inventory/EquipmentSlot;", "chargeTime", "nova"})
    @SourceDebugExtension(value={"SMAP\nBow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bow.kt\nxyz/xenondevs/nova/world/item/behavior/BowLogic$Vanilla\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1761#2,3:168\n*S KotlinDebug\n*F\n+ 1 Bow.kt\nxyz/xenondevs/nova/world/item/behavior/BowLogic$Vanilla\n*L\n54#1:168,3\n*E\n"})
    public static final class Vanilla
    implements BowLogic {
        @NotNull
        public static final Vanilla INSTANCE = new Vanilla();

        private Vanilla() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean canDraw(@NotNull LivingEntity entity, @NotNull ItemStack bow) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)bow, (String)"bow");
            if (entity instanceof Player && ((Player)entity).getGameMode() == GameMode.CREATIVE) {
                return true;
            }
            if (!(entity instanceof InventoryHolder)) return false;
            Inventory inventory = ((InventoryHolder)entity).getInventory();
            Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"getInventory(...)");
            Iterable $this$any$iv = (Iterable)inventory;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                ItemStack it = (ItemStack)element$iv;
                boolean bl2 = false;
                if (it != null && Tag.ITEMS_ARROWS.isTagged((Keyed)it.getType())) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        @Override
        public void handleDrawTick(@NotNull LivingEntity entity, @NotNull ItemStack bow, int tick2) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)bow, (String)"bow");
        }

        @Override
        @NotNull
        public ItemStack shoot(@NotNull LivingEntity entity, @NotNull EquipmentSlot hand, @NotNull ItemStack bow, int chargeTime) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
            Intrinsics.checkNotNullParameter((Object)bow, (String)"bow");
            net.minecraft.world.entity.LivingEntity nmsEntity = NMSUtilsKt.getNmsEntity(entity);
            net.minecraft.world.item.ItemStack projectile = nmsEntity.getProjectile(NMSUtilsKt.unwrap(ItemStack.of((Material)Material.BOW)));
            if (projectile.isEmpty()) {
                return bow;
            }
            float powerForTime = BowItem.getPowerForTime((int)chargeTime);
            if ((double)powerForTime < 0.1) {
                return bow;
            }
            List projectileItems = ProjectileWeaponItem.draw((net.minecraft.world.item.ItemStack)NMSUtilsKt.unwrap(bow), (net.minecraft.world.item.ItemStack)projectile, (net.minecraft.world.entity.LivingEntity)nmsEntity);
            if (projectileItems.isEmpty()) {
                return bow;
            }
            Level level = nmsEntity.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel level2 = (ServerLevel)level;
            Item item = Items.BOW;
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.minecraft.world.item.BowItem");
            ((BowItem)item).shoot(level2, nmsEntity, NMSUtilsKt.getNmsInteractionHand(hand), NMSUtilsKt.unwrap(bow), projectileItems, powerForTime * 3.0f, 1.0f, powerForTime == 1.0f, null, powerForTime);
            level2.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level2.random.nextFloat() * 0.4f + 1.2f) + powerForTime * 0.5f);
            return bow;
        }
    }
}

