/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.loot;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.NovaBootstrapperKt;
import xyz.xenondevs.nova.addon.Addon;
import xyz.xenondevs.nova.addon.AddonBootstrapper;
import xyz.xenondevs.nova.initialize.InitFun;
import xyz.xenondevs.nova.initialize.InternalInit;
import xyz.xenondevs.nova.initialize.InternalInitStage;
import xyz.xenondevs.nova.resources.ResourcePath;
import xyz.xenondevs.nova.serialization.json.GsonKt;
import xyz.xenondevs.nova.util.data.UpdatableFile;
import xyz.xenondevs.nova.world.loot.LootGeneration;
import xyz.xenondevs.nova.world.loot.LootTable;

@InternalInit(stage=InternalInitStage.POST_WORLD)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0002\u00a8\u0006\u0007"}, d2={"Lxyz/xenondevs/nova/world/loot/LootConfigHandler;", "", "<init>", "()V", "init", "", "loadLootTables", "nova"})
@SourceDebugExtension(value={"SMAP\nLootConfigHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LootConfigHandler.kt\nxyz/xenondevs/nova/world/loot/LootConfigHandler\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Gson.kt\nxyz/xenondevs/commons/gson/GsonKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1321#2:43\n1322#2:47\n43#3:44\n22#3:46\n1#4:45\n*S KotlinDebug\n*F\n+ 1 LootConfigHandler.kt\nxyz/xenondevs/nova/world/loot/LootConfigHandler\n*L\n30#1:43\n30#1:47\n31#1:44\n31#1:46\n31#1:45\n*E\n"})
public final class LootConfigHandler {
    @NotNull
    public static final LootConfigHandler INSTANCE = new LootConfigHandler();

    private LootConfigHandler() {
    }

    @InitFun
    private final void init() {
        UpdatableFile.INSTANCE.extractIdNamedFromAllAddons$nova("loot");
        this.loadLootTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void loadLootTables() {
        for (Addon addon : AddonBootstrapper.getAddons()) {
            Path path = addon.getDataFolder().resolve("loot");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Sequence $this$forEach$iv = SequencesKt.filter((Sequence)PathsKt.walk((Path)path, (PathWalkOption[])new PathWalkOption[0]), LootConfigHandler::loadLootTables$lambda$0);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                Path file = (Path)element$iv;
                boolean bl = false;
                Gson gson = GsonKt.getGSON();
                Path file$iv = file;
                boolean $i$f$fromJson = false;
                Object object2 = file$iv;
                OpenOption[] openOptionArray = new OpenOption[]{};
                Object object3 = Charsets.UTF_8;
                int n = 8192;
                object2 = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object2, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object3), n);
                object3 = null;
                try {
                    void $this$fromJson$iv;
                    BufferedReader it$iv = (BufferedReader)object2;
                    boolean bl2 = false;
                    boolean $i$f$javaTypeOf = false;
                    object = $this$fromJson$iv.fromJson((Reader)it$iv, TypesJVMKt.getJavaType((KType)Reflection.typeOf(LootTable.class)));
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
                }
                LootTable lootTable = (LootTable)object;
                if (lootTable == null) {
                    NovaBootstrapperKt.getLOGGER().error("Failed to load loot table " + PathsKt.getName((Path)file));
                    continue;
                }
                LootGeneration.INSTANCE.register(lootTable);
            }
        }
    }

    private static final boolean loadLootTables$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && Intrinsics.areEqual((Object)PathsKt.getExtension((Path)it), (Object)"json") && ResourcePath.Companion.isValidPath(PathsKt.getName((Path)it));
    }
}

