/*
 * Decompiled with CFR 0.152.
 */
package xyz.xenondevs.nova.world.loot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.world.LootGenerateEvent;
import org.jetbrains.annotations.NotNull;
import xyz.xenondevs.nova.initialize.Dispatcher;
import xyz.xenondevs.nova.initialize.InitFun;
import xyz.xenondevs.nova.initialize.InternalInit;
import xyz.xenondevs.nova.initialize.InternalInitStage;
import xyz.xenondevs.nova.util.EventUtilsKt;
import xyz.xenondevs.nova.world.loot.LootConfigHandler;
import xyz.xenondevs.nova.world.loot.LootTable;

@InternalInit(stage=InternalInitStage.POST_WORLD, dispatcher=Dispatcher.ASYNC, dependsOn={LootConfigHandler.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0003J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0003J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0018H\u0003J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0010R1\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u000e\u0012\f0\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\t0\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lxyz/xenondevs/nova/world/loot/LootGeneration;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "entityKeys", "", "Lorg/bukkit/entity/EntityType;", "Lorg/bukkit/NamespacedKey;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "getEntityKeys", "()Ljava/util/Map;", "entityKeys$delegate", "Lkotlin/Lazy;", "lootTables", "Ljava/util/ArrayList;", "Lxyz/xenondevs/nova/world/loot/LootTable;", "Lkotlin/collections/ArrayList;", "init", "", "handleLootGenerationEvent", "event", "Lorg/bukkit/event/world/LootGenerateEvent;", "handleEntityDeath", "Lorg/bukkit/event/entity/EntityDeathEvent;", "register", "loot", "nova"})
@SourceDebugExtension(value={"SMAP\nLootGeneration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LootGeneration.kt\nxyz/xenondevs/nova/world/loot/LootGeneration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1869#2,2:53\n1869#2,2:55\n1285#2,2:57\n1299#2,4:59\n*S KotlinDebug\n*F\n+ 1 LootGeneration.kt\nxyz/xenondevs/nova/world/loot/LootGeneration\n*L\n32#1:53,2\n42#1:55,2\n22#1:57,2\n22#1:59,4\n*E\n"})
public final class LootGeneration
implements Listener {
    @NotNull
    public static final LootGeneration INSTANCE = new LootGeneration();
    @NotNull
    private static final Lazy entityKeys$delegate = LazyKt.lazy(LootGeneration::entityKeys_delegate$lambda$0);
    @NotNull
    private static final ArrayList<LootTable> lootTables = new ArrayList();

    private LootGeneration() {
    }

    private final Map<EntityType, NamespacedKey> getEntityKeys() {
        Lazy lazy = entityKeys$delegate;
        return (Map)lazy.getValue();
    }

    @InitFun
    private final void init() {
        EventUtilsKt.registerEvents(this);
    }

    @EventHandler
    private final void handleLootGenerationEvent(LootGenerateEvent event) {
        Iterable $this$forEach$iv = lootTables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LootTable loot = (LootTable)element$iv;
            boolean bl = false;
            if (event.getLootTable() == null) continue;
            NamespacedKey namespacedKey = event.getLootTable().getKey();
            Intrinsics.checkNotNullExpressionValue((Object)namespacedKey, (String)"getKey(...)");
            if (!loot.isAllowed(namespacedKey)) continue;
            event.getLoot().addAll((Collection)loot.getRandomItems());
        }
    }

    @EventHandler
    private final void handleEntityDeath(EntityDeathEvent event) {
        NamespacedKey namespacedKey = this.getEntityKeys().get(event.getEntityType());
        if (namespacedKey == null) {
            return;
        }
        NamespacedKey key = namespacedKey;
        Iterable $this$forEach$iv = lootTables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LootTable loot = (LootTable)element$iv;
            boolean bl = false;
            if (!loot.isAllowed(key)) continue;
            event.getDrops().addAll((Collection)loot.getRandomItems());
        }
    }

    public final void register(@NotNull LootTable loot) {
        Intrinsics.checkNotNullParameter((Object)loot, (String)"loot");
        lootTables.add(loot);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map entityKeys_delegate$lambda$0() {
        void $this$associateWithTo$iv$iv;
        Iterable $this$associateWith$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            EntityType entityType = (EntityType)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            String string = it.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            NamespacedKey namespacedKey = NamespacedKey.minecraft((String)("entities/" + string));
            map2.put(t, namespacedKey);
        }
        return destination$iv$iv;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EntityType> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EntityType.values()));
        }
    }
}

